@extends('layouts.app')

@section('title', 'Detalhes do Utilizador')

@section('content')
<div class="py-6">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="flex items-center justify-between mb-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 h-16 w-16">
                    <div class="h-16 w-16 rounded-full bg-blue-500 flex items-center justify-center text-white text-2xl font-bold">
                        {{ strtoupper(substr($user->name, 0, 1)) }}
                    </div>
                </div>
                <div class="ml-4">
                    <h1 class="text-2xl font-bold text-gray-900">{{ $user->name }}</h1>
                    <p class="text-sm text-gray-600">{{ $user->email }}</p>
                </div>
            </div>
            <div class="flex gap-2">
                <a href="{{ route('admin.usuarios.divisoes.show', $user) }}" class="bg-green-600 hover:bg-green-700 text-white py-2 px-4 rounded-md">
                    <i class="fas fa-map-marker-alt mr-1"></i> Divisoes
                </a>
                <a href="{{ route('admin.usuarios.edit', $user) }}" class="bg-yellow-600 hover:bg-yellow-700 text-white py-2 px-4 rounded-md">
                    <i class="fas fa-edit mr-1"></i> Editar
                </a>
                <a href="{{ route('admin.usuarios.index') }}" class="text-gray-600 hover:text-gray-900 py-2 px-4">
                    <i class="fas fa-arrow-left mr-1"></i> Voltar
                </a>
            </div>
        </div>

        @if(session('success'))
        <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
            {{ session('success') }}
        </div>
        @endif

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Informacoes Basicas -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Informacoes Basicas</h3>

                <dl class="space-y-3">
                    <div class="flex justify-between">
                        <dt class="text-sm text-gray-500">Nome</dt>
                        <dd class="text-sm text-gray-900">{{ $user->name }}</dd>
                    </div>
                    <div class="flex justify-between">
                        <dt class="text-sm text-gray-500">Email</dt>
                        <dd class="text-sm text-gray-900">{{ $user->email }}</dd>
                    </div>
                    <div class="flex justify-between">
                        <dt class="text-sm text-gray-500">Telefone</dt>
                        <dd class="text-sm text-gray-900">{{ $user->telefone ?? '-' }}</dd>
                    </div>
                    <div class="flex justify-between">
                        <dt class="text-sm text-gray-500">Cargo</dt>
                        <dd class="text-sm text-gray-900">{{ $user->cargo ?? '-' }}</dd>
                    </div>
                    <div class="flex justify-between">
                        <dt class="text-sm text-gray-500">Departamento</dt>
                        <dd class="text-sm text-gray-900">{{ $user->departamento ?? '-' }}</dd>
                    </div>
                    <div class="flex justify-between">
                        <dt class="text-sm text-gray-500">Status</dt>
                        <dd>
                            @if($user->ativo)
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                Activo
                            </span>
                            @else
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                Inactivo
                            </span>
                            @endif
                        </dd>
                    </div>
                    <div class="flex justify-between">
                        <dt class="text-sm text-gray-500">Criado em</dt>
                        <dd class="text-sm text-gray-900">{{ $user->created_at->format('d/m/Y H:i') }}</dd>
                    </div>
                </dl>
            </div>

            <!-- Roles e Permissoes -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Roles e Permissoes</h3>

                <div class="mb-4">
                    <h4 class="text-sm font-medium text-gray-700 mb-2">Roles</h4>
                    <div class="flex flex-wrap gap-2">
                        @forelse($user->roles as $role)
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium
                            @if($role->name == 'Administrador') bg-red-100 text-red-800
                            @elseif($role->name == 'Tecnico Senior') bg-purple-100 text-purple-800
                            @elseif($role->name == 'Tecnico') bg-blue-100 text-blue-800
                            @elseif($role->name == 'Operador') bg-green-100 text-green-800
                            @else bg-gray-100 text-gray-800
                            @endif">
                            {{ $role->name }}
                        </span>
                        @empty
                        <span class="text-gray-400 text-sm italic">Sem roles atribuidas</span>
                        @endforelse
                    </div>
                </div>

                <div>
                    <h4 class="text-sm font-medium text-gray-700 mb-2">Tipo de Acesso</h4>
                    @if($user->acesso_global)
                    <div class="flex items-center p-3 bg-yellow-50 border border-yellow-200 rounded-lg">
                        <i class="fas fa-globe text-yellow-600 mr-2"></i>
                        <span class="text-sm text-yellow-800">Acesso Global - Pode ver todas as divisoes</span>
                    </div>
                    @else
                    <div class="flex items-center p-3 bg-blue-50 border border-blue-200 rounded-lg">
                        <i class="fas fa-map-marker-alt text-blue-600 mr-2"></i>
                        <span class="text-sm text-blue-800">Acesso Regional - Limitado as divisoes atribuidas</span>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Divisoes Atribuidas -->
        <div class="mt-6 bg-white rounded-lg shadow p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-medium text-gray-900">Divisoes Atribuidas</h3>
                <a href="{{ route('admin.usuarios.divisoes.show', $user) }}" class="text-blue-600 hover:text-blue-800 text-sm">
                    <i class="fas fa-cog mr-1"></i> Gerir Divisoes
                </a>
            </div>

            @if($user->acesso_global)
            <div class="text-center py-8 text-gray-500">
                <i class="fas fa-globe text-4xl mb-4 text-yellow-400"></i>
                <p>Este utilizador tem acesso global a todas as divisoes.</p>
            </div>
            @elseif($user->divisoesAtivas->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                @foreach($user->divisoesAtivas as $userDivisao)
                <div class="border rounded-lg p-4 {{ $userDivisao->is_primary ? 'border-blue-500 bg-blue-50' : '' }}">
                    <div class="flex items-start justify-between">
                        <div>
                            <h4 class="font-medium text-gray-900">
                                {{ $userDivisao->divisao?->nome ?? 'N/A' }}
                                @if($userDivisao->is_primary)
                                <span class="ml-1 text-xs text-blue-600">(Principal)</span>
                                @endif
                            </h4>
                            <p class="text-xs text-gray-500 capitalize">{{ $userDivisao->divisao?->tipo ?? '' }}</p>
                        </div>
                        <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium
                            {{ $userDivisao->nivel_acesso == 'full' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                            {{ $userDivisao->nivel_acesso == 'full' ? 'Completo' : 'Directo' }}
                        </span>
                    </div>
                    @if($userDivisao->valido_ate)
                    <p class="mt-2 text-xs text-orange-600">
                        <i class="fas fa-clock mr-1"></i>
                        Valido ate {{ $userDivisao->valido_ate->format('d/m/Y') }}
                    </p>
                    @endif
                </div>
                @endforeach
            </div>
            @else
            <div class="text-center py-8 text-gray-500">
                <i class="fas fa-map-marker-alt text-4xl mb-4 text-gray-300"></i>
                <p>Nenhuma divisao atribuida a este utilizador.</p>
                <a href="{{ route('admin.usuarios.divisoes.show', $user) }}" class="mt-2 inline-block text-blue-600 hover:text-blue-800">
                    <i class="fas fa-plus mr-1"></i> Atribuir Divisoes
                </a>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection
