<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Sistema Hidrológico') }} - @yield('title', 'Dashboard')</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Icons -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @livewireStyles
</head>
<body class="font-sans antialiased bg-gray-50">
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <aside id="sidebar" class="w-64 bg-blue-900 text-white transform transition-transform duration-300 ease-in-out lg:translate-x-0 -translate-x-full fixed lg:static h-full z-50">
            <div class="flex items-center justify-center h-16 border-b border-blue-800">
                <h1 class="text-xl font-bold">
                    <i class="fas fa-water mr-2"></i>
                    Sistema Hidrológico
                </h1>
            </div>
            
            <nav class="mt-8">
                <div class="px-4 space-y-2">
                    <!-- Dashboard -->
                    <a href="{{ route('dashboard') }}" 
                       class="flex items-center px-4 py-3 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('dashboard') ? 'bg-blue-800' : '' }}">
                        <i class="fas fa-chart-line mr-3"></i>
                        Dashboard
                    </a>

                    <!-- Barragens -->
                    <div class="space-y-1">
                        <div class="flex items-center px-4 py-3 text-blue-300 text-sm font-medium uppercase tracking-wider">
                            <i class="fas fa-dam mr-3"></i>
                            Barragens
                        </div>
                        <a href="{{ route('barragens.index') }}"
                           class="flex items-center px-8 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('barragens.*') ? 'bg-blue-800' : '' }}">
                            <i class="fas fa-list mr-3"></i>
                            Listar Barragens
                        </a>
                        <a href="{{ route('barragens.create') }}"
                           class="flex items-center px-8 py-2 rounded-lg hover:bg-blue-800 transition-colors">
                            <i class="fas fa-plus mr-3"></i>
                            Nova Barragem
                        </a>
                        <a href="{{ route('curvas.correspondencias') }}"
                           class="flex items-center px-8 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('curvas.correspondencias') ? 'bg-blue-800' : '' }}">
                            <i class="fas fa-chart-area mr-3"></i>
                            Correspondências de Curvas
                        </a>
                    </div>

                    <!-- Estações -->
                    <div class="space-y-1">
                        <div class="flex items-center px-4 py-3 text-blue-300 text-sm font-medium uppercase tracking-wider">
                            <i class="fas fa-broadcast-tower mr-3"></i>
                            Estações
                        </div>
                        <a href="{{ route('estacoes.index') }}" 
                           class="flex items-center px-8 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('estacoes.*') ? 'bg-blue-800' : '' }}">
                            <i class="fas fa-list mr-3"></i>
                            Listar Estações
                        </a>
                        <a href="{{ route('estacoes.create') }}" 
                           class="flex items-center px-8 py-2 rounded-lg hover:bg-blue-800 transition-colors">
                            <i class="fas fa-plus mr-3"></i>
                            Nova Estação
                        </a>
                    </div>

                    <!-- Boletins -->
                    <div class="space-y-1">
                        <div class="flex items-center px-4 py-3 text-blue-300 text-sm font-medium uppercase tracking-wider">
                            <i class="fas fa-file-alt mr-3"></i>
                            Boletins
                        </div>
                        <a href="{{ route('boletins.index') }}" 
                           class="flex items-center px-8 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('boletins.*') ? 'bg-blue-800' : '' }}">
                            <i class="fas fa-list mr-3"></i>
                            Listar Boletins
                        </a>
                        <a href="{{ route('boletins.create') }}" 
                           class="flex items-center px-8 py-2 rounded-lg hover:bg-blue-800 transition-colors">
                            <i class="fas fa-plus mr-3"></i>
                            Novo Boletim
                        </a>
                    </div>

                    <!-- Alertas -->
                    <a href="{{ route('alertas.index') }}"
                       class="flex items-center px-4 py-3 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('alertas.*') ? 'bg-blue-800' : '' }}">
                        <i class="fas fa-exclamation-triangle mr-3"></i>
                        Alertas
                        @if($alertas_count = \App\Models\Alerta::where('estado', 'activo')->count())
                            <span class="ml-auto bg-red-500 text-white text-xs rounded-full px-2 py-1">{{ $alertas_count }}</span>
                        @endif
                    </a>

                    <!-- Estatísticas -->
                    <a href="{{ route('estatisticas.index') }}"
                       class="flex items-center px-4 py-3 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('estatisticas.*') ? 'bg-blue-800' : '' }}">
                        <i class="fas fa-chart-bar mr-3"></i>
                        Estatísticas
                    </a>

                    <!-- Importação -->
                    <a href="{{ route('importacao.index') }}"
                       class="flex items-center px-4 py-3 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('importacao.*') ? 'bg-blue-800' : '' }}">
                        <i class="fas fa-upload mr-3"></i>
                        Importação
                    </a>
                </div>
            </nav>
        </aside>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col">
            <!-- Header -->
            <header class="bg-white shadow-sm border-b border-gray-200">
                <div class="px-6 py-4">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <button id="sidebar-toggle" class="lg:hidden mr-4 text-gray-500 hover:text-gray-700">
                                <i class="fas fa-bars text-xl"></i>
                            </button>
                            <h2 class="text-2xl font-semibold text-gray-800">
                                @yield('title', 'Dashboard')
                            </h2>
                        </div>
                        
                        <div class="flex items-center space-x-4">
                            <!-- Notifications -->
                            <div class="relative">
                                <button class="text-gray-500 hover:text-gray-700 relative">
                                    <i class="fas fa-bell text-xl"></i>
                                    @if($alertas_count = \App\Models\Alerta::where('estado', 'activo')->count())
                                        <span class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center">{{ $alertas_count }}</span>
                                    @endif
                                </button>
                            </div>

                            <!-- User Menu -->
                            <div class="relative" x-data="{ open: false }">
                                <button @click="open = !open" class="flex items-center text-gray-700 hover:text-gray-900">
                                    <div class="w-8 h-8 bg-blue-600 rounded-full flex items-center justify-center text-white text-sm font-medium mr-2">
                                        {{ substr(auth()->user()->name, 0, 1) }}
                                    </div>
                                    <span class="font-medium">{{ auth()->user()->name }}</span>
                                    <i class="fas fa-chevron-down ml-2 text-sm"></i>
                                </button>

                                <div x-show="open" @click.away="open = false"
                                     class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg border border-gray-200 z-50">
                                    <div class="py-2">
                                        {{-- <a href="{{ route('user.profile') }}" class="block px-4 py-2 text-gray-700 hover:bg-gray-100">
                                            <i class="fas fa-user mr-2"></i>
                                            Perfil
                                        </a>
                                        <hr class="my-2"> --}}
                                        <form method="POST" action="{{ route('logout') }}">
                                            @csrf
                                            <button type="submit" class="w-full text-left px-4 py-2 text-gray-700 hover:bg-gray-100">
                                                <i class="fas fa-sign-out-alt mr-2"></i>
                                                Sair
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 overflow-y-auto">
                <!-- Alert Messages -->
                @if(session('success'))
                    <div class="mx-6 mt-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
                        <span class="block sm:inline">{{ session('success') }}</span>
                        <span class="absolute top-0 bottom-0 right-0 px-4 py-3">
                            <i class="fas fa-times cursor-pointer" onclick="this.parentElement.parentElement.style.display='none'"></i>
                        </span>
                    </div>
                @endif

                @if(session('error'))
                    <div class="mx-6 mt-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                        <span class="block sm:inline">{{ session('error') }}</span>
                        <span class="absolute top-0 bottom-0 right-0 px-4 py-3">
                            <i class="fas fa-times cursor-pointer" onclick="this.parentElement.parentElement.style.display='none'"></i>
                        </span>
                    </div>
                @endif

                @if($errors->any())
                    <div class="mx-6 mt-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                        <strong class="font-bold">Erro!</strong>
                        <ul class="mt-2">
                            @foreach($errors->all() as $error)
                                <li>• {{ $error }}</li>
                            @endforeach
                        </ul>
                        <span class="absolute top-0 bottom-0 right-0 px-4 py-3">
                            <i class="fas fa-times cursor-pointer" onclick="this.parentElement.style.display='none'"></i>
                        </span>
                    </div>
                @endif

                <div class="p-6">
                    @yield('content')
                </div>
            </main>
        </div>
    </div>

    <!-- Sidebar Overlay for Mobile -->
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 lg:hidden hidden"></div>

    <script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    
    <script>
        // Sidebar Toggle
        document.getElementById('sidebar-toggle').addEventListener('click', function() {
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebar-overlay');
            
            sidebar.classList.toggle('-translate-x-full');
            overlay.classList.toggle('hidden');
        });

        // Close sidebar when clicking overlay
        document.getElementById('sidebar-overlay').addEventListener('click', function() {
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebar-overlay');
            
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
        });

        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('[role="alert"]');
            alerts.forEach(function(alert) {
                alert.style.transition = 'opacity 0.5s';
                alert.style.opacity = '0';
                setTimeout(function() {
                    alert.style.display = 'none';
                }, 500);
            });
        }, 5000);
    </script>

    @stack('scripts')
    @livewireScripts
</body>
</html>