@extends('layouts.app')

@section('title', 'Editar Bacia Hidrográfica')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-edit mr-3 text-cyan-600"></i>
                    Editar Bacia Hidrográfica
                </h1>
                <p class="text-gray-600 mt-2">{{ $bacia->nome }} ({{ $bacia->codigo }})</p>
            </div>
            <div class="flex space-x-4">
                <a href="{{ route('bacias.show', $bacia) }}" 
                   class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors">
                    <i class="fas fa-eye mr-2"></i>
                    Ver Detalhes
                </a>
                <a href="{{ route('bacias.index') }}" 
                   class="bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700 transition-colors">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Voltar à Lista
                </a>
            </div>
        </div>
    </div>

    <!-- Formulário -->
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">
                <i class="fas fa-water mr-2 text-cyan-600"></i>
                Informações da Bacia Hidrográfica
            </h3>
        </div>
        
        <form method="POST" action="{{ route('bacias.update', $bacia) }}" class="p-6 space-y-6">
            @csrf
            @method('PUT')
            
            <!-- Identificação -->
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                <h4 class="text-sm font-semibold text-blue-800 uppercase tracking-wide mb-4">
                    <i class="fas fa-id-card mr-2"></i>
                    Identificação
                </h4>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Nome da Bacia *</label>
                        <input type="text" name="nome" value="{{ old('nome', $bacia->nome) }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 @error('nome') border-red-500 @enderror"
                               placeholder="Ex: Bacia do Rio Zambeze">
                        @error('nome')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Código *</label>
                        <input type="text" name="codigo" value="{{ old('codigo', $bacia->codigo) }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 @error('codigo') border-red-500 @enderror"
                               placeholder="Ex: BRZ-001">
                        @error('codigo')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Características Físicas -->
            <div class="bg-green-50 border border-green-200 rounded-lg p-4">
                <h4 class="text-sm font-semibold text-green-800 uppercase tracking-wide mb-4">
                    <i class="fas fa-mountain mr-2"></i>
                    Características Físicas
                </h4>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Área da Bacia (km²)</label>
                        <input type="number" name="area_km2" value="{{ old('area_km2', $bacia->area_km2) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 @error('area_km2') border-red-500 @enderror"
                               placeholder="Ex: 1570000">
                        @error('area_km2')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                        <p class="text-xs text-gray-500 mt-1">Área total da bacia hidrográfica em quilômetros quadrados</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Comprimento do Rio Principal (km)</label>
                        <input type="number" name="comprimento_rio_principal" value="{{ old('comprimento_rio_principal', $bacia->comprimento_rio_principal) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 @error('comprimento_rio_principal') border-red-500 @enderror"
                               placeholder="Ex: 2574">
                        @error('comprimento_rio_principal')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                        <p class="text-xs text-gray-500 mt-1">Comprimento do curso principal de água</p>
                    </div>
                </div>
            </div>

            <!-- Abrangência Geográfica -->
            <div class="bg-purple-50 border border-purple-200 rounded-lg p-4">
                <h4 class="text-sm font-semibold text-purple-800 uppercase tracking-wide mb-4">
                    <i class="fas fa-map-marked-alt mr-2"></i>
                    Abrangência Geográfica
                </h4>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-3">Províncias Abrangidas *</label>

                    @php
                        $provinciasPorRegiao = \App\Helpers\ProvinciaHelper::getProvinciasPorRegiao();
                        $selected = old('provincias_abrangidas', $bacia->provincias_abrangidas ?? []);
                        if (!is_array($selected)) {
                            $selected = [];
                        }
                    @endphp

                    <div class="space-y-4">
                        @foreach($provinciasPorRegiao as $regiao => $provincias)
                            <div class="bg-white rounded-lg border border-gray-200 p-3">
                                <h5 class="text-sm font-semibold text-gray-800 mb-2 flex items-center">
                                    @if($regiao == 'Norte')
                                        <i class="fas fa-arrow-up text-blue-500 mr-2"></i>
                                    @elseif($regiao == 'Centro')
                                        <i class="fas fa-arrows-alt-h text-green-500 mr-2"></i>
                                    @else
                                        <i class="fas fa-arrow-down text-orange-500 mr-2"></i>
                                    @endif
                                    Região {{ $regiao }}
                                </h5>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-2">
                                    @foreach($provincias as $provincia)
                                        <label class="flex items-center space-x-2 p-2 rounded-md hover:bg-gray-50 cursor-pointer">
                                            <input type="checkbox"
                                                   name="provincias_abrangidas[]"
                                                   value="{{ $provincia }}"
                                                   {{ in_array($provincia, $selected) ? 'checked' : '' }}
                                                   class="w-4 h-4 text-purple-600 border-gray-300 rounded focus:ring-purple-500">
                                            <span class="text-sm text-gray-900">{{ $provincia }}</span>
                                        </label>
                                    @endforeach
                                </div>
                            </div>
                        @endforeach
                    </div>

                    @error('provincias_abrangidas')
                        <p class="text-red-500 text-xs mt-2">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Descrição -->
            <div class="bg-gray-50 border border-gray-200 rounded-lg p-4">
                <h4 class="text-sm font-semibold text-gray-800 uppercase tracking-wide mb-4">
                    <i class="fas fa-file-text mr-2"></i>
                    Descrição e Observações
                </h4>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Descrição</label>
                    <textarea name="descricao" rows="4"
                              class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 @error('descricao') border-red-500 @enderror"
                              placeholder="Descrição detalhada da bacia hidrográfica, incluindo características importantes, afluentes principais, etc.">{{ old('descricao', $bacia->descricao) }}</textarea>
                    @error('descricao')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Botões -->
            <div class="flex items-center justify-between pt-6 border-t border-gray-200">
                <div>
                    <form method="POST" action="{{ route('bacias.destroy', $bacia) }}" 
                          class="inline" onsubmit="return confirm('Tem certeza que deseja excluir esta bacia hidrográfica? Esta ação não pode ser desfeita.')">
                        @csrf
                        @method('DELETE')
                        <button type="submit"
                                class="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700 transition-colors">
                            <i class="fas fa-trash mr-2"></i>
                            Excluir Bacia
                        </button>
                    </form>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="{{ route('bacias.show', $bacia) }}" 
                       class="px-6 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50 transition-colors">
                        <i class="fas fa-times mr-2"></i>
                        Cancelar
                    </a>
                    <button type="submit"
                            class="px-6 py-2 bg-cyan-600 text-white rounded-md hover:bg-cyan-700 transition-colors">
                        <i class="fas fa-save mr-2"></i>
                        Atualizar Bacia
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection