@extends('layouts.app')

@section('title', 'Editar Barragem')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-edit mr-3 text-blue-600"></i>
                    Editar Barragem
                </h1>
                <p class="text-gray-600 mt-2">Atualizar dados da barragem {{ $barragem->nome }}</p>
            </div>
            <div class="flex space-x-3">
                <a href="{{ route('barragens.show', $barragem) }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg flex items-center">
                    <i class="fas fa-eye mr-2"></i>
                    Ver Barragem
                </a>
                <a href="{{ route('barragens.index') }}" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-lg flex items-center">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Voltar
                </a>
            </div>
        </div>
    </div>

    <!-- Form -->
    <div class="bg-white rounded-lg shadow">
        <form action="{{ route('barragens.update', $barragem) }}" method="POST" class="p-6 space-y-6">
            @csrf
            @method('PUT')
            
            <!-- Informações Básicas -->
            <div>
                <h3 class="text-lg font-medium text-gray-900 mb-4">Informações Básicas</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="nome" class="block text-sm font-medium text-gray-700 mb-2">Nome da Barragem *</label>
                        <input type="text" id="nome" name="nome" value="{{ old('nome', $barragem->nome) }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('nome') border-red-500 @enderror">
                        @error('nome')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="codigo" class="block text-sm font-medium text-gray-700 mb-2">Código *</label>
                        <input type="text" id="codigo" name="codigo" value="{{ old('codigo', $barragem->codigo) }}" required
                               placeholder="BAR-001"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('codigo') border-red-500 @enderror">
                        @error('codigo')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="bacia_hidrografica_id" class="block text-sm font-medium text-gray-700 mb-2">Bacia Hidrográfica</label>
                        <select id="bacia_hidrografica_id" name="bacia_hidrografica_id" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Selecione a bacia</option>
                            @foreach($bacias as $bacia)
                                <option value="{{ $bacia->id }}" {{ old('bacia_hidrografica_id', $barragem->bacia_hidrografica_id) == $bacia->id ? 'selected' : '' }}>
                                    {{ $bacia->nome }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label for="estado" class="block text-sm font-medium text-gray-700 mb-2">Estado *</label>
                        <select id="estado" name="estado" required class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="activa" {{ old('estado', $barragem->estado) == 'activa' ? 'selected' : '' }}>Ativa</option>
                            <option value="inactiva" {{ old('estado', $barragem->estado) == 'inactiva' ? 'selected' : '' }}>Inativa</option>
                            <option value="manutencao" {{ old('estado', $barragem->estado) == 'manutencao' ? 'selected' : '' }}>Manutenção</option>
                        </select>
                        @error('estado')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Localização -->
            <div>
                <h3 class="text-lg font-medium text-gray-900 mb-4">Localização</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    <div class="md:col-span-2">
                        <label for="divisao_administrativa_id" class="block text-sm font-medium text-gray-700 mb-2">Divisão Administrativa *</label>
                        <select id="divisao_administrativa_id" name="divisao_administrativa_id" required
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Seleccione...</option>
                            @foreach(\App\Models\DivisaoAdministrativa::whereIn('tipo', ['provincia', 'distrito'])->orderBy('tipo')->orderBy('nome')->get()->groupBy('tipo') as $tipo => $divisoes)
                            <optgroup label="{{ ucfirst($tipo) }}s">
                                @foreach($divisoes as $divisao)
                                <option value="{{ $divisao->id }}" {{ old('divisao_administrativa_id', $barragem->divisao_administrativa_id) == $divisao->id ? 'selected' : '' }}>
                                    {{ $divisao->nome }}{{ $divisao->parent ? ' (' . $divisao->parent->nome . ')' : '' }}
                                </option>
                                @endforeach
                            </optgroup>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label for="latitude" class="block text-sm font-medium text-gray-700 mb-2">Latitude</label>
                        <input type="number" id="latitude" name="latitude" value="{{ old('latitude', $barragem->latitude) }}" step="0.00000001"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>

                    <div>
                        <label for="longitude" class="block text-sm font-medium text-gray-700 mb-2">Longitude</label>
                        <input type="number" id="longitude" name="longitude" value="{{ old('longitude', $barragem->longitude) }}" step="0.00000001"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                </div>
            </div>

            <!-- Cotas e Níveis Técnicos -->
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-blue-800 mb-4 flex items-center">
                    <i class="fas fa-ruler-vertical mr-2"></i>
                    Cotas e Níveis Técnicos
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <label for="cota_maxima" class="block text-sm font-medium text-gray-700 mb-2">Cota Máxima (m)</label>
                        <input type="number" id="cota_maxima" name="cota_maxima" value="{{ old('cota_maxima', $barragem->cota_maxima) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <p class="text-xs text-gray-500 mt-1">Nível máximo de operação</p>
                    </div>
                    <div>
                        <label for="cota_minima" class="block text-sm font-medium text-gray-700 mb-2">Cota Mínima (m)</label>
                        <input type="number" id="cota_minima" name="cota_minima" value="{{ old('cota_minima', $barragem->cota_minima) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <p class="text-xs text-gray-500 mt-1">Nível mínimo operacional</p>
                    </div>
                    <div>
                        <label for="cota_npa" class="block text-sm font-medium text-gray-700 mb-2">Nivel Pleno de Armazenamento - NPA (m)</label>
                        <input type="number" id="cota_npa" name="cota_npa" value="{{ old('cota_npa', $barragem->cota_npa) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <p class="text-xs text-gray-500 mt-1">Nivel ideal de armazenamento da barragem (cota absoluta)</p>
                    </div>
                    <div>
                        <label for="escala_npa" class="block text-sm font-medium text-gray-700 mb-2">Escala NPA (m)</label>
                        <input type="number" id="escala_npa" name="escala_npa" value="{{ old('escala_npa', $barragem->escala_npa) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <p class="text-xs text-gray-500 mt-1">Leitura na regua/escala quando no NPA (para calculo: Cota = NPA - (Escala - Nivel))</p>
                    </div>
                    <div>
                        <label for="cota_nme" class="block text-sm font-medium text-gray-700 mb-2">Nivel Minimo de Exploracao - NME (m)</label>
                        <input type="number" id="cota_nme" name="cota_nme" value="{{ old('cota_nme', $barragem->cota_nme) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <p class="text-xs text-gray-500 mt-1">O menor nível para operação normal da barragem</p>
                    </div>
                    <div>
                        <label for="cota_nmc" class="block text-sm font-medium text-gray-700 mb-2">Nível Máximo de Cheia - NMC (m)</label>
                        <input type="number" id="cota_nmc" name="cota_nmc" value="{{ old('cota_nmc', $barragem->cota_nmc) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <p class="text-xs text-gray-500 mt-1">Nível máximo seguro antes de riscos críticos</p>
                    </div>
                    <div>
                        <label for="nivel_descargador" class="block text-sm font-medium text-gray-700 mb-2">Nível Descargador (m)</label>
                        <input type="number" id="nivel_descargador" name="nivel_descargador" value="{{ old('nivel_descargador', $barragem->nivel_descargador) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <p class="text-xs text-gray-500 mt-1">Cota do descargador</p>
                    </div>
                </div>
            </div>

            <!-- Volumes e Capacidades -->
            <div class="bg-green-50 border border-green-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-green-800 mb-4 flex items-center">
                    <i class="fas fa-tint mr-2"></i>
                    Volumes e Capacidades
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <label for="volume_maximo" class="block text-sm font-medium text-gray-700 mb-2">Volume Máximo (Mm³)</label>
                        <input type="number" id="volume_maximo" name="volume_maximo" value="{{ old('volume_maximo', $barragem->volume_maximo) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                        <p class="text-xs text-gray-500 mt-1">Capacidade máxima</p>
                    </div>
                    <div>
                        <label for="volume_morto" class="block text-sm font-medium text-gray-700 mb-2">Volume Morto (Mm³)</label>
                        <input type="number" id="volume_morto" name="volume_morto" value="{{ old('volume_morto', $barragem->volume_morto) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                        <p class="text-xs text-gray-500 mt-1">Volume não utilizável</p>
                    </div>
                    <div>
                        <label for="volume_util" class="block text-sm font-medium text-gray-700 mb-2">Volume Útil (Mm³)</label>
                        <input type="number" id="volume_util" name="volume_util" value="{{ old('volume_util', $barragem->volume_util) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                        <p class="text-xs text-gray-500 mt-1">Volume aproveitável - Se vazio, será calculado automaticamente</p>
                    </div>
                    <div>
                        <label for="capacidade_total" class="block text-sm font-medium text-gray-700 mb-2">Capacidade Total (Mm³)</label>
                        <input type="number" id="capacidade_total" name="capacidade_total" value="{{ old('capacidade_total', $barragem->capacidade_total) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                        <p class="text-xs text-gray-500 mt-1">Capacidade total da albufeira</p>
                    </div>
                    <div>
                        <label for="area_bacia_hidraulica" class="block text-sm font-medium text-gray-700 mb-2">Área Bacia Hidráulica (km²)</label>
                        <input type="number" id="area_bacia_hidraulica" name="area_bacia_hidraulica" value="{{ old('area_bacia_hidraulica', $barragem->area_bacia_hidraulica) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                        <p class="text-xs text-gray-500 mt-1">Área de drenagem</p>
                    </div>
                </div>
            </div>

            <!-- Características Físicas -->
            <div class="bg-purple-50 border border-purple-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-purple-800 mb-4 flex items-center">
                    <i class="fas fa-mountain mr-2"></i>
                    Características Físicas
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <label for="area_inundacao" class="block text-sm font-medium text-gray-700 mb-2">Área de Inundação (m²)</label>
                        <input type="number" id="area_inundacao" name="area_inundacao" value="{{ old('area_inundacao', $barragem->area_inundacao) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-purple-500">
                        <p class="text-xs text-gray-500 mt-1">Área total inundada</p>
                    </div>
                    <div>
                        <label for="altura_barragem" class="block text-sm font-medium text-gray-700 mb-2">Altura da Barragem (m)</label>
                        <input type="number" id="altura_barragem" name="altura_barragem" value="{{ old('altura_barragem', $barragem->altura_barragem) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-purple-500">
                        <p class="text-xs text-gray-500 mt-1">Altura máxima da estrutura</p>
                    </div>
                    <div>
                        <label for="comprimento_crista" class="block text-sm font-medium text-gray-700 mb-2">Comprimento da Crista (m)</label>
                        <input type="number" id="comprimento_crista" name="comprimento_crista" value="{{ old('comprimento_crista', $barragem->comprimento_crista) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-purple-500">
                        <p class="text-xs text-gray-500 mt-1">Extensão do coroamento</p>
                    </div>
                </div>
            </div>


            <!-- Classificação Técnica -->
            <div class="bg-indigo-50 border border-indigo-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-indigo-800 mb-4 flex items-center">
                    <i class="fas fa-tags mr-2"></i>
                    Classificação Técnica
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <label for="tipo_barragem" class="block text-sm font-medium text-gray-700 mb-2">Tipo de Barragem</label>
                        <select id="tipo_barragem" name="tipo_barragem" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500">
                            <option value="terra" {{ old('tipo_barragem', $barragem->tipo_barragem) == 'terra' ? 'selected' : '' }}>Terra</option>
                            <option value="betao" {{ old('tipo_barragem', $barragem->tipo_barragem) == 'betao' ? 'selected' : '' }}>Betão</option>
                            <option value="enrocamento" {{ old('tipo_barragem', $barragem->tipo_barragem) == 'enrocamento' ? 'selected' : '' }}>Enrocamento</option>
                            <option value="mista" {{ old('tipo_barragem', $barragem->tipo_barragem) == 'mista' ? 'selected' : '' }}>Mista</option>
                            <option value="gravidade" {{ old('tipo_barragem', $barragem->tipo_barragem) == 'gravidade' ? 'selected' : '' }}>Gravidade</option>
                            <option value="arco" {{ old('tipo_barragem', $barragem->tipo_barragem) == 'arco' ? 'selected' : '' }}>Arco</option>
                            <option value="contraforte" {{ old('tipo_barragem', $barragem->tipo_barragem) == 'contraforte' ? 'selected' : '' }}>Contraforte</option>
                        </select>
                        <p class="text-xs text-gray-500 mt-1">Tipo construtivo da estrutura</p>
                    </div>
                    <div>
                        <label for="finalidade_principal" class="block text-sm font-medium text-gray-700 mb-2">Finalidade Principal</label>
                        <select id="finalidade_principal" name="finalidade_principal" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500">
                            <option value="abastecimento" {{ old('finalidade_principal', $barragem->finalidade_principal) == 'abastecimento' ? 'selected' : '' }}>Abastecimento</option>
                            <option value="irrigacao" {{ old('finalidade_principal', $barragem->finalidade_principal) == 'irrigacao' ? 'selected' : '' }}>Irrigação</option>
                            <option value="energia" {{ old('finalidade_principal', $barragem->finalidade_principal) == 'energia' ? 'selected' : '' }}>Energia</option>
                            <option value="controle_cheias" {{ old('finalidade_principal', $barragem->finalidade_principal) == 'controle_cheias' ? 'selected' : '' }}>Controle de Cheias</option>
                            <option value="recreacao" {{ old('finalidade_principal', $barragem->finalidade_principal) == 'recreacao' ? 'selected' : '' }}>Recreação</option>
                            <option value="piscicultura" {{ old('finalidade_principal', $barragem->finalidade_principal) == 'piscicultura' ? 'selected' : '' }}>Piscicultura</option>
                            <option value="multipla" {{ old('finalidade_principal', $barragem->finalidade_principal) == 'multipla' ? 'selected' : '' }}>Múltipla</option>
                        </select>
                        <p class="text-xs text-gray-500 mt-1">Uso principal da barragem</p>
                    </div>
                    <div>
                        <label for="tipo_descargador" class="block text-sm font-medium text-gray-700 mb-2">Tipo de Descargador</label>
                        <select id="tipo_descargador" name="tipo_descargador" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500">
                            <option value="">Selecione...</option>
                            <option value="superficie" {{ old('tipo_descargador', $barragem->tipo_descargador) == 'superficie' ? 'selected' : '' }}>Superfície</option>
                            <option value="fundo" {{ old('tipo_descargador', $barragem->tipo_descargador) == 'fundo' ? 'selected' : '' }}>Fundo</option>
                            <option value="lateral" {{ old('tipo_descargador', $barragem->tipo_descargador) == 'lateral' ? 'selected' : '' }}>Lateral</option>
                            <option value="tunel" {{ old('tipo_descargador', $barragem->tipo_descargador) == 'tunel' ? 'selected' : '' }}>Túnel</option>
                            <option value="misto" {{ old('tipo_descargador', $barragem->tipo_descargador) == 'misto' ? 'selected' : '' }}>Misto</option>
                        </select>
                        <p class="text-xs text-gray-500 mt-1">Sistema de descarga</p>
                    </div>
                    <div>
                        <label for="classe_risco" class="block text-sm font-medium text-gray-700 mb-2">Classe de Risco</label>
                        <select id="classe_risco" name="classe_risco" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500">
                            <option value="baixo" {{ old('classe_risco', $barragem->classe_risco) == 'baixo' ? 'selected' : '' }}>Baixo</option>
                            <option value="medio" {{ old('classe_risco', $barragem->classe_risco) == 'medio' ? 'selected' : '' }}>Médio</option>
                            <option value="alto" {{ old('classe_risco', $barragem->classe_risco) == 'alto' ? 'selected' : '' }}>Alto</option>
                        </select>
                        <p class="text-xs text-gray-500 mt-1">Avaliação de risco estrutural</p>
                    </div>
                    <div>
                        <label for="categoria_dano" class="block text-sm font-medium text-gray-700 mb-2">Categoria de Dano</label>
                        <select id="categoria_dano" name="categoria_dano" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500">
                            <option value="baixo" {{ old('categoria_dano', $barragem->categoria_dano) == 'baixo' ? 'selected' : '' }}>Baixo</option>
                            <option value="medio" {{ old('categoria_dano', $barragem->categoria_dano) == 'medio' ? 'selected' : '' }}>Médio</option>
                            <option value="alto" {{ old('categoria_dano', $barragem->categoria_dano) == 'alto' ? 'selected' : '' }}>Alto</option>
                        </select>
                        <p class="text-xs text-gray-500 mt-1">Potencial de dano</p>
                    </div>
                </div>
            </div>

            <!-- Características Hidrológicas -->
            <div class="bg-cyan-50 border border-cyan-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-cyan-800 mb-4 flex items-center">
                    <i class="fas fa-water mr-2"></i>
                    Características Hidrológicas
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="rio_principal" class="block text-sm font-medium text-gray-700 mb-2">Rio Principal</label>
                        <input type="text" id="rio_principal" name="rio_principal" value="{{ old('rio_principal', $barragem->rio_principal) }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500">
                        <p class="text-xs text-gray-500 mt-1">Curso d'água principal</p>
                    </div>
                    <div>
                        <label for="afluentes" class="block text-sm font-medium text-gray-700 mb-2">
                            <i class="fas fa-water mr-2 text-cyan-500"></i>
                            Afluentes (Tributários)
                        </label>
                        <div class="relative">
                            <input type="text" id="afluentes_input"
                                   placeholder="Digite o nome de um rio e pressione Enter..."
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500">
                            <div id="afluentes_suggestions" class="hidden absolute z-10 w-full bg-white border border-gray-300 rounded-md shadow-lg max-h-32 overflow-y-auto"></div>
                        </div>

                        <!-- Tags dos afluentes selecionados -->
                        <div id="afluentes_tags" class="mt-2 flex flex-wrap gap-2">
                            @php
                                $afluentes_array = is_array($barragem->afluentes) ? $barragem->afluentes : explode(',', $barragem->afluentes ?? '');
                                $afluentes_array = array_filter(array_map('trim', $afluentes_array));
                            @endphp
                            @foreach($afluentes_array as $afluente)
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-cyan-100 text-cyan-800">
                                    {{ $afluente }}
                                    <button type="button" onclick="removeAfluenteTag(this)" class="ml-1 text-cyan-600 hover:text-cyan-800">×</button>
                                </span>
                            @endforeach
                        </div>

                        <!-- Input hidden com os valores finais -->
                        <input type="hidden" name="afluentes" id="afluentes_hidden"
                               value="{{ old('afluentes', is_array($barragem->afluentes) ? implode(',', $barragem->afluentes) : $barragem->afluentes) }}">

                        <p class="text-xs text-gray-500 mt-1">
                            <i class="fas fa-info-circle mr-1"></i>
                            Digite nomes de rios tributários. Pressione Enter para adicionar cada um.
                        </p>
                    </div>
                    <div class="md:col-span-2">
                        <label for="estacoes_pluviometricas" class="block text-sm font-medium text-gray-700 mb-2">
                            <i class="fas fa-cloud-rain mr-2 text-blue-500"></i>
                            Estações Pluviométricas Associadas
                        </label>
                        <select id="estacoes_pluviometricas" name="estacoes_pluviometricas[]" multiple
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 @error('estacoes_pluviometricas') border-red-500 @enderror"
                                style="min-height: 120px;">
                            @foreach(App\Models\Estacao::where('tipo', 'pluviometrica')->orderBy('nome')->get() as $estacao)
                                <option value="{{ $estacao->id }}"
                                    {{ in_array($estacao->id, old('estacoes_pluviometricas', $barragem->estacoes_pluviometricas ?? [])) ? 'selected' : '' }}>
                                    {{ $estacao->nome }} ({{ $estacao->codigo }}) - {{ $estacao->provincia }}
                                </option>
                            @endforeach
                        </select>
                        <p class="text-xs text-gray-500 mt-1">
                            <i class="fas fa-info-circle mr-1"></i>
                            Selecione múltiplas estações usando Ctrl+Click (Windows) ou Cmd+Click (Mac)
                        </p>
                        @error('estacoes_pluviometricas')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Informações do Projeto -->
            <div class="bg-gray-50 border border-gray-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-building mr-2"></i>
                    Informações do Projeto
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <label for="ano_construcao" class="block text-sm font-medium text-gray-700 mb-2">Ano de Construção</label>
                        <input type="number" id="ano_construcao" name="ano_construcao" value="{{ old('ano_construcao', $barragem->ano_construcao) }}" 
                               min="1900" max="{{ date('Y') }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-gray-500">
                        <p class="text-xs text-gray-500 mt-1">Ano de conclusão da obra</p>
                    </div>
                    <div>
                        <label for="ano_projeto" class="block text-sm font-medium text-gray-700 mb-2">Ano do Projeto</label>
                        <input type="number" id="ano_projeto" name="ano_projeto" value="{{ old('ano_projeto', $barragem->ano_projeto) }}" 
                               min="1900" max="{{ date('Y') }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-gray-500">
                        <p class="text-xs text-gray-500 mt-1">Ano de elaboração do projeto</p>
                    </div>
                    <div>
                        <label for="ano_inicio_construcao" class="block text-sm font-medium text-gray-700 mb-2">Início da Construção</label>
                        <input type="number" id="ano_inicio_construcao" name="ano_inicio_construcao" value="{{ old('ano_inicio_construcao', $barragem->ano_inicio_construcao) }}" 
                               min="1900" max="{{ date('Y') }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-gray-500">
                        <p class="text-xs text-gray-500 mt-1">Início das obras</p>
                    </div>
                    <div>
                        <label for="ano_conclusao" class="block text-sm font-medium text-gray-700 mb-2">Ano de Conclusão</label>
                        <input type="number" id="ano_conclusao" name="ano_conclusao" value="{{ old('ano_conclusao', $barragem->ano_conclusao) }}" 
                               min="1900" max="{{ date('Y') }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-gray-500">
                        <p class="text-xs text-gray-500 mt-1">Término das obras</p>
                    </div>
                    <div>
                        <label for="empresa_projetista" class="block text-sm font-medium text-gray-700 mb-2">Empresa Projetista</label>
                        <input type="text" id="empresa_projetista" name="empresa_projetista" value="{{ old('empresa_projetista', $barragem->empresa_projetista) }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-gray-500">
                        <p class="text-xs text-gray-500 mt-1">Responsável pelo projeto</p>
                    </div>
                    <div>
                        <label for="empresa_construtora" class="block text-sm font-medium text-gray-700 mb-2">Empresa Construtora</label>
                        <input type="text" id="empresa_construtora" name="empresa_construtora" value="{{ old('empresa_construtora', $barragem->empresa_construtora) }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-gray-500">
                        <p class="text-xs text-gray-500 mt-1">Responsável pela construção</p>
                    </div>
                </div>
            </div>

            <!-- Características Operacionais -->
            <div class="bg-orange-50 border border-orange-200 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-orange-800 mb-4 flex items-center">
                    <i class="fas fa-cogs mr-2"></i>
                    Características Operacionais
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <label class="flex items-center space-x-3">
                            <input type="checkbox" id="sistema_automatizado" name="sistema_automatizado" value="1" 
                                   {{ old('sistema_automatizado', $barragem->sistema_automatizado) ? 'checked' : '' }}
                                   class="w-5 h-5 text-orange-600 bg-gray-100 border-gray-300 rounded focus:ring-orange-500">
                            <span class="text-sm font-medium text-gray-700">Sistema Automatizado</span>
                        </label>
                        <p class="text-xs text-gray-500 mt-1">Possui automação de controle</p>
                    </div>
                    <div>
                        <label class="flex items-center space-x-3">
                            <input type="checkbox" id="telemetria" name="telemetria" value="1" 
                                   {{ old('telemetria', $barragem->telemetria) ? 'checked' : '' }}
                                   class="w-5 h-5 text-orange-600 bg-gray-100 border-gray-300 rounded focus:ring-orange-500">
                            <span class="text-sm font-medium text-gray-700">Sistema de Telemetria</span>
                        </label>
                        <p class="text-xs text-gray-500 mt-1">Monitoramento remoto</p>
                    </div>
                    <div>
                        <label for="frequencia_monitoramento" class="block text-sm font-medium text-gray-700 mb-2">Frequência de Monitoramento</label>
                        <select id="frequencia_monitoramento" name="frequencia_monitoramento" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-orange-500">
                            <option value="diario" {{ old('frequencia_monitoramento', $barragem->frequencia_monitoramento) == 'diario' ? 'selected' : '' }}>Diário</option>
                            <option value="semanal" {{ old('frequencia_monitoramento', $barragem->frequencia_monitoramento) == 'semanal' ? 'selected' : '' }}>Semanal</option>
                            <option value="mensal" {{ old('frequencia_monitoramento', $barragem->frequencia_monitoramento) == 'mensal' ? 'selected' : '' }}>Mensal</option>
                            <option value="continuo" {{ old('frequencia_monitoramento', $barragem->frequencia_monitoramento) == 'continuo' ? 'selected' : '' }}>Contínuo</option>
                        </select>
                        <p class="text-xs text-gray-500 mt-1">Periodicidade das leituras</p>
                    </div>
                </div>
            </div>

            <!-- Observações -->
            <div>
                <label for="observacoes" class="block text-sm font-medium text-gray-700 mb-2">Observações</label>
                <textarea id="observacoes" name="observacoes" rows="3"
                          class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('observacoes', $barragem->observacoes) }}</textarea>
            </div>

            <!-- Submit Buttons -->
            <div class="flex justify-end space-x-4 pt-6 border-t border-gray-200">
                <a href="{{ route('barragens.show', $barragem) }}" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-2 rounded-lg">
                    Cancelar
                </a>
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg">
                    <i class="fas fa-save mr-2"></i>
                    Atualizar Barragem
                </button>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const afluentesInput = document.getElementById('afluentes_input');
    const afluentesHidden = document.getElementById('afluentes_hidden');
    const afluentesTags = document.getElementById('afluentes_tags');

    // Função para atualizar o input hidden
    function updateHiddenInput() {
        const tags = afluentesTags.querySelectorAll('span');
        const values = Array.from(tags).map(tag => tag.textContent.replace('×', '').trim());
        afluentesHidden.value = values.join(',');
    }

    // Função para adicionar tag
    function addAfluenteTag(value) {
        if (!value.trim()) return;

        // Verificar se já existe
        const existingTags = afluentesTags.querySelectorAll('span');
        const existingValues = Array.from(existingTags).map(tag => tag.textContent.replace('×', '').trim().toLowerCase());

        if (existingValues.includes(value.trim().toLowerCase())) {
            return;
        }

        // Criar nova tag
        const tagElement = document.createElement('span');
        tagElement.className = 'inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-cyan-100 text-cyan-800';
        tagElement.innerHTML = `
            ${value.trim()}
            <button type="button" onclick="removeAfluenteTag(this)" class="ml-1 text-cyan-600 hover:text-cyan-800">×</button>
        `;

        afluentesTags.appendChild(tagElement);
        updateHiddenInput();
        afluentesInput.value = '';
    }

    // Event listener para Enter no input
    afluentesInput.addEventListener('keydown', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
            addAfluenteTag(this.value);
        }
    });

    // Event listener para blur (quando sai do campo)
    afluentesInput.addEventListener('blur', function() {
        if (this.value.trim()) {
            addAfluenteTag(this.value);
        }
    });
});

// Função global para remover tags
function removeAfluenteTag(button) {
    const tagElement = button.closest('span');
    tagElement.remove();

    // Atualizar input hidden
    const afluentesHidden = document.getElementById('afluentes_hidden');
    const afluentesTags = document.getElementById('afluentes_tags');
    const tags = afluentesTags.querySelectorAll('span');
    const values = Array.from(tags).map(tag => tag.textContent.replace('×', '').trim());
    afluentesHidden.value = values.join(',');
}
</script>

@endsection