@extends('layouts.app')

@section('title', 'Editar Boletim')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-edit mr-3 text-green-600"></i>
                    Editar {{ $boletim->getTipoFormatado() }} #{{ $boletim->numero_edicao }}
                </h1>
                <p class="text-gray-600 mt-2">Edite o conteúdo e informações do boletim</p>
            </div>
            <div class="flex space-x-2">
                <a href="{{ route('boletins.show', $boletim) }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Voltar
                </a>
            </div>
        </div>
    </div>

    <!-- Form -->
    <form method="POST" action="{{ route('boletins.update', $boletim) }}" class="space-y-6">
        @csrf
        @method('PUT')
        
        <!-- Informações Básicas -->
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-lg font-semibold text-gray-800 mb-4">Informações Básicas</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="numero_edicao" class="block text-sm font-medium text-gray-700 mb-2">
                        Número da Edição
                    </label>
                    <input type="text" id="numero_edicao" name="numero_edicao" 
                           value="{{ old('numero_edicao', $boletim->numero_edicao) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 @error('numero_edicao') border-red-500 @enderror">
                    @error('numero_edicao')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="data_emissao" class="block text-sm font-medium text-gray-700 mb-2">
                        Data de Emissão
                    </label>
                    <input type="date" id="data_emissao" name="data_emissao" 
                           value="{{ old('data_emissao', $boletim->data_emissao->format('Y-m-d')) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 @error('data_emissao') border-red-500 @enderror">
                    @error('data_emissao')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                @if($boletim->periodo_inicio && $boletim->periodo_fim)
                <div>
                    <label for="periodo_inicio" class="block text-sm font-medium text-gray-700 mb-2">
                        Período Início
                    </label>
                    <input type="date" id="periodo_inicio" name="periodo_inicio" 
                           value="{{ old('periodo_inicio', $boletim->periodo_inicio->format('Y-m-d')) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 @error('periodo_inicio') border-red-500 @enderror">
                    @error('periodo_inicio')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="periodo_fim" class="block text-sm font-medium text-gray-700 mb-2">
                        Período Fim
                    </label>
                    <input type="date" id="periodo_fim" name="periodo_fim" 
                           value="{{ old('periodo_fim', $boletim->periodo_fim->format('Y-m-d')) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 @error('periodo_fim') border-red-500 @enderror">
                    @error('periodo_fim')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
                @endif
            </div>
        </div>

        <!-- Conteúdo do Boletim -->
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-lg font-semibold text-gray-800 mb-4">Conteúdo do Boletim</h2>
            
            <!-- Situação Prevalecente -->
            <div class="mb-6">
                <label for="situacao_prevalecente" class="block text-sm font-medium text-gray-700 mb-2">
                    Situação Prevalecente
                </label>
                <textarea id="situacao_prevalecente" name="situacao_prevalecente" rows="4"
                          class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 @error('situacao_prevalecente') border-red-500 @enderror"
                          placeholder="Descreva a situação hidrológica atual...">{{ old('situacao_prevalecente', $boletim->situacao_prevalecente) }}</textarea>
                @error('situacao_prevalecente')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Previsão Hidrológica -->
            <div class="mb-6">
                <label for="previsao_hidrologica" class="block text-sm font-medium text-gray-700 mb-2">
                    Previsão Hidrológica
                </label>
                <textarea id="previsao_hidrologica" name="previsao_hidrologica" rows="4"
                          class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 @error('previsao_hidrologica') border-red-500 @enderror"
                          placeholder="Descreva as previsões hidrológicas...">{{ old('previsao_hidrologica', $boletim->previsao_hidrologica) }}</textarea>
                @error('previsao_hidrologica')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Alertas e Precauções -->
            <div class="mb-6">
                <label for="alertas_precaucoes" class="block text-sm font-medium text-gray-700 mb-2">
                    Alertas e Precauções
                </label>
                <textarea id="alertas_precaucoes" name="alertas_precaucoes" rows="3"
                          class="w-full px-3 py-2 border border-yellow-300 rounded-md focus:outline-none focus:ring-2 focus:ring-yellow-500 @error('alertas_precaucoes') border-red-500 @enderror"
                          placeholder="Descreva alertas e precauções importantes...">{{ old('alertas_precaucoes', $boletim->alertas_precaucoes) }}</textarea>
                @error('alertas_precaucoes')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
                <p class="mt-1 text-sm text-yellow-600">
                    <i class="fas fa-exclamation-triangle mr-1"></i>
                    Este campo aparecerá destacado no boletim
                </p>
            </div>
        </div>

        <!-- Dados Automáticos -->
        @if($boletim->dados_completos && is_array($boletim->dados_completos))
        <div class="bg-gray-50 rounded-lg p-6">
            <h2 class="text-lg font-semibold text-gray-800 mb-4">
                <i class="fas fa-database mr-2"></i>
                Dados Automáticos Coletados
            </h2>
            <div class="text-sm text-gray-600 mb-4">
                Os dados abaixo foram coletados automaticamente do sistema. Estes dados serão incluídos no boletim final.
            </div>

            @if(isset($boletim->dados_completos['barragens']) && count($boletim->dados_completos['barragens']) > 0)
            <div class="mb-4">
                <h3 class="font-medium text-gray-700 mb-2">Barragens Incluídas:</h3>
                <div class="flex flex-wrap gap-2">
                    @foreach($boletim->dados_completos['barragens'] as $barragem)
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                        {{ $barragem['nome'] ?? 'N/A' }}
                    </span>
                    @endforeach
                </div>
            </div>
            @endif

            @if(isset($boletim->dados_completos['estacoes']) && count($boletim->dados_completos['estacoes']) > 0)
            <div class="mb-4">
                <h3 class="font-medium text-gray-700 mb-2">Estações Incluídas:</h3>
                <div class="flex flex-wrap gap-2">
                    @foreach($boletim->dados_completos['estacoes'] as $estacao)
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                        {{ $estacao['nome'] ?? 'N/A' }} ({{ ucfirst($estacao['tipo'] ?? '') }})
                    </span>
                    @endforeach
                </div>
            </div>
            @endif

            <div class="bg-blue-50 border border-blue-200 rounded p-3 text-sm text-blue-800">
                <i class="fas fa-info-circle mr-2"></i>
                Para atualizar estes dados, você precisa regenerar o boletim.
            </div>
        </div>
        @endif

        <!-- Estado do Boletim -->
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-lg font-semibold text-gray-800 mb-4">Estado do Boletim</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="estado" class="block text-sm font-medium text-gray-700 mb-2">
                        Estado Atual
                    </label>
                    <select id="estado" name="estado" 
                            class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 @error('estado') border-red-500 @enderror">
                        <option value="rascunho" {{ old('estado', $boletim->estado) == 'rascunho' ? 'selected' : '' }}>Rascunho</option>
                        <option value="revisao" {{ old('estado', $boletim->estado) == 'revisao' ? 'selected' : '' }}>Enviar para Revisão</option>
                    </select>
                    @error('estado')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
                
                <div class="flex items-end">
                    <div class="text-sm text-gray-600">
                        <p><strong>Estado atual:</strong> {{ $boletim->getEstadoFormatado() }}</p>
                        <p class="mt-1">
                            @if($boletim->estado == 'rascunho')
                                <i class="fas fa-info-circle text-blue-500 mr-1"></i>
                                Boletim em edição
                            @elseif($boletim->estado == 'revisao')
                                <i class="fas fa-clock text-orange-500 mr-1"></i>
                                Aguardando revisão
                            @elseif($boletim->estado == 'aprovado')
                                <i class="fas fa-check text-green-500 mr-1"></i>
                                Boletim aprovado
                            @elseif($boletim->estado == 'publicado')
                                <i class="fas fa-paper-plane text-blue-500 mr-1"></i>
                                Boletim publicado
                            @endif
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Botões -->
        <div class="flex justify-end space-x-3">
            <a href="{{ route('boletins.show', $boletim) }}" 
               class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-6 py-2 rounded-lg">
                Cancelar
            </a>
            <button type="submit" 
                    class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded-lg flex items-center">
                <i class="fas fa-save mr-2"></i>
                Salvar Alterações
            </button>
        </div>
    </form>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-resize textareas
    const textareas = document.querySelectorAll('textarea');
    textareas.forEach(function(textarea) {
        textarea.addEventListener('input', function() {
            this.style.height = 'auto';
            this.style.height = (this.scrollHeight) + 'px';
        });
    });
});
</script>
@endpush
@endsection