@extends('layouts.app')

@section('title', 'Boletim ' . $boletim->numero_edicao)

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-file-alt mr-3 text-blue-600"></i>
                    {{ $boletim->getTipoFormatado() }} #{{ $boletim->numero_edicao }}
                </h1>
                <p class="text-gray-600 mt-2">
                    Emitido em {{ $boletim->data_emissao->format('d/m/Y') }} às {{ $boletim->hora_emissao ? substr($boletim->hora_emissao, 0, 5) : '00:00' }} | 
                    Estado: <span class="font-medium">{{ $boletim->getEstadoFormatado() }}</span>
                </p>
            </div>
            <div class="flex space-x-2">
                <a href="{{ route('boletins.index') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Voltar
                </a>
                
                @if($boletim->podeSerEditado())
                <a href="{{ route('boletins.edit', $boletim) }}" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg">
                    <i class="fas fa-edit mr-2"></i>
                    Editar
                </a>
                @endif

                <div class="flex items-center space-x-2">
                    <span class="text-sm font-medium text-gray-700 mr-3">EXPORTAR:</span>

                    <!-- PDF Export -->
                    <a href="{{ route('boletins.export', ['boletim' => $boletim, 'format' => 'pdf']) }}"
                       class="inline-flex items-center px-3 py-2 bg-red-600 hover:bg-red-700 text-white text-sm font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-file-pdf text-lg"></i>
                        <span class="ml-1 hidden sm:inline">PDF</span>
                    </a>

                    <!-- Word Export (em desenvolvimento) -->
                    <a href="#" onclick="alert('Funcionalidade em Desenvolvimento'); return false;"
                       class="inline-flex items-center px-3 py-2 bg-gray-400 text-white text-sm font-medium rounded-lg cursor-not-allowed">
                        <i class="fas fa-file-word text-lg"></i>
                        <span class="ml-1 hidden sm:inline">Word</span>
                    </a>

                    <!-- Excel Export (em desenvolvimento) -->
                    <a href="#" onclick="alert('Funcionalidade em Desenvolvimento'); return false;"
                       class="inline-flex items-center px-3 py-2 bg-gray-400 text-white text-sm font-medium rounded-lg cursor-not-allowed">
                        <i class="fas fa-file-excel text-lg"></i>
                        <span class="ml-1 hidden sm:inline">Excel</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Informações Gerais -->
    <div class="bg-white rounded-lg shadow p-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Informações Gerais</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div>
                <label class="block text-sm font-medium text-gray-700">Tipo</label>
                <p class="mt-1 text-sm text-gray-900">{{ $boletim->getTipoFormatado() }}</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700">Número da Edição</label>
                <p class="mt-1 text-sm text-gray-900">{{ $boletim->numero_edicao ?? 'Não definido' }}</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700">Estado</label>
                <p class="mt-1">
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                        @if($boletim->estado == 'rascunho') bg-yellow-100 text-yellow-800
                        @elseif($boletim->estado == 'revisao') bg-orange-100 text-orange-800
                        @elseif($boletim->estado == 'aprovado') bg-blue-100 text-blue-800
                        @elseif($boletim->estado == 'publicado') bg-green-100 text-green-800
                        @else bg-gray-100 text-gray-800 @endif">
                        {{ $boletim->getEstadoFormatado() }}
                    </span>
                </p>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700">Data de Emissão</label>
                <p class="mt-1 text-sm text-gray-900">{{ $boletim->data_emissao->format('d/m/Y') }} às {{ $boletim->hora_emissao ? substr($boletim->hora_emissao, 0, 5) : '00:00' }}</p>
            </div>
            @if($boletim->periodo_inicio && $boletim->periodo_fim)
            <div>
                <label class="block text-sm font-medium text-gray-700">Período dos Dados</label>
                <p class="mt-1 text-sm text-gray-900">
                    {{ $boletim->periodo_inicio->format('d/m/Y') }} - {{ $boletim->periodo_fim->format('d/m/Y') }}
                </p>
            </div>
            @endif
            <div>
                <label class="block text-sm font-medium text-gray-700">Elaborado por</label>
                <p class="mt-1 text-sm text-gray-900">
                    {{ $boletim->elaborador ? $boletim->elaborador->name : 'Sistema' }}
                </p>
            </div>
        </div>
    </div>

    <!-- Situação Prevalecente -->
    @if($boletim->situacao_prevalecente)
    <div class="bg-white rounded-lg shadow p-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Situação Prevalecente</h2>
        <div class="prose max-w-none">
            <p class="text-gray-700">{{ $boletim->situacao_prevalecente }}</p>
        </div>
    </div>
    @endif

    <!-- Previsão Hidrológica -->
    @if($boletim->previsao_hidrologica)
    <div class="bg-white rounded-lg shadow p-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Previsão Hidrológica</h2>
        <div class="prose max-w-none">
            <p class="text-gray-700">{{ $boletim->previsao_hidrologica }}</p>
        </div>
    </div>
    @endif

    <!-- Alertas e Precauções -->
    @if($boletim->alertas_precaucoes)
    <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-6">
        <h2 class="text-lg font-semibold text-yellow-800 mb-4">
            <i class="fas fa-exclamation-triangle mr-2"></i>
            Alertas e Precauções
        </h2>
        <div class="prose max-w-none">
            <p class="text-yellow-700">{{ $boletim->alertas_precaucoes }}</p>
        </div>
    </div>
    @endif

    <!-- Dados Completos -->
    @if($boletim->dados_completos && is_array($boletim->dados_completos))
    <div class="bg-white rounded-lg shadow p-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Dados Detalhados</h2>
        
        <!-- Barragens -->
        @if(isset($boletim->dados_completos['barragens']) && count($boletim->dados_completos['barragens']) > 0)
        <div class="mb-6">
            <h3 class="text-md font-medium text-gray-700 mb-3">Situação das Barragens</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Barragem</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Cota Atual</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Volume</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">% Enchimento</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($boletim->dados_completos['barragens'] as $barragem)
                        <tr>
                            <td class="px-4 py-2 text-sm font-medium text-gray-900">{{ $barragem['nome'] ?? 'N/A' }}</td>
                            <td class="px-4 py-2 text-sm text-gray-700">{{ $barragem['cota_actual'] ?? 'N/A' }} m</td>
                            <td class="px-4 py-2 text-sm text-gray-700">{{ $barragem['volume_actual'] ?? 'N/A' }} Mm³</td>
                            <td class="px-4 py-2 text-sm text-gray-700">{{ $barragem['percentagem_enchimento'] ?? 'N/A' }}%</td>
                            <td class="px-4 py-2 text-sm">
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                    @if(($barragem['status_nivel'] ?? '') == 'normal') bg-green-100 text-green-800
                                    @elseif(($barragem['status_nivel'] ?? '') == 'alerta') bg-yellow-100 text-yellow-800
                                    @elseif(($barragem['status_nivel'] ?? '') == 'emergencia') bg-red-100 text-red-800
                                    @else bg-gray-100 text-gray-800 @endif">
                                    {{ ucfirst($barragem['status_nivel'] ?? 'N/A') }}
                                </span>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @endif

        <!-- Estações -->
        @if(isset($boletim->dados_completos['estacoes']) && count($boletim->dados_completos['estacoes']) > 0)
        <div class="mb-6">
            <h3 class="text-md font-medium text-gray-700 mb-3">Dados das Estações</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Estação</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Tipo</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Última Leitura</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Valor</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Estado</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($boletim->dados_completos['estacoes'] as $estacao)
                        <tr>
                            <td class="px-4 py-2 text-sm font-medium text-gray-900">{{ $estacao['nome'] ?? 'N/A' }}</td>
                            <td class="px-4 py-2 text-sm text-gray-700">{{ ucfirst($estacao['tipo'] ?? 'N/A') }}</td>
                            <td class="px-4 py-2 text-sm text-gray-700">{{ $estacao['ultima_leitura'] ?? 'N/A' }}</td>
                            <td class="px-4 py-2 text-sm text-gray-700">
                                @if($estacao['tipo'] == 'hidrometrica')
                                    {{ $estacao['nivel_hidrometrico'] ?? 'N/A' }} m
                                @elseif($estacao['tipo'] == 'pluviometrica')
                                    {{ $estacao['precipitacao_mm'] ?? 'N/A' }} mm
                                @else
                                    {{ $estacao['valor_leitura'] ?? 'N/A' }}
                                @endif
                            </td>
                            <td class="px-4 py-2 text-sm">
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                    @if(($estacao['estado'] ?? '') == 'activa') bg-green-100 text-green-800
                                    @elseif(($estacao['estado'] ?? '') == 'inactiva') bg-red-100 text-red-800
                                    @else bg-yellow-100 text-yellow-800 @endif">
                                    {{ ucfirst($estacao['estado'] ?? 'N/A') }}
                                </span>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @endif
    </div>
    @endif

    <!-- Ações -->
    <div class="bg-white rounded-lg shadow p-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Ações</h2>
        <div class="flex flex-wrap gap-3">
            @if($boletim->podeSerAprovado())
            <form method="POST" action="{{ route('boletins.approve', $boletim) }}" class="inline">
                @csrf
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg"
                        onclick="return confirm('Deseja aprovar este boletim?')">
                    <i class="fas fa-check mr-2"></i>
                    Aprovar
                </button>
            </form>
            @endif

            @if($boletim->podeSerPublicado())
            <form method="POST" action="{{ route('boletins.publish', $boletim) }}" class="inline">
                @csrf
                <button type="submit" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg"
                        onclick="return confirm('Deseja publicar este boletim?')">
                    <i class="fas fa-paper-plane mr-2"></i>
                    Publicar
                </button>
            </form>
            @endif

            @if($boletim->arquivo_pdf)
            <a href="{{ route('boletins.download-pdf', $boletim) }}" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg">
                <i class="fas fa-file-pdf mr-2"></i>
                Download PDF
            </a>
            @endif

            <!-- Exportar -->
            @if($boletim->estado !== 'rascunho')
            <div class="relative inline-block text-left">
                <button type="button" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg"
                        onclick="toggleDropdown('exportDropdown')">
                    <i class="fas fa-download mr-2"></i>
                    Exportar
                    <i class="fas fa-chevron-down ml-2"></i>
                </button>
                <div id="exportDropdown" class="hidden origin-top-right absolute right-0 mt-2 w-48 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 z-10">
                    <div class="py-1">
                        <a href="{{ route('boletins.export', [$boletim, 'pdf']) }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                            <i class="fas fa-file-pdf mr-2"></i>PDF
                        </a>
                        <a href="#" onclick="alert('Funcionalidade em Desenvolvimento'); return false;" class="block px-4 py-2 text-sm text-gray-400 hover:bg-gray-100">
                            <i class="fas fa-file-word mr-2"></i>Word (em breve)
                        </a>
                        <a href="#" onclick="alert('Funcionalidade em Desenvolvimento'); return false;" class="block px-4 py-2 text-sm text-gray-400 hover:bg-gray-100">
                            <i class="fas fa-file-excel mr-2"></i>Excel (em breve)
                        </a>
                    </div>
                </div>
            </div>
            @endif

            <!-- Deletar (apenas rascunhos) -->
            @if($boletim->estado === 'rascunho')
            <form method="POST" action="{{ route('boletins.destroy', $boletim) }}" class="inline">
                @csrf
                @method('DELETE')
                <button type="submit" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg"
                        onclick="return confirm('Tem certeza que deseja deletar este boletim? Esta ação não pode ser desfeita.')">
                    <i class="fas fa-trash mr-2"></i>
                    Deletar
                </button>
            </form>
            @endif
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
function toggleDropdown(dropdownId) {
    const dropdown = document.getElementById(dropdownId);
    dropdown.classList.toggle('hidden');
}

// Fechar dropdown quando clicar fora
document.addEventListener('click', function(event) {
    const dropdowns = document.querySelectorAll('[id$="Dropdown"]');
    dropdowns.forEach(function(dropdown) {
        if (!dropdown.contains(event.target) && !event.target.closest('button')) {
            dropdown.classList.add('hidden');
        }
    });
});
</script>
@endpush