<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Boletim Informativo de Barragens</title>
    <style>
        @page {
            margin: 15mm 15mm 25mm 15mm;
            size: A4;
        }
        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 10px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 0;
        }

        /* Header com Logo */
        .header-container {
            width: 100%;
            margin-bottom: 15px;
            text-align: left;
        }
        .logo-section {
            text-align: left;
            margin-bottom: 15px;
        }
        .logo-section img {
            height: 80px;
            max-width: 350px;
        }

        /* Título Principal */
        .main-title {
            background-color: #ffffff;
            color: #000000;
            text-align: center;
            font-weight: bold;
            font-size: 14px;
            padding: 8px 15px;
            border: 1px solid #000;
            margin-bottom: 0;
        }

        /* Info da Edição */
        .edition-info {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }
        .edition-info td {
            border: 1px solid #000;
            padding: 5px 10px;
            font-size: 10px;
        }
        .edition-info .label {
            font-weight: bold;
            width: 80px;
        }
        .edition-info .number {
            width: 40px;
            text-align: center;
            font-weight: bold;
        }
        .edition-info .date {
            text-align: right;
        }

        /* Seções */
        .section-title {
            background-color: #d9e2f3;
            border: 1px solid #000;
            padding: 6px 10px;
            font-weight: bold;
            font-size: 10px;
            margin-top: 10px;
        }
        .section-content {
            border: 1px solid #000;
            border-top: none;
            padding: 10px;
            text-align: justify;
            font-size: 10px;
            line-height: 1.5;
        }

        /* Texto de Barragens */
        .barragem-text {
            margin-bottom: 8px;
        }
        .barragem-text strong {
            color: #000;
        }
        .barragem-numero {
            font-weight: bold;
        }

        /* Seção de Gráficos */
        .graficos-section {
            margin-top: 15px;
        }
        .graficos-title {
            text-align: center;
            font-weight: bold;
            font-size: 12px;
            text-decoration: underline;
            margin-bottom: 15px;
            padding: 10px;
        }
        .barragem-grafico {
            margin-bottom: 15px;
            page-break-inside: avoid;
        }
        .barragem-grafico-nome {
            font-weight: bold;
            font-size: 10px;
            margin-bottom: 5px;
            padding: 5px;
            background-color: #f0f0f0;
            border: 1px solid #ccc;
        }
        .barragem-grafico img {
            width: 100%;
            max-width: 100%;
            border: 1px solid #ccc;
        }

        /* Tabelas de Dados por Barragem */
        .barragem-section {
            margin-top: 12px;
            page-break-inside: avoid;
        }
        .barragem-header {
            background-color: #1a5276;
            color: white;
            font-weight: bold;
            font-size: 9px;
            padding: 5px 8px;
            border: 1px solid #000;
        }
        .data-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 7px;
        }
        .data-table th {
            background-color: #2874a6;
            color: white;
            padding: 3px 2px;
            border: 1px solid #000;
            text-align: center;
            font-weight: bold;
            font-size: 6px;
        }
        .data-table td {
            padding: 3px 2px;
            border: 1px solid #000;
            text-align: center;
            font-size: 7px;
        }
        .data-table tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .volume-info {
            background-color: #d5dbdb;
            padding: 4px 8px;
            font-size: 8px;
            border: 1px solid #000;
            border-top: none;
            font-weight: bold;
        }

        /* Lista de Distribuição CC */
        .cc-section {
            margin-top: 20px;
            page-break-inside: avoid;
        }
        .cc-title {
            font-weight: bold;
            margin-bottom: 5px;
        }
        .cc-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9px;
        }
        .cc-table td {
            border: 1px solid #ccc;
            padding: 4px 8px;
            width: 50%;
        }

        /* Assinaturas */
        .signatures-section {
            margin-top: 30px;
            page-break-inside: avoid;
        }
        .signature-row {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }
        .signature-block {
            display: table-cell;
            width: 50%;
            text-align: center;
            vertical-align: bottom;
        }
        .signature-title {
            font-style: italic;
            margin-bottom: 40px;
        }
        .signature-name {
            font-weight: bold;
            border-top: 1px solid #000;
            padding-top: 5px;
            display: inline-block;
            min-width: 200px;
        }
        .signature-role {
            font-size: 9px;
        }

        /* Footer */
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
        }
        .footer-wave {
            background: linear-gradient(180deg, #ffffff 0%, #b8d4e8 20%, #6ba3c7 40%, #4a90c2 60%, #6ba3c7 80%, #b8d4e8 100%);
            padding: 12px 20px;
            text-align: center;
        }
        .footer-content {
            color: #1a5276;
            font-size: 9px;
        }
        .footer-phone {
            margin-right: 30px;
        }
        .footer-email {
            margin-left: 30px;
        }
        .footer-address {
            margin-top: 3px;
        }

        /* Page breaks */
        .page-break {
            page-break-before: always;
        }
    </style>
</head>
<body>
    <!-- Header: Logo à esquerda + VISTO à direita -->
    <table style="width: 100%; border: none; margin-bottom: 15px;">
        <tr>
            <td style="width: 60%; vertical-align: top; border: none;">
                <div class="logo-section">
                    @if(file_exists(public_path('images/logo-ara.png')))
                        <img src="{{ public_path('images/logo-ara.png') }}" alt="ARA Norte.IP">
                    @else
                        <div style="font-size: 24px; font-weight: bold; color: #2874a6; text-align: left;">
                            <span style="color: #f39c12;">ARA</span> Norte.IP
                            <div style="font-size: 10px; color: #666;">ADMINISTRAÇÃO REGIONAL DE ÁGUAS DO NORTE</div>
                        </div>
                    @endif
                </div>
            </td>
            <td style="width: 40%; vertical-align: top; text-align: right; border: none;">
                <div style="border: 1px solid #000; padding: 8px 15px; display: inline-block; text-align: center; font-size: 10px;">
                    <strong>VISTO</strong><br>
                    O Director Geral<br><br>
                    <div style="border-top: 1px solid #000; display: inline-block; min-width: 150px; margin-top: 15px; padding-top: 5px;">
                        {{ $settings['director_name'] ?? 'Carlitos Omar' }}
                    </div><br>
                    <span style="font-size: 9px;">({{ $settings['director_title'] ?? 'Director Geral' }})</span>
                </div>
            </td>
        </tr>
    </table>

    <!-- Título Principal -->
    <div class="main-title">BOLETIM INFORMATIVO DE BARRAGENS</div>

    <!-- Info da Edição -->
    @php
        $meses_pt = ['JAN','FEV','MAR','ABR','MAI','JUN','JUL','AGO','SET','OUT','NOV','DEZ'];
        $dt_bib = \Carbon\Carbon::parse($boletim->data_emissao);
        $mes_abrev_bib = $meses_pt[$dt_bib->month - 1];
        $num_raw_bib = preg_replace('/\/.*/', '', $boletim->numero_edicao) ?: '1';
        $num_int_bib = (int) $num_raw_bib;
        $num_pad_bib = str_pad($num_int_bib, 3, '0', STR_PAD_LEFT);
        $ano_hidro_bib = $dt_bib->month >= 10
            ? $dt_bib->year . '-' . ($dt_bib->year + 1)
            : ($dt_bib->year - 1) . '-' . $dt_bib->year;
        $edicao_fmt_bib = "#{$num_int_bib}/{$mes_abrev_bib}/BIB - {$num_pad_bib} ({$ano_hidro_bib})";
    @endphp
    <table class="edition-info">
        <tr>
            <td class="label" style="border: 1px solid #000; width: 70px;">Edição Nº</td>
            <td class="number" style="border: 1px solid #000; width: auto; white-space: nowrap;">{{ $edicao_fmt_bib }}</td>
            <td style="border: none; width: auto;"></td>
            <td class="date" style="border: 1px solid #000; width: 80px;">{{ $dt_bib->format('d/m/Y') }}</td>
        </tr>
    </table>

    <!-- Situação Prevalecente -->
    <div class="section-title">SITUAÇÃO PREVALECENTE</div>
    <div class="section-content" style="line-height: 1.4;">
        @php $barragens_bib = $dados['barragens'] ?? []; @endphp

        <strong>1. Níveis Hidrométricos</strong><br>
        Os níveis hidrométricos nas bacias hidrográficas continuam a baixar.
        <br><br>
        <strong>2. Situação de Enchimento das Albufeiras</strong><br>
        @forelse($barragens_bib as $barragem_sp)
            @php
                $sp_nome = is_array($barragem_sp) ? ($barragem_sp['nome'] ?? 'N/A') : ($barragem_sp->nome ?? 'N/A');
                $sp_enchimento = is_array($barragem_sp) ? ($barragem_sp['percentagem_enchimento'] ?? $barragem_sp['enchimento'] ?? 0) : ($barragem_sp->percentagem_enchimento ?? 0);
                $sp_volume = is_array($barragem_sp) ? ($barragem_sp['volume_atual'] ?? $barragem_sp['volume_actual'] ?? 0) : ($barragem_sp->volume_actual ?? 0);
                $sp_qef = is_array($barragem_sp) ? ($barragem_sp['caudal_ecologico'] ?? 0) : ($barragem_sp->caudal_ecologico ?? 0);
            @endphp
            <strong>{{ $sp_nome }}</strong>: {{ number_format($sp_enchimento, 2) }}% ({{ number_format($sp_volume, 3) }} Mm³)@if($sp_qef > 0), Qef = {{ number_format($sp_qef, 3) }} m³/s@endif.<br>
        @empty
            Sem dados de barragens disponíveis.
        @endforelse
    </div>

    <!-- Enchimento das Principais Albufeiras -->
    <div class="section-title">ENCHIMENTO DAS PRINCIPAIS ALBUFEIRAS</div>
    <div class="section-content">
        @php
            $barragens = $dados['barragens'] ?? [];
            $contador_barragem = 1;
        @endphp

        @forelse($barragens as $barragem)
            @php
                $nome = is_array($barragem) ? ($barragem['nome'] ?? 'N/A') : ($barragem->nome ?? 'N/A');
                $cota = is_array($barragem) ? ($barragem['cota_actual'] ?? $barragem['cota'] ?? 0) : ($barragem->cota_actual ?? 0);
                $enchimento = is_array($barragem) ? ($barragem['percentagem_enchimento'] ?? $barragem['enchimento'] ?? 0) : ($barragem->percentagem_enchimento ?? 0);
                $comparacao = is_array($barragem) ? ($barragem['comparacao_ano_anterior'] ?? 'N/D') : ($barragem->comparacao_ano_anterior ?? 'N/D');
                $caudal_ecologico = is_array($barragem) ? ($barragem['caudal_ecologico'] ?? 0) : ($barragem->caudal_ecologico ?? 0);
                $data_leitura = is_array($barragem) ? ($barragem['data_leitura'] ?? now()->format('d/m/Y')) : ($barragem->data_leitura ?? now()->format('d/m/Y'));

                // Formatar data
                if ($data_leitura instanceof \Carbon\Carbon) {
                    $data_formatada = $data_leitura->format('d/m/Y');
                } elseif (is_string($data_leitura) && strlen($data_leitura) > 10) {
                    $data_formatada = \Carbon\Carbon::parse($data_leitura)->format('d/m/Y');
                } else {
                    $data_formatada = $data_leitura;
                }

                $variacao_texto = 'N/D';
                if (is_numeric($comparacao)) {
                    $variacao_texto = $comparacao >= 0
                        ? "um acréscimo de " . number_format(abs($comparacao), 2) . "%"
                        : "um decréscimo de " . number_format(abs($comparacao), 2) . "%";
                }

                $texto_descarga = '';
                if ($caudal_ecologico > 0) {
                    $texto_descarga = ', e efectuando uma descarga de <strong>' . number_format($caudal_ecologico, 3) . 'm³/s</strong>, de caudal ecologico';
                }
            @endphp

            <div class="barragem-text">
                <span class="barragem-numero">{{ $contador_barragem }}.Barragem de {{ $nome }}</span><br>
                @if($cota && $enchimento)
                    No dia {{ $data_formatada }} as 6 horas a albufeira de <strong>{{ $nome }}</strong> registou a cota de <strong>{{ number_format($cota, 2) }}m</strong>, correspondente a um enchimento de <strong>{{ number_format($enchimento, 2) }}%</strong> do volume total, o que representa {{ $variacao_texto }} comparativamente ao mesmo período do ano anterior{!! $texto_descarga !!}.
                @else
                    Sem dados disponíveis para a data de emissão do boletim.
                @endif
            </div>

            @php $contador_barragem++; @endphp
        @empty
            <p>Não há dados de barragens disponíveis para o período em análise.</p>
        @endforelse
    </div>

    <!-- Previsão Hidrológica -->
    <div class="section-title">PREVISÃO HIDROLÓGICA</div>
    <div class="section-content">
        {{ $boletim->previsao_hidrologica ?? 'Nas próximas 24 horas não se prevê alterações significativas dos níveis hidrométricos nas bacias hidrográficas da região.' }}
    </div>

    <!-- Tabelas Detalhadas por Barragem -->
    <div class="section-title" style="margin-top: 15px;">ENCHIMENTO DAS ALBUFEIRAS</div>

    @forelse($barragens as $barragem)
        @php
            $nome = is_array($barragem) ? ($barragem['nome'] ?? 'N/A') : ($barragem->nome ?? 'N/A');
            $cota = is_array($barragem) ? ($barragem['cota_actual'] ?? $barragem['cota'] ?? 0) : ($barragem->cota_actual ?? 0);
            $enchimento = is_array($barragem) ? ($barragem['percentagem_enchimento'] ?? $barragem['enchimento'] ?? 0) : ($barragem->percentagem_enchimento ?? 0);
            $volume = is_array($barragem) ? ($barragem['volume_actual'] ?? $barragem['volume_atual'] ?? 0) : ($barragem->volume_actual ?? 0);
            $caudal_afluente = is_array($barragem) ? ($barragem['caudal_afluente'] ?? 0) : ($barragem->caudal_afluente ?? 0);
            $caudal_ecologico = is_array($barragem) ? ($barragem['caudal_ecologico'] ?? 0) : ($barragem->caudal_ecologico ?? 0);
            $caudal_efluente = is_array($barragem) ? ($barragem['caudal_efluente'] ?? 0) : ($barragem->caudal_efluente ?? 0);
            $descarga_superficie = is_array($barragem) ? ($barragem['descarga_superficie'] ?? 0) : ($barragem->descarga_superficie ?? 0);
            $descarga_fundo = is_array($barragem) ? ($barragem['descarga_fundo'] ?? 0) : ($barragem->descarga_fundo ?? 0);
            $data_leitura = is_array($barragem) ? ($barragem['data_leitura'] ?? now()->format('d/m/Y')) : ($barragem->data_leitura ?? now()->format('d/m/Y'));
            $hora_leitura = is_array($barragem) ? ($barragem['hora_leitura'] ?? '06:00') : ($barragem->hora_leitura ?? '06:00');
            $area_inundacao = is_array($barragem) ? ($barragem['area_inundacao'] ?? 0) : ($barragem->area_inundacao ?? 0);
            $nivel_armazenamento = is_array($barragem) ? ($barragem['nivel_armazenamento'] ?? $cota) : ($barragem->nivel_armazenamento ?? $cota);
            $volume_armazenamento = is_array($barragem) ? ($barragem['volume_armazenamento'] ?? $volume) : ($barragem->capacidade_total ?? $volume);

            // Estações pluviométricas vinculadas à barragem (dinâmico - pode ter 1 a N estações)
            $estacoes_pluv = is_array($barragem) ? ($barragem['estacoes_pluviometricas'] ?? []) : ($barragem->estacoes_pluviometricas ?? []);
            if (is_string($estacoes_pluv)) {
                $estacoes_pluv = json_decode($estacoes_pluv, true) ?? [];
            }
            if (!is_array($estacoes_pluv)) {
                $estacoes_pluv = [];
            }
            $num_estacoes = count($estacoes_pluv);
            $tem_estacoes = $num_estacoes > 0;

            // Buscar precipitações das estações vinculadas (do campo JSON ou precipitacoes passadas)
            $precipitacoes_estacoes = is_array($barragem) ? ($barragem['precipitacoes'] ?? []) : ($barragem->precipitacoes ?? []);
            if (is_string($precipitacoes_estacoes)) {
                $precipitacoes_estacoes = json_decode($precipitacoes_estacoes, true) ?? [];
            }
            if (!is_array($precipitacoes_estacoes)) {
                $precipitacoes_estacoes = [];
            }
        @endphp

        <div class="barragem-section">
            <div class="barragem-header">Barragem de {{ $nome }}</div>
            <table class="data-table">
                <thead>
                    <tr>
                        <th rowspan="2">Data</th>
                        <th rowspan="2">Hora</th>
                        <th rowspan="2">Cota<br>(m)</th>
                        <th colspan="2">Caudais (m³/s)</th>
                        <th rowspan="2">%<br>Total</th>
                        <th rowspan="2">Nível de<br>Armaz.<br>(m)</th>
                        <th rowspan="2">Volume<br>(Mm³)</th>
                        @if($tem_estacoes)
                            <th colspan="{{ $num_estacoes }}">Precipitação (mm)</th>
                        @else
                            <th rowspan="2">Prec<br>(mm)</th>
                        @endif
                    </tr>
                    <tr>
                        <th>C.Ecolog</th>
                        <th>Efluente</th>
                        @if($tem_estacoes)
                            @foreach($estacoes_pluv as $estacao_nome)
                                <th>{{ $estacao_nome }}</th>
                            @endforeach
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @php
                        $leituras_barragem = is_array($barragem) ? ($barragem['leituras'] ?? []) : [];
                    @endphp
                    @if(count($leituras_barragem) > 0)
                        @foreach($leituras_barragem as $leitura)
                        @php
                            // Precipitações desta leitura (pode vir do campo JSON ou campos individuais)
                            $prec_leitura = $leitura['precipitacoes'] ?? [];
                            if (is_string($prec_leitura)) {
                                $prec_leitura = json_decode($prec_leitura, true) ?? [];
                            }
                        @endphp
                        <tr>
                            <td>{{ $leitura['data'] ?? $data_leitura }}</td>
                            <td>{{ $leitura['hora'] ?? $hora_leitura }}</td>
                            <td>{{ number_format($leitura['cota'] ?? $cota, 2) }}</td>
                            <td>{{ number_format($caudal_ecologico, 3) }}</td>
                            <td>{{ number_format($leitura['caudal_efluente'] ?? 0, 3) }}</td>
                            <td>{{ number_format($leitura['percentagem_total'] ?? $enchimento, 2) }}</td>
                            <td>{{ number_format($leitura['cota'] ?? $cota, 2) }}</td>
                            <td>{{ number_format($leitura['volume_total'] ?? $volume, 3) }}</td>
                            @if($tem_estacoes)
                                @foreach($estacoes_pluv as $codigo_estacao)
                                    <td>{{ number_format($prec_leitura[$codigo_estacao] ?? 0, 1) }}</td>
                                @endforeach
                            @else
                                <td>{{ number_format($leitura['precipitacao_p1'] ?? $leitura['precipitacao'] ?? 0, 1) }}</td>
                            @endif
                        </tr>
                        @endforeach
                    @else
                        <tr>
                            <td>{{ $data_leitura }}</td>
                            <td>{{ $hora_leitura }}</td>
                            <td>{{ number_format($cota, 2) }}</td>
                            <td>{{ number_format($caudal_ecologico, 3) }}</td>
                            <td>{{ number_format($caudal_efluente ?: 0, 3) }}</td>
                            <td>{{ number_format($enchimento, 2) }}</td>
                            <td>{{ number_format($nivel_armazenamento, 2) }}</td>
                            <td>{{ number_format($volume, 2) }}</td>
                            @if($tem_estacoes)
                                @foreach($estacoes_pluv as $codigo_estacao)
                                    <td>{{ number_format($precipitacoes_estacoes[$codigo_estacao] ?? 0, 1) }}</td>
                                @endforeach
                            @else
                                <td>0.0</td>
                            @endif
                        </tr>
                    @endif
                </tbody>
            </table>
            <div class="volume-info">Volume de Armazenamento {{ number_format($volume_armazenamento, 1) }} Mm³</div>
        </div>
    @empty
        <p style="padding: 10px;">Não há dados de barragens disponíveis.</p>
    @endforelse

    <!-- Gráficos Ilustrativos (pequenos, 2 por linha) -->
    @if(!empty($graficos))
    <div class="section-title" style="margin-top: 15px; text-align: center; text-decoration: underline;">GRÁFICOS ILUSTRATIVOS</div>

    <table style="width: 100%; border-collapse: collapse; margin-top: 10px;">
        @php
            $grafico_count = 0;
            $graficos_array = is_array($graficos) ? $graficos : [];
        @endphp
        @foreach($graficos_array as $nomeBarragem => $graficoUrl)
            @if($grafico_count % 2 == 0)
                <tr>
            @endif
            <td style="width: 50%; padding: 5px; vertical-align: top;">
                <div style="font-weight: bold; font-size: 8px; margin-bottom: 3px; text-align: center;">Barragem de {{ $nomeBarragem }}</div>
                <img src="{{ $graficoUrl }}" alt="Gráfico {{ $nomeBarragem }}" style="width: 100%; max-height: 150px; border: 1px solid #ccc;">
            </td>
            @php $grafico_count++; @endphp
            @if($grafico_count % 2 == 0)
                </tr>
            @endif
        @endforeach
        @if($grafico_count % 2 != 0)
            <td style="width: 50%;"></td>
            </tr>
        @endif
    </table>
    @endif

    <!-- Assinatura -->
    <div class="signatures-section">
        <p style="font-style: italic; margin: 0;">O chefe do Departamento dos Recursos Hídricos</p>
        <div style="margin-top: 40px; display: inline-block; text-align: center; min-width: 220px;">
            <div style="border-top: 1px solid #000; padding-top: 5px; font-weight: bold;">{{ $settings['chefe_departamento_name'] ?? 'João Alberto Miguel Sitoe' }}</div>
            <div style="font-size: 9px;">({{ $settings['chefe_departamento_title'] ?? 'Inspector Superior' }})</div>
        </div>
    </div>

    <!-- Lista de Distribuição CC -->
    <div class="cc-section">
        <div class="cc-title">CC.</div>
        <table class="cc-table">
            <tr>
                <td>Conselho De Repr. do Estado de Nampula, C.Delgado</td>
                <td>INAM – Nampula/Cabo Delgado</td>
            </tr>
            <tr>
                <td>Conselho Executivo Provincial Nampula, C.Delgado</td>
                <td>Rádio Moçambique – Nampula</td>
            </tr>
            <tr>
                <td>Direção Nacional de Gestão de Recursos Hídricos</td>
                <td>Rádio Moçambique – Pemba</td>
            </tr>
            <tr>
                <td>Serviços Provinciais de Actividades Económicas</td>
                <td>Notícias – Delegação de Nampula</td>
            </tr>
            <tr>
                <td>Jacarandá Monapo</td>
                <td>Wampula Fax – Nampula</td>
            </tr>
        </table>
    </div>

    <!-- Footer -->
    <div class="footer">
        <div class="footer-wave">
            <div class="footer-content">
                <span class="footer-phone">&#9742; +258 86 201 7777</span>
                <span class="footer-email">@ aranorteip@aranorte.gov.mz</span>
                <div class="footer-address">&#9906; Estrada Nacional nº 1, Bairro Mutauanha, Nampula - Moçambique</div>
            </div>
        </div>
    </div>
</body>
</html>
