<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Boletim Hidrológico da Província</title>
    <style>
        @page {
            margin: 15mm 15mm 25mm 15mm;
            size: A4;
        }
        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 10px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #0066cc;
            padding-bottom: 15px;
        }

        .header-left {
            display: flex;
            align-items: center;
        }

        .logo-ara {
            margin-right: 20px;
        }

        .ara-title {
            color: #0066cc;
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .ara-subtitle {
            color: #666;
            font-size: 10px;
            margin-bottom: 5px;
            text-transform: uppercase;
        }

        .ara-location {
            color: #0066cc;
            font-size: 14px;
            font-weight: bold;
        }

        .header-right {
            text-align: center;
        }

        .logo-ministerio {
            width: 80px;
            height: 80px;
            border: 1px solid #ccc;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: #f0f8ff;
        }

        .title-section {
            text-align: center;
            margin: 25px 0;
        }

        .main-title {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 10px;
            text-transform: uppercase;
            line-height: 1.3;
        }

        .date-title {
            font-size: 12px;
            font-weight: bold;
            margin-bottom: 20px;
        }

        .section-title {
            font-size: 12px;
            font-weight: bold;
            margin: 20px 0 10px 0;
            text-transform: uppercase;
        }

        .section-number {
            margin-right: 10px;
        }

        .content-section {
            margin-bottom: 20px;
            text-align: justify;
        }

        .subsection-title {
            font-weight: bold;
            margin: 15px 0 8px 0;
        }

        .precipitation-data {
            margin: 10px 0;
            font-style: italic;
        }

        .dam-data {
            margin: 10px 0;
        }

        .dam-item {
            margin-bottom: 8px;
            padding-left: 5px;
        }

        .highlight {
            font-weight: bold;
        }

        .alert-section {
            margin: 15px 0;
        }

        .legend-section {
            margin-top: 30px;
            padding: 15px;
            background-color: #f8f9fa;
            border: 1px solid #ddd;
            border-radius: 5px;
        }

        .legend-title {
            font-weight: bold;
            margin-bottom: 10px;
        }

        .legend-item {
            margin-bottom: 5px;
            font-size: 10px;
        }

        .signature-section {
            margin-top: 40px;
            text-align: center;
        }

        .signature-title {
            margin-bottom: 30px;
            font-size: 11px;
        }

        .signature-line {
            border-bottom: 1px solid #000;
            width: 250px;
            margin: 0 auto 10px;
        }

        .signature-name {
            font-weight: bold;
            margin-bottom: 5px;
        }

        .signature-position {
            font-size: 10px;
            color: #666;
        }

        .footer {
            margin-top: 40px;
            background: linear-gradient(135deg, #87ceeb 0%, #4682b4 100%);
            color: white;
            text-align: center;
            padding: 20px;
            border-radius: 10px;
        }

        .footer-logo {
            font-size: 20px;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .contact-info {
            font-size: 11px;
            margin-bottom: 8px;
        }

        .address {
            font-size: 10px;
        }

        .value-highlight {
            font-weight: bold;
            color: #0066cc;
        }

        .percentage {
            color: #d63384;
            font-weight: bold;
        }

        .date-highlight {
            color: #198754;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <!-- Header: Logo à esquerda + VISTO à direita -->
    <table style="width: 100%; border: none; margin-bottom: 15px;">
        <tr>
            <td style="width: 60%; vertical-align: top; border: none;">
                @if(file_exists(public_path('images/logo-ara.png')))
                    <img src="{{ public_path('images/logo-ara.png') }}" alt="ARA Norte.IP" style="height: 80px; max-width: 350px;">
                @else
                    <div style="font-size: 24px; font-weight: bold; color: #2874a6; text-align: left;">
                        <span style="color: #f39c12;">ARA</span> Norte.IP
                        <div style="font-size: 10px; color: #666;">ADMINISTRAÇÃO REGIONAL DE ÁGUAS DO NORTE</div>
                    </div>
                @endif
            </td>
            <td style="width: 40%; vertical-align: top; text-align: right; border: none;">
                <div style="border: 1px solid #000; padding: 8px 15px; display: inline-block; text-align: center; font-size: 10px;">
                    <strong>VISTO</strong><br>
                    O Director Geral<br><br>
                    <div style="border-top: 1px solid #000; display: inline-block; min-width: 150px; margin-top: 15px; padding-top: 5px;">
                        {{ $settings['director_name'] ?? 'Carlitos Omar' }}
                    </div><br>
                    <span style="font-size: 9px;">({{ $settings['director_title'] ?? 'Director Geral' }})</span>
                </div>
            </td>
        </tr>
    </table>

    @php
        $provincia = $dados['provincia'] ?? 'Nampula';
    @endphp

    @php
        $meses_pt_bhp = ['JAN','FEV','MAR','ABR','MAI','JUN','JUL','AGO','SET','OUT','NOV','DEZ'];
        $dt_bhp = \Carbon\Carbon::parse($data_emissao);
        $mes_abrev_bhp = $meses_pt_bhp[$dt_bhp->month - 1];
        $num_raw_bhp = preg_replace('/\/.*/', '', $numero_edicao) ?: '1';
        $num_int_bhp = (int) $num_raw_bhp;
        $num_pad_bhp = str_pad($num_int_bhp, 3, '0', STR_PAD_LEFT);
        $ano_hidro_bhp = $dt_bhp->month >= 10
            ? $dt_bhp->year . '-' . ($dt_bhp->year + 1)
            : ($dt_bhp->year - 1) . '-' . $dt_bhp->year;
        $edicao_fmt_bhp = "#{$num_int_bhp}/{$mes_abrev_bhp}/BHP - {$num_pad_bhp} ({$ano_hidro_bhp})";
    @endphp
    <div class="title-section">
        <div class="main-title">
            BOLETIM HIDROLÓGICO DA PROVÍNCIA DE {{ strtoupper($provincia) }}: Nº {{ $edicao_fmt_bhp }}
        </div>
        <div class="date-title">
            DIA {{ $dt_bhp->format('d/m/Y') }}
        </div>
    </div>

    <div class="content-section">
        <div class="section-title">
            <span class="section-number">1.</span>SITUAÇÃO PREVALECENTE
        </div>

        <div class="subsection-title">
            Precipitação registada nas últimas 24 horas nas bacias hidrográficas da província de {{ $provincia }}:
        </div>

        @if(!empty($dados['precipitacao_estacoes']))
            <p>Nas últimas 24 horas houve registo de precipitação na rede de observação da província de {{ $provincia }}:</p>

            @php
                $precipitacao_por_bacia = collect($dados['precipitacao_estacoes'])->groupBy('bacia');
            @endphp

            @foreach($precipitacao_por_bacia as $bacia => $estacoes_precip)
                <div class="precipitation-data">
                    <strong>BACIA HIDROGRÁFICA {{ strtoupper($bacia) }}</strong> (
                    @foreach($estacoes_precip as $index => $estacao_precip)
                        @if($index > 0); @endif
                        {{ $estacao_precip['codigo'] }} {{ $estacao_precip['estacao'] }}: <span class="value-highlight">{{ $estacao_precip['precipitacao'] }} mm</span>
                    @endforeach
                    ).
                </div>
            @endforeach
        @else
            <p>Nas últimas 24 horas não houve registo de precipitação na rede de observação da região Norte.</p>
        @endif

        <div class="subsection-title">
            Comportamento dos níveis hidrométricos nas principais bacias da região.
        </div>

        <p>{{ $dados['analise_niveis']['texto'] ?? 'Nas últimas 24h observou-se variação dos níveis hidrométricos nas bacias hidrográficas da região.' }}</p>
    </div>

    <div class="content-section">
        <div class="section-title">
            <span class="section-number">2.</span>SITUAÇÃO DE ENCHIMENTO DAS ALBUFEIRAS
        </div>

        <div class="dam-data">
            @foreach($barragens as $barragem)
            <div class="dam-item">
                @php
                    $nivel_atual = $barragem['nivel_atual'] ?? 0;
                    $nivel_alerta = $barragem['nivel_alerta'] ?? 0;
                    $estado_nivel = $nivel_atual > $nivel_alerta ? 'Nível a baixar' : 'Nível estacionário';
                    $prov_enchimento = is_numeric($barragem['percentual_enchimento'] ?? null) ? $barragem['percentual_enchimento'] : 0;
                    $prov_volume = is_numeric($barragem['volume_atual'] ?? null) ? $barragem['volume_atual'] : 0;
                    $prov_qef = is_numeric($barragem['caudal_efluente'] ?? null) ? $barragem['caudal_efluente'] : 0;
                    $prov_data = $barragem['data_leitura'] ?? null;
                @endphp
                <span style="color: #0066cc; font-weight: bold;">&#9830;</span> <strong>Barragem de {{ $barragem['nome'] ?? 'N/A' }}:</strong> (<span class="percentage">{{ number_format($prov_enchimento, 2) }}%</span>, <span class="value-highlight">{{ number_format($prov_volume, 3) }} Mm³</span>), Q<sub>ef</sub> = {{ number_format($prov_qef, 3) }} m³/s; {{ $estado_nivel }}.@if($prov_data && $prov_data !== 'N/D') ({{ $prov_data }})@endif
            </div>
            @endforeach
        </div>
    </div>

    <div class="content-section">
        <div class="section-title">
            <span class="section-number">3.</span>PREVISÃO HIDROLÓGICA
        </div>

        <p>{!! nl2br(e($boletim->previsao_hidrologica ?? 'Para as próximas 24 horas, não se prevê alterações significativas do actual cenário hidrológico.')) !!}</p>
    </div>

    <div class="content-section">
        <div class="section-title">
            <span class="section-number">4.</span>ALERTA E PRECAUÇÕES
        </div>

        <p>{!! nl2br(e($boletim->alertas_precaucoes ?? 'A ARA-Norte, IP, apela à sociedade para a observância de medidas de precaução, evitar a travessia de cursos de água. Apela-se igualmente ao acompanhamento da informação hidrológica disseminada pela ARA Norte, IP, e outras entidades competentes.')) !!}</p>
    </div>

    <div class="legend-section">
        <div class="legend-title">Legenda:</div>
        <div class="legend-item"><strong>NA:</strong> Nível de alerta</div>
        <div class="legend-item"><strong>S/NA:</strong> Sem Nível de alerta</div>
        <div class="legend-item"><strong>SI:</strong> Sem informação</div>
        <div class="legend-item"><strong>Q<sub>ef</sub>:</strong> Vazão efluente</div>
    </div>

    <!-- Assinatura -->
    <div style="margin-top: 30px; text-align: center; page-break-inside: avoid;">
        <p style="font-style: italic; margin: 0;">O chefe do Departamento dos Recursos Hídricos</p>
        <div style="margin-top: 40px; display: inline-block; text-align: center; min-width: 220px;">
            <div style="border-top: 1px solid #000; padding-top: 5px; font-weight: bold;">{{ $settings['chefe_departamento_name'] ?? 'João Alberto Miguel Sitoe' }}</div>
            <div style="font-size: 9px;">({{ $settings['chefe_departamento_title'] ?? 'Inspector Superior' }})</div>
        </div>
    </div>

    <!-- Footer -->
    <div style="position: fixed; bottom: 0; left: 0; right: 0;">
        <div style="background-color: #4a90c2; height: 4px;"></div>
        <div style="background-color: #b8d4e8; padding: 10px 20px; text-align: center;">
            <div style="color: #1a5276; font-size: 9px;">
                <span style="margin-right: 30px;">&#9742; +258 86 201 7777</span>
                <span style="margin-left: 30px;">@ aranorteip@aranorte.gov.mz</span>
                <div style="margin-top: 3px;">&#9906; Estrada Nacional nº 1, Bairro Mutauanha, Nampula - Moçambique</div>
            </div>
        </div>
    </div>
</body>
</html>