<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Boletim Hidrológico Regional</title>
    <style>
        @page {
            margin: 15mm 15mm 25mm 15mm;
            size: A4;
        }
        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 10px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 0;
        }

        /* Header com Logo */
        .header-container {
            width: 100%;
            margin-bottom: 15px;
            text-align: left;
        }
        .logo-section {
            text-align: left;
            margin-bottom: 15px;
        }
        .logo-section img {
            height: 80px;
            max-width: 350px;
        }

        /* Título Principal */
        .main-title {
            background-color: #ffffff;
            color: #000000;
            text-align: center;
            font-weight: bold;
            font-size: 14px;
            padding: 8px 15px;
            border: 1px solid #000;
            margin-bottom: 0;
        }

        /* Info da Edição */
        .edition-info {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }
        .edition-info td {
            border: none;
            padding: 5px 10px;
            font-size: 10px;
        }
        .edition-info .label {
            font-weight: bold;
            width: 80px;
        }
        .edition-info .number {
            width: 40px;
            text-align: center;
            font-weight: bold;
        }
        .edition-info .date {
            text-align: right;
        }

        /* Seções */
        .section-title {
            background-color: #d9e2f3;
            border: 1px solid #000;
            padding: 6px 10px;
            font-weight: bold;
            font-size: 10px;
            margin-top: 10px;
        }
        .section-content {
            border: 1px solid #000;
            border-top: none;
            padding: 10px;
            text-align: justify;
            font-size: 10px;
            line-height: 1.5;
        }

        /* Texto de Barragens (narrativa) */
        .barragem-text {
            margin-bottom: 8px;
        }
        .barragem-text strong {
            color: #000;
        }
        .barragem-numero {
            font-weight: bold;
        }

        /* Tabela de Evolução dos Níveis Hidrométricos */
        .evolution-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9px;
            margin-bottom: 10px;
        }
        .evolution-table th {
            border: 1px solid #000;
            padding: 4px 4px;
            text-align: center;
            font-weight: bold;
            font-size: 9px;
            background-color: #4472c4;
            color: #fff;
        }
        .evolution-table td {
            border: 1px solid #000;
            padding: 3px 4px;
            text-align: center;
            font-size: 9px;
        }

        /* Tabela de Barragens (detalhada - 10 colunas) */
        .barragens-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 8px;
            margin-top: 10px;
        }
        .barragens-table th {
            background-color: #4472c4;
            color: #fff;
            padding: 4px 3px;
            text-align: center;
            font-weight: bold;
            border: 1px solid #000;
            font-size: 7px;
        }
        .barragens-table td {
            padding: 4px 3px;
            border: 1px solid #000;
            text-align: center;
            font-size: 8px;
        }
        .barragens-table .nome-barragem {
            text-align: left;
            font-weight: bold;
        }

        /* Gráficos */
        .graficos-section {
            margin-top: 15px;
        }

        /* Legenda */
        .legend-box {
            margin-top: 5px;
            font-size: 8px;
            border: 1px solid #000;
            padding: 5px 10px;
        }
        .legend-box table {
            width: 100%;
            border: none;
        }
        .legend-box td {
            border: none;
            padding: 2px 8px;
            font-size: 8px;
        }

        /* Assinaturas */
        .signatures-section {
            margin-top: 30px;
            page-break-inside: avoid;
            text-align: center;
        }
        .signature-name {
            font-weight: bold;
            border-top: 1px solid #000;
            padding-top: 5px;
            display: inline-block;
            min-width: 200px;
        }
        .signature-role {
            font-size: 9px;
        }

        /* Lista de Distribuição CC */
        .cc-section {
            margin-top: 20px;
            page-break-inside: avoid;
        }
        .cc-title {
            font-weight: bold;
            margin-bottom: 5px;
        }
        .cc-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9px;
        }
        .cc-table td {
            border: 1px solid #ccc;
            padding: 4px 8px;
            width: 50%;
        }

        /* Footer */
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
        }
        .footer-wave {
            background: linear-gradient(180deg, #ffffff 0%, #b8d4e8 20%, #6ba3c7 40%, #4a90c2 60%, #6ba3c7 80%, #b8d4e8 100%);
            padding: 12px 20px;
            text-align: center;
        }
        .footer-content {
            color: #1a5276;
            font-size: 9px;
        }
        .footer-phone {
            margin-right: 30px;
        }
        .footer-email {
            margin-left: 30px;
        }
        .footer-address {
            margin-top: 3px;
        }

        /* Page breaks */
        .page-break {
            page-break-before: always;
        }
    </style>
</head>
<body>
    <!-- Header: Logo à esquerda + VISTO à direita -->
    <table style="width: 100%; border: none; margin-bottom: 15px;">
        <tr>
            <td style="width: 60%; vertical-align: top; border: none;">
                <div class="logo-section">
                    @if(file_exists(public_path('images/logo-ara.png')))
                        <img src="{{ public_path('images/logo-ara.png') }}" alt="ARA Norte.IP">
                    @else
                        <div style="font-size: 24px; font-weight: bold; color: #2874a6; text-align: left;">
                            <span style="color: #f39c12;">ARA</span> Norte.IP
                            <div style="font-size: 10px; color: #666;">ADMINISTRAÇÃO REGIONAL DE ÁGUAS DO NORTE</div>
                        </div>
                    @endif
                </div>
            </td>
            <td style="width: 40%; vertical-align: top; text-align: right; border: none;">
                <div style="border: 1px solid #000; padding: 8px 15px; display: inline-block; text-align: center; font-size: 10px;">
                    <strong>VISTO</strong><br>
                    O Director Geral<br><br>
                    <div style="border-top: 1px solid #000; display: inline-block; min-width: 150px; margin-top: 15px; padding-top: 5px;">
                        {{ $settings['director_name'] ?? 'Carlitos Omar' }}
                    </div><br>
                    <span style="font-size: 9px;">({{ $settings['director_title'] ?? 'Director Geral' }})</span>
                </div>
            </td>
        </tr>
    </table>

    <!-- Título Principal -->
    <div class="main-title">BOLETIM HIDROLOGICO REGIONAL</div>

    <!-- Info da Edição -->
    @php
        $meses_pt = ['JAN','FEV','MAR','ABR','MAI','JUN','JUL','AGO','SET','OUT','NOV','DEZ'];
        $dt = \Carbon\Carbon::parse($data_emissao);
        $mes_abrev = $meses_pt[$dt->month - 1];
        $num_raw = preg_replace('/\/.*/', '', $boletim->numero_edicao) ?: '1';
        $num_int = (int) $num_raw;
        $num_pad = str_pad($num_int, 3, '0', STR_PAD_LEFT);
        $ano_hidro = $dt->month >= 10
            ? $dt->year . '-' . ($dt->year + 1)
            : ($dt->year - 1) . '-' . $dt->year;
        $edicao_fmt = "#{$num_int}/{$mes_abrev}/BHR - {$num_pad} ({$ano_hidro})";
    @endphp
    <table class="edition-info">
        <tr>
            <td class="label" style="border: 1px solid #000; width: 70px;">Edição Nº</td>
            <td class="number" style="border: 1px solid #000; width: auto; white-space: nowrap;">{{ $edicao_fmt }}</td>
            <td style="border: none; width: auto;"></td>
            <td class="date" style="border: 1px solid #000; width: 80px;">{{ $dt->format('d/m/Y') }}</td>
        </tr>
    </table>

    <!-- SITUAÇÃO PREVALECENTE -->
    <div class="section-title">SITUAÇÃO PREVALECENTE</div>
    <div class="section-content" style="line-height: 1.3;">
        <strong>Precipitação:</strong>
        @if(!empty($dados['precipitacao_estacoes']))
            @php
                $precipitacao_por_bacia = collect($dados['precipitacao_estacoes'])->groupBy('bacia');
                $is_first_bacia = true;
            @endphp
            @foreach($precipitacao_por_bacia as $bacia => $estacoes_precip)@if(!$is_first_bacia) | @endif<strong>{{ strtoupper($bacia) }}:</strong> @foreach($estacoes_precip as $index => $estacao_p)@if($index > 0); @endif{{ $estacao_p['codigo'] }} {{ $estacao_p['estacao'] }}: {{ $estacao_p['precipitacao'] }} mm @endforeach @php $is_first_bacia = false; @endphp @endforeach
        @else
            Sem registo de precipitação.
        @endif
        <br>
        <strong>Níveis Hidrométricos:</strong>
        @if(!empty($dados['analise_niveis']['texto'])){{ $dados['analise_niveis']['texto'] }}@else Os níveis hidrométricos nas bacias hidrográficas continuam a baixar.@endif
        <br>
        <strong>Barragens:</strong>
        @forelse($barragens as $barragem)
            @php
                $b_nome = is_object($barragem) ? ($barragem->nome ?? 'N/A') : ($barragem['nome'] ?? 'N/A');
                $b_enchimento = is_object($barragem) ? ($barragem->percentual_enchimento ?? 0) : ($barragem['percentual_enchimento'] ?? 0);
                $b_volume = is_object($barragem) ? ($barragem->volume_total ?? 0) : ($barragem['volume_total'] ?? 0);
                $b_qef = is_object($barragem) ? ($barragem->caudal_ecologico ?? 0) : ($barragem['caudal_ecologico'] ?? 0);
            @endphp
            <strong>{{ $b_nome }}</strong>: {{ number_format($b_enchimento, 2) }}% ({{ number_format($b_volume, 2) }} Mm³){{ $b_qef > 0 ? ', Qef=' . number_format($b_qef, 3) . ' m³/s' : '' }};
        @empty
            Sem dados.
        @endforelse
    </div>

    <!-- ENCHIMENTO DAS PRINCIPAIS ALBUFEIRAS (Narrativa) -->
    <div class="section-title">ENCHIMENTO DAS PRINCIPAIS ALBUFEIRAS</div>
    <div class="section-content">
        @php $contador_barragem = 1; @endphp

        @forelse($barragens as $barragem)
            @php
                $nome = is_object($barragem) ? ($barragem->nome ?? 'N/A') : ($barragem['nome'] ?? 'N/A');
                $cota = is_object($barragem) ? ($barragem->nivel_atual ?? 0) : ($barragem['nivel_atual'] ?? 0);
                $enchimento = is_object($barragem) ? ($barragem->percentual_enchimento ?? 0) : ($barragem['percentual_enchimento'] ?? 0);
                $volume = is_object($barragem) ? ($barragem->volume_atual ?? 0) : ($barragem['volume_atual'] ?? 0);
                $caudal = is_object($barragem) ? ($barragem->caudal_efluente ?? 0) : ($barragem['caudal_efluente'] ?? 0);
                $comparacao = is_object($barragem) ? ($barragem->comparacao_ano_anterior ?? null) : ($barragem['comparacao_ano_anterior'] ?? null);
                $data_leitura = is_object($barragem) ? ($barragem->data_leitura ?? now()->format('d/m/Y')) : ($barragem['data_leitura'] ?? now()->format('d/m/Y'));

                $variacao_texto = 'N/D';
                if (is_numeric($comparacao)) {
                    $variacao_texto = $comparacao >= 0
                        ? "um acréscimo de " . number_format(abs($comparacao), 2) . "%"
                        : "um decréscimo de " . number_format(abs($comparacao), 2) . "%";
                }

                $texto_descarga = '';
                if ($caudal > 0) {
                    $texto_descarga = ', e efectuando uma descarga de <strong>' . number_format($caudal, 3) . ' m³/s</strong>';
                }
            @endphp

            <div class="barragem-text">
                <span class="barragem-numero">{{ $contador_barragem }}.Barragem de {{ $nome }}</span><br>
                @if($cota && $enchimento)
                    A Albufeira de <strong>{{ $nome }}</strong> registou a cota de <strong>{{ number_format($cota, 2) }}</strong>, correspondente a um enchimento de <strong>{{ number_format($enchimento, 2) }}%</strong> do volume total, o que representa {{ $variacao_texto }} comparativamente ao mesmo período do ano anterior{!! $texto_descarga !!}.
                @else
                    Sem dados disponíveis para o período.
                @endif
            </div>

            @php $contador_barragem++; @endphp
        @empty
            <p>Não há dados de barragens disponíveis para o período em análise.</p>
        @endforelse
    </div>

    <!-- PREVISÃO HIDROLÓGICA -->
    <div class="section-title">PREVISÃO HIDROLÓGICA</div>
    <div class="section-content">
        {{ $boletim->previsao_hidrologica ?? 'Nas Próximas 24 horas não prevê-se alterações significativas dos níveis hidrométricos nas bacias hidrográficas da região.' }}
    </div>

    <!-- EVOLUÇÃO DOS NÍVEIS HIDROMÉTRICOS -->
    <div class="page-break"></div>
    <div style="text-align: center; font-weight: bold; font-size: 14px; margin: 15px 0; text-decoration: underline;">EVOLUÇÃO DOS NÍVEIS HIDROMÉTRICOS</div>

    @if(!empty($dados['bacias']))
        @foreach($dados['bacias'] as $nomeBacia => $bacia)
            @if(!empty($bacia['estacoes']))
            <table class="evolution-table">
                <!-- Cabeçalho fixo da tabela (só uma vez por bacia) -->
                <thead>
                    <tr>
                        <th style="width: 14%;" rowspan="2">Estação</th>
                        <th style="width: 11%;" rowspan="2">Data</th>
                        <th style="width: 24%;" colspan="3">Nível (m)</th>
                        <th style="width: 12%;" rowspan="2">N. Alerta<br>(m)</th>
                        <th style="width: 11%;" rowspan="2">Prec.<br>(mm)</th>
                        <th style="width: 16%;" rowspan="2">Observação</th>
                    </tr>
                    <tr>
                        <th style="width: 8%;">6h</th>
                        <th style="width: 8%;">12h</th>
                        <th style="width: 8%;">18h</th>
                    </tr>
                </thead>
                <tbody>
                <!-- Linha da Bacia -->
                <tr>
                    <td colspan="8" style="text-align: center; font-weight: bold; border: 1px solid #000; padding: 4px;">BACIA DO {{ strtoupper($nomeBacia) }}</td>
                </tr>

                @foreach($bacia['estacoes'] as $estacao)
                    @php
                        $leituras = array_slice($estacao['leituras'] ?? [], 0, 3);
                        $totalLinhas = max(count($leituras), 1) + 1; // +1 para sub-header
                        $nomeEstacao = $estacao['nome'] . ' ' . $estacao['codigo'];
                        $nivelAlerta = $estacao['nivel_alerta'] ? number_format($estacao['nivel_alerta'], 1) : 'S/NA';
                        $mes = '';
                        if (!empty($estacao['leituras'])) {
                            $primeiraData = $estacao['leituras'][0]['data'] ?? '';
                            if ($primeiraData) {
                                try {
                                    $mes = \Carbon\Carbon::createFromFormat('d/m/y', $primeiraData)->translatedFormat('F');
                                } catch (\Exception $e) {
                                    $mes = '';
                                }
                            }
                        }
                    @endphp

                    <!-- Sub-header da estação: mês + 6h/12h/18h + código pluviométrica -->
                    <tr>
                        <td style="font-weight: bold; text-align: left;" rowspan="{{ $totalLinhas }}">{{ $nomeEstacao }}</td>
                        <td>{{ $mes }}</td>
                        <td>6h</td>
                        <td>12h</td>
                        <td>18h</td>
                        <td rowspan="{{ $totalLinhas }}" style="color: #cc0000; font-weight: bold;">{{ $nivelAlerta }}</td>
                        <td><strong>{{ $estacao['codigo_pluviometrica'] ?? 'S/P' }}</strong></td>
                        <td></td>
                    </tr>

                    <!-- Linhas de dados -->
                    @forelse($leituras as $leitura)
                    <tr>
                        <td>{{ $leitura['data'] }}</td>
                        <td>{{ $leitura['nivel_6h'] !== null ? number_format($leitura['nivel_6h'], 2) : '' }}</td>
                        <td>{{ $leitura['nivel_12h'] !== null ? number_format($leitura['nivel_12h'], 2) : '' }}</td>
                        <td>{{ $leitura['nivel_18h'] !== null ? number_format($leitura['nivel_18h'], 2) : '' }}</td>
                        <td>{{ ($leitura['precipitacao'] !== null && $leitura['precipitacao'] > 0) ? number_format($leitura['precipitacao'], 1) : '' }}</td>
                        <td></td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" style="text-align: center; font-style: italic;">S/Inf</td>
                        <td></td>
                    </tr>
                    @endforelse
                @endforeach
                </tbody>
            </table>
            @endif
        @endforeach

        <!-- Legenda -->
        <div class="legend-box">
            <table>
                <tr>
                    <td>(S/Inf) - Sem informação</td>
                    <td>(L/S) - Leito Seco</td>
                    <td>(S/P) – Sem pluviômetro</td>
                    <td>(S/NA) – Sem nível de alerta</td>
                </tr>
            </table>
        </div>
    @else
        <div class="section-content">
            Não há dados de evolução dos níveis hidrométricos disponíveis para o período.
        </div>
    @endif

    <!-- ENCHIMENTO DAS ALBUFEIRAS (Tabela Detalhada) -->
    <div class="page-break"></div>
    <div style="text-align: center; font-weight: bold; font-size: 14px; margin: 15px 0; text-decoration: underline;">ENCHIMENTO DAS ALBUFEIRAS</div>

    @if(count($barragens) > 0)
    <table class="barragens-table">
        <thead>
            <tr>
                <th style="width: 11%;">Barragem</th>
                <th style="width: 9%;">Cap. Total<br>(Mm<sup>3</sup>)</th>
                <th style="width: 9%;">Cap. Útil<br>(Mm<sup>3</sup>)</th>
                <th style="width: 8%;"></th>
                <th style="width: 9%;"></th>
                <th style="width: 9%;">V. Total<br>(Mm3)</th>
                <th style="width: 8%;"></th>
                <th style="width: 9%;">V. Útil<br>(Mm3)</th>
                <th style="width: 10%;">(%) Útil</th>
                <th style="width: 8%;">Q.e</th>
            </tr>
            <tr>
                <th>NPA (m)</th>
                <th>(Mm<sup>3</sup>)</th>
                <th>(Mm<sup>3</sup>)</th>
                <th>Nível (m)</th>
                <th>Cota (m)</th>
                <th>(Mm3)</th>
                <th>(%) Total</th>
                <th>(Mm3)</th>
                <th>{{ \Carbon\Carbon::parse($data_emissao)->format('Y') }}-{{ \Carbon\Carbon::parse($data_emissao)->addYear()->format('y') }}</th>
                <th>(m3/s)</th>
            </tr>
        </thead>
        <tbody>
            @foreach($barragens as $barragem)
            @php
                $nome = is_object($barragem) ? ($barragem->nome ?? 'N/A') : ($barragem['nome'] ?? 'N/A');
                $cota_npa = is_object($barragem) ? ($barragem->cota_npa ?? 0) : ($barragem['cota_npa'] ?? 0);
                $cap_total = is_object($barragem) ? ($barragem->cap_total ?? 0) : ($barragem['cap_total'] ?? 0);
                $cap_util = is_object($barragem) ? ($barragem->cap_util ?? 0) : ($barragem['cap_util'] ?? 0);
                $nivel = is_object($barragem) ? ($barragem->nivel_hidrometrico ?? null) : ($barragem['nivel_hidrometrico'] ?? null);
                $cota = is_object($barragem) ? ($barragem->cota_actual ?? 0) : ($barragem['cota_actual'] ?? 0);
                $v_total = is_object($barragem) ? ($barragem->volume_total ?? 0) : ($barragem['volume_total'] ?? 0);
                $pct_total = is_object($barragem) ? ($barragem->percentagem_total ?? 0) : ($barragem['percentagem_total'] ?? 0);
                $v_util = is_object($barragem) ? ($barragem->volume_util_actual ?? 0) : ($barragem['volume_util_actual'] ?? 0);
                $pct_util = is_object($barragem) ? ($barragem->percentual_enchimento ?? 0) : ($barragem['percentual_enchimento'] ?? 0);
                $qe = is_object($barragem) ? ($barragem->caudal_ecologico ?? 0) : ($barragem['caudal_ecologico'] ?? 0);
            @endphp
            <tr>
                <td class="nome-barragem"><strong>{{ $nome }}</strong></td>
                <td>{{ $cap_total ? number_format($cap_total, 1) : '-' }}</td>
                <td>{{ $cap_util ? number_format($cap_util, 1) : '-' }}</td>
                <td>{{ $nivel !== null ? number_format($nivel, 2) : '-' }}</td>
                <td>{{ $cota ? number_format($cota, 2) : '-' }}</td>
                <td>{{ $v_total ? number_format($v_total, 2) : '-' }}</td>
                <td>{{ $pct_total ? number_format($pct_total, 2) : '-' }}</td>
                <td>{{ $v_util ? number_format($v_util, 2) : '-' }}</td>
                <td>{{ $pct_util ? number_format($pct_util, 2) : '-' }}</td>
                <td>{{ $qe ? number_format($qe, 2) : '-' }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @else
    <div class="section-content">
        <p style="font-style: italic;">Não há dados de barragens disponíveis para este período.</p>
    </div>
    @endif

    <!-- GRÁFICOS ILUSTRATIVOS -->
    @if(!empty($graficos) || !empty($graficos_estacoes))
    <div class="page-break"></div>
    <div class="section-title" style="text-align: center; text-decoration: underline;">GRÁFICOS ILUSTRATIVOS</div>

    {{-- Gráficos das Barragens --}}
    @if(!empty($graficos))
    <div style="font-weight: bold; font-size: 10px; margin: 10px 0 5px 0;">Barragens</div>
    <table style="width: 100%; border-collapse: collapse;">
        @php
            $grafico_count = 0;
            $graficos_array = is_array($graficos) ? $graficos : [];
        @endphp
        @foreach($graficos_array as $nomeBarragem => $graficoUrl)
            @if($grafico_count % 2 == 0)
                <tr>
            @endif
            <td style="width: 50%; padding: 5px; vertical-align: top;">
                <img src="{{ $graficoUrl }}" alt="Gráfico {{ $nomeBarragem }}" style="width: 100%; max-height: 160px; border: 1px solid #ccc;">
            </td>
            @php $grafico_count++; @endphp
            @if($grafico_count % 2 == 0)
                </tr>
            @endif
        @endforeach
        @if($grafico_count % 2 != 0)
            <td style="width: 50%;"></td>
            </tr>
        @endif
    </table>
    @endif

    {{-- Gráficos das Estações Hidrométricas --}}
    @if(!empty($graficos_estacoes))
    <div class="page-break"></div>
    <div class="section-title" style="text-align: center; text-decoration: underline;">GRÁFICOS ILUSTRATIVOS - ESTAÇÕES HIDROMÉTRICAS</div>
    <table style="width: 100%; border-collapse: collapse; margin-top: 10px;">
        @php
            $grafico_est_count = 0;
            $graficos_est_array = is_array($graficos_estacoes) ? $graficos_estacoes : [];
        @endphp
        @foreach($graficos_est_array as $nomeEstacao => $graficoUrl)
            @if($grafico_est_count % 2 == 0)
                <tr>
            @endif
            <td style="width: 50%; padding: 5px; vertical-align: top;">
                <img src="{{ $graficoUrl }}" alt="Gráfico {{ $nomeEstacao }}" style="width: 100%; max-height: 160px; border: 1px solid #ccc;">
            </td>
            @php $grafico_est_count++; @endphp
            @if($grafico_est_count % 2 == 0)
                </tr>
            @endif
        @endforeach
        @if($grafico_est_count % 2 != 0)
            <td style="width: 50%;"></td>
            </tr>
        @endif
    </table>
    @endif
    @endif

    <!-- Assinatura -->
    <div style="margin-top: 30px; text-align: center; page-break-inside: avoid;">
        <p style="font-style: italic; margin: 0;">O Chefe do Recursos Hídricos</p>
        <div style="margin-top: 40px; display: inline-block; text-align: center; min-width: 220px;">
            <div style="border-top: 1px solid #000; padding-top: 5px; font-weight: bold;">{{ $settings['chefe_departamento_name'] ?? 'João A. M. Sitoe' }}</div>
            <div style="font-size: 9px;">({{ $settings['chefe_departamento_title'] ?? 'Inspector Superior' }})</div>
        </div>
    </div>

    <!-- Lista de Distribuição CC -->
    <div class="cc-section">
        <div class="cc-title">C.C:</div>
        <table class="cc-table">
            <tr>
                <td>Gabinetes dos Governador de Zmb, Npl, Nis e CD</td>
                <td>INAM – Zambézia, Nampula, Niassa e Cabo Delgado</td>
            </tr>
            <tr>
                <td>Gabinetes dos Sec. Estado de Zmb, Npl, Nis e CD</td>
                <td>ANE – Zambézia, Nampula, Niassa e Cabo delgado</td>
            </tr>
            <tr>
                <td>DNGRH / Gab. do Director Nacional</td>
                <td>RM – Zambézia, Nampula, Niassa e Cabo delgado</td>
            </tr>
            <tr>
                <td>SPI - Zambézia, Nampula, Niassa e Cabo delgado</td>
                <td>Wampula Fax – Nampula</td>
            </tr>
            <tr>
                <td>DPOPH - Zambézia, Nampula, Niassa e Cabo delgado</td>
                <td>Notícias – Delegação de Nampula</td>
            </tr>
            <tr>
                <td>INGD – Zambézia, Nampula, Niassa e Cabo delgado</td>
                <td>TVM - Delegação da Nampula</td>
            </tr>
            <tr>
                <td>Águas da Região do Norte e Centro (AdRN & AdRC)</td>
                <td>DPASA - Zambézia, Nampula, Niassa e Cabo Delgado</td>
            </tr>
        </table>
    </div>

    <!-- Footer -->
    <div class="footer">
        <div class="footer-wave">
            <div class="footer-content">
                <span class="footer-phone">&#9742; +258 86 201 7777</span>
                <span class="footer-email">@ aranorteip@aranorte.gov.mz</span>
                <div class="footer-address">&#9906; Estrada Nacional nº 1, Bairro Mutauanha, Nampula - Moçambique</div>
            </div>
        </div>
    </div>
</body>
</html>
