@extends('layouts.app')

@section('title', 'Gráficos e Relatórios')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-chart-line mr-3 text-blue-600"></i>
                    Gráficos e Relatórios
                </h1>
                <p class="text-gray-600 mt-2">Visualização de dados hidrológicos e análises estatísticas</p>
            </div>
        </div>
    </div>

    <!-- Menu de Opções -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <!-- Barragens -->
        <div class="bg-white rounded-lg shadow hover:shadow-lg transition-shadow">
            <div class="p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-water text-blue-600 text-xl"></i>
                        </div>
                    </div>
                    <div class="ml-4">
                        <h3 class="text-lg font-medium text-gray-900">Gráficos de Barragens</h3>
                        <p class="text-sm text-gray-500 mt-1">Níveis, volumes e enchimento das barragens</p>
                    </div>
                </div>
                <div class="mt-6">
                    <a href="{{ route('charts.barragens') }}" 
                       class="w-full bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center justify-center">
                        <i class="fas fa-chart-area mr-2"></i>
                        Ver Gráficos
                    </a>
                </div>
            </div>
        </div>

        <!-- Estações -->
        <div class="bg-white rounded-lg shadow hover:shadow-lg transition-shadow">
            <div class="p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-satellite-dish text-green-600 text-xl"></i>
                        </div>
                    </div>
                    <div class="ml-4">
                        <h3 class="text-lg font-medium text-gray-900">Gráficos de Estações</h3>
                        <p class="text-sm text-gray-500 mt-1">Precipitação, temperatura e dados meteorológicos</p>
                    </div>
                </div>
                <div class="mt-6">
                    <a href="{{ route('charts.estacoes') }}" 
                       class="w-full bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg flex items-center justify-center">
                        <i class="fas fa-chart-line mr-2"></i>
                        Ver Gráficos
                    </a>
                </div>
            </div>
        </div>

        <!-- Regional -->
        <div class="bg-white rounded-lg shadow hover:shadow-lg transition-shadow">
            <div class="p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-globe-africa text-purple-600 text-xl"></i>
                        </div>
                    </div>
                    <div class="ml-4">
                        <h3 class="text-lg font-medium text-gray-900">Análise Regional</h3>
                        <p class="text-sm text-gray-500 mt-1">Visão geral da região hidrológica</p>
                    </div>
                </div>
                <div class="mt-6">
                    <a href="{{ route('charts.regional') }}"
                       class="w-full bg-purple-600 hover:bg-purple-700 text-white px-6 py-3 rounded-lg flex items-center justify-center font-semibold transition-colors duration-200 shadow-lg hover:shadow-xl"
                       style="background-color: #9333ea !important;">
                        <i class="fas fa-map mr-3"></i>
                        <span class="text-base">Ver Análise Regional</span>
                        <i class="fas fa-arrow-right ml-3"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Resumo Rápido -->
    <div class="bg-white rounded-lg shadow p-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-6">Resumo do Sistema</h2>
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
            <div class="text-center">
                <div class="text-3xl font-bold text-blue-600">{{ \App\Models\Barragem::count() }}</div>
                <div class="text-sm text-gray-500 mt-1">Barragens Monitoradas</div>
            </div>
            <div class="text-center">
                <div class="text-3xl font-bold text-green-600">{{ \App\Models\Estacao::count() }}</div>
                <div class="text-sm text-gray-500 mt-1">Estações Ativas</div>
            </div>
            <div class="text-center">
                <div class="text-3xl font-bold text-orange-600">
                    {{ \App\Models\Estacao::where('tipo', 'hidrometrica')->count() }}
                </div>
                <div class="text-sm text-gray-500 mt-1">Estações Hidrométricas</div>
            </div>
            <div class="text-center">
                <div class="text-3xl font-bold text-purple-600">
                    {{ \App\Models\Estacao::where('tipo', 'pluviometrica')->count() }}
                </div>
                <div class="text-sm text-gray-500 mt-1">Estações Pluviométricas</div>
            </div>
        </div>
    </div>

    <!-- Links Rápidos -->
    <div class="bg-gray-50 rounded-lg p-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Links Rápidos</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <a href="{{ route('boletins.create') }}" 
               class="bg-white p-4 rounded-lg border border-gray-200 hover:border-blue-300 hover:shadow-md transition-all">
                <div class="flex items-center">
                    <i class="fas fa-file-alt text-blue-600 mr-3"></i>
                    <div>
                        <div class="font-medium text-gray-900">Gerar Boletim</div>
                        <div class="text-sm text-gray-500">Criar novo boletim hidrológico</div>
                    </div>
                </div>
            </a>
            
            <a href="{{ route('barragens.index') }}" 
               class="bg-white p-4 rounded-lg border border-gray-200 hover:border-blue-300 hover:shadow-md transition-all">
                <div class="flex items-center">
                    <i class="fas fa-water text-blue-600 mr-3"></i>
                    <div>
                        <div class="font-medium text-gray-900">Ver Barragens</div>
                        <div class="text-sm text-gray-500">Lista de todas as barragens</div>
                    </div>
                </div>
            </a>
            
            <a href="{{ route('estacoes.index') }}" 
               class="bg-white p-4 rounded-lg border border-gray-200 hover:border-green-300 hover:shadow-md transition-all">
                <div class="flex items-center">
                    <i class="fas fa-satellite-dish text-green-600 mr-3"></i>
                    <div>
                        <div class="font-medium text-gray-900">Ver Estações</div>
                        <div class="text-sm text-gray-500">Lista de todas as estações</div>
                    </div>
                </div>
            </a>
        </div>
    </div>

    <!-- Tipos de Gráficos Disponíveis -->
    <div class="bg-white rounded-lg shadow p-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Tipos de Visualizações Disponíveis</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <h3 class="font-medium text-gray-700 mb-3">Gráficos de Barragens:</h3>
                <ul class="space-y-2 text-sm text-gray-600">
                    <li class="flex items-center">
                        <i class="fas fa-chart-area text-blue-500 mr-2"></i>
                        Evolução do enchimento ao longo do tempo
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-chart-line text-blue-500 mr-2"></i>
                        Variação de níveis (cota)
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-chart-bar text-blue-500 mr-2"></i>
                        Comparação entre barragens
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-calendar text-blue-500 mr-2"></i>
                        Análise sazonal e histórica
                    </li>
                </ul>
            </div>
            <div>
                <h3 class="font-medium text-gray-700 mb-3">Gráficos de Estações:</h3>
                <ul class="space-y-2 text-sm text-gray-600">
                    <li class="flex items-center">
                        <i class="fas fa-cloud-rain text-green-500 mr-2"></i>
                        Precipitação acumulada
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-thermometer-half text-green-500 mr-2"></i>
                        Variação de temperatura
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-tint text-green-500 mr-2"></i>
                        Níveis hidrométricos
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-wind text-green-500 mr-2"></i>
                        Dados meteorológicos completos
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection