@extends('layouts.app')

@section('title', 'Importar Leituras - ' . $estacao->nome)

@section('content')
<div class="space-y-6">
    <!-- Breadcrumb e Header -->
    <div class="bg-white rounded-lg shadow">
        <!-- Breadcrumb -->
        <div class="px-6 py-3 border-b border-gray-200 bg-gray-50">
            <nav class="flex" aria-label="Breadcrumb">
                <ol class="inline-flex items-center space-x-2 md:space-x-4">
                    <li class="inline-flex items-center">
                        <a href="{{ route('dashboard') }}" class="text-gray-500 hover:text-gray-700">
                            <i class="fas fa-home mr-2"></i>
                            Dashboard
                        </a>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <a href="{{ route('estacoes.index') }}" class="text-gray-500 hover:text-gray-700">Estações</a>
                        </div>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <a href="{{ route('estacoes.show', $estacao) }}" class="text-gray-500 hover:text-gray-700">{{ $estacao->nome }}</a>
                        </div>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <a href="{{ route('estacoes.leituras', $estacao) }}" class="text-gray-500 hover:text-gray-700">Leituras</a>
                        </div>
                    </li>
                    <li aria-current="page">
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <span class="text-gray-800 font-medium">Importar Dados</span>
                        </div>
                    </li>
                </ol>
            </nav>
        </div>

        <!-- Header Principal -->
        <div class="px-6 py-6">
            <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                <div class="flex-1">
                    <div class="flex items-center mb-2">
                        <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center mr-4">
                            <i class="fas fa-file-import text-white text-xl"></i>
                        </div>
                        <div>
                            <h1 class="text-2xl font-bold text-gray-900">Importar Leituras</h1>
                            <p class="text-gray-600">{{ $estacao->nome }} • Código: {{ $estacao->codigo }}</p>
                        </div>
                    </div>

                    <div class="flex flex-wrap items-center gap-4 mt-4">
                        <div class="flex items-center bg-blue-50 px-3 py-1 rounded-full">
                            <i class="fas fa-satellite-dish text-blue-600 mr-2"></i>
                            <span class="text-sm font-medium text-blue-800">{{ ucfirst($estacao->tipo) }}</span>
                        </div>

                        <div class="flex items-center bg-purple-50 px-3 py-1 rounded-full">
                            <i class="fas fa-upload text-purple-600 mr-2"></i>
                            <span class="text-sm font-medium text-purple-800">Importação de Dados</span>
                        </div>
                    </div>
                </div>

                <div class="mt-4 lg:mt-0">
                    <a href="{{ route('estacoes.leituras', $estacao) }}"
                       class="bg-gray-600 hover:bg-gray-700 text-white font-semibold px-6 py-3 rounded-lg shadow-md hover:shadow-lg transition-all duration-200 inline-flex items-center">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Voltar às Leituras
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Formulário de Importação -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Coluna Principal -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Seleção de Arquivo -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                    <i class="fas fa-cloud-upload-alt mr-2 text-purple-600"></i>
                    Upload de Arquivo
                </h3>

                <form method="POST" action="{{ route('api.estacoes.importar-leituras', $estacao) }}" enctype="multipart/form-data" id="importForm" onsubmit="return handleImportSubmit(event)">
                    @csrf

                    <!-- Drop Zone -->
                    <div class="border-2 border-dashed border-gray-300 rounded-lg p-10 text-center hover:border-purple-400 transition-colors"
                         ondrop="dropHandler(event);" ondragover="dragOverHandler(event);" onclick="document.getElementById('fileInput').click();">
                        <i class="fas fa-cloud-upload-alt text-4xl text-gray-400 mb-6"></i>
                        <p class="text-lg font-medium text-gray-600 mb-3">Arraste e solte seu arquivo aqui</p>
                        <p class="text-sm text-gray-500 mb-6">ou clique para selecionar</p>
                        <input type="file" id="fileInput" name="arquivo_importacao" accept=".xlsx,.xls,.csv" class="hidden" onchange="handleFileSelect(this)">
                        <div class="flex justify-center">
                            <span class="inline-flex items-center px-6 py-3 text-white font-semibold rounded-lg shadow-md cursor-pointer transition-all duration-200"
                                  style="background-color: #7c3aed; border: 1px solid #7c3aed;"
                                  onmouseover="this.style.backgroundColor='#6d28d9'"
                                  onmouseout="this.style.backgroundColor='#7c3aed'">
                                <i class="fas fa-plus mr-2"></i>
                                Selecionar Arquivo
                            </span>
                        </div>
                    </div>

                    <!-- Arquivo Selecionado -->
                    <div id="selectedFile" class="hidden mt-4 p-4 bg-blue-50 rounded-lg border border-blue-200">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <i class="fas fa-file-excel text-green-600 text-2xl mr-3"></i>
                                <div>
                                    <p class="font-medium text-gray-900" id="fileName">arquivo.xlsx</p>
                                    <p class="text-sm text-gray-600" id="fileSize">0 KB</p>
                                </div>
                            </div>
                            <button type="button" onclick="removeFile()" class="text-red-600 hover:text-red-800">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>

                    <!-- Configurações de Importação -->
                    <div class="mt-8 grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Tipo de Template</label>
                            <select name="template_type" class="w-full border-gray-300 rounded-md shadow-sm focus:border-purple-500 focus:ring-purple-500">
                                <option value="moderno">Template Moderno</option>
                                <option value="legado">Template Legado (Excel)</option>
                                <option value="auto">Detecção Automática</option>
                            </select>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Ação para Duplicatas</label>
                            <select name="duplicate_action" class="w-full border-gray-300 rounded-md shadow-sm focus:border-purple-500 focus:ring-purple-500">
                                <option value="skip">Pular Duplicatas</option>
                                <option value="update">Atualizar Existentes</option>
                                <option value="error">Parar com Erro</option>
                            </select>
                        </div>
                    </div>

                    <!-- Botões de Ação -->
                    <div class="mt-8">
                        <!-- Botões Alinhados -->
                        <div class="flex flex-wrap gap-4 justify-center py-4">
                            <button type="button" onclick="previewFile()"
                                    class="bg-blue-600 hover:bg-blue-700 text-white font-semibold px-6 py-3 rounded-lg shadow-md hover:shadow-lg transition-all duration-200 flex items-center disabled:opacity-50 disabled:cursor-not-allowed"
                                    id="previewBtn" disabled>
                                <i class="fas fa-eye mr-2"></i>
                                Preview dos Dados
                            </button>
                            <button type="button" onclick="validateFile()"
                                    class="bg-yellow-600 hover:bg-yellow-700 text-white font-semibold px-6 py-3 rounded-lg shadow-md hover:shadow-lg transition-all duration-200 flex items-center disabled:opacity-50 disabled:cursor-not-allowed"
                                    id="validateBtn" disabled>
                                <i class="fas fa-shield-alt mr-2"></i>
                                Validar Arquivo
                            </button>
                            <button type="submit"
                                    class="bg-green-600 hover:bg-green-700 text-white font-bold px-8 py-3 rounded-lg shadow-md hover:shadow-lg transition-all duration-200 flex items-center disabled:opacity-50 disabled:cursor-not-allowed"
                                    id="importBtn" disabled>
                                <i class="fas fa-file-import mr-2"></i>
                                Importar Dados
                            </button>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Preview dos Dados -->
            <div id="previewSection" class="hidden bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                    <i class="fas fa-table mr-2 text-blue-600"></i>
                    Preview dos Dados
                </h3>
                <div id="previewContent" class="overflow-x-auto">
                    <!-- Conteúdo será inserido aqui -->
                </div>
            </div>

            <!-- Resultados da Validação -->
            <div id="validationSection" class="hidden bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                    <i class="fas fa-shield-alt mr-2 text-yellow-600"></i>
                    Resultados da Validação
                </h3>
                <div id="validationContent">
                    <!-- Conteúdo será inserido aqui -->
                </div>
            </div>
        </div>

        <!-- Coluna Lateral -->
        <div class="space-y-6">
            <!-- Templates Disponíveis -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                    <i class="fas fa-download mr-2 text-green-600"></i>
                    Templates
                </h3>

                <div class="space-y-3">
                    <a href="{{ route('templates.leituras', ['tipo' => $estacao->tipo, 'formato' => 'moderno']) }}"
                       class="bg-green-600 hover:bg-green-700 text-white font-semibold px-4 py-3 rounded-lg shadow-md hover:shadow-lg transition-all duration-200 flex items-center w-full">
                        <i class="fas fa-file-excel mr-2"></i>
                        Template Moderno
                    </a>

                    <a href="{{ route('templates.leituras', ['tipo' => $estacao->tipo, 'formato' => 'legado']) }}"
                       class="bg-blue-600 hover:bg-blue-700 text-white font-semibold px-4 py-3 rounded-lg shadow-md hover:shadow-lg transition-all duration-200 flex items-center w-full">
                        <i class="fas fa-file-alt mr-2"></i>
                        Template Legado
                    </a>

                    <button type="button" onclick="showTemplateGuide()"
                            class="bg-gray-600 hover:bg-gray-700 text-white font-semibold px-4 py-3 rounded-lg shadow-md hover:shadow-lg transition-all duration-200 flex items-center w-full">
                        <i class="fas fa-question-circle mr-2"></i>
                        Guia de Formatação
                    </button>
                </div>
            </div>

            <!-- Informações -->
            <div class="bg-blue-50 rounded-lg p-6">
                <h4 class="font-semibold text-blue-900 mb-3 flex items-center">
                    <i class="fas fa-info-circle mr-2"></i>
                    Formatos Suportados
                </h4>
                <ul class="space-y-2 text-sm text-blue-800">
                    <li class="flex items-center">
                        <i class="fas fa-check text-green-600 mr-2"></i>
                        Excel (.xlsx, .xls)
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-check text-green-600 mr-2"></i>
                        CSV (.csv)
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-check text-green-600 mr-2"></i>
                        Templates antigos
                    </li>
                </ul>
            </div>

            <!-- Estatísticas Rápidas -->
            <div class="bg-yellow-50 rounded-lg p-6">
                <h4 class="font-semibold text-yellow-900 mb-3 flex items-center">
                    <i class="fas fa-chart-pie mr-2"></i>
                    Estatísticas
                </h4>
                <div class="space-y-2 text-sm">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Total de Leituras:</span>
                        <span class="font-medium">{{ $estacao->leituras()->count() }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Última Leitura:</span>
                        <span class="font-medium">
                            {{ $estacao->ultima_leitura ? $estacao->ultima_leitura->data_leitura->format('d/m/Y') : 'N/A' }}
                        </span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Tipo de Estação:</span>
                        <span class="font-medium">{{ ucfirst($estacao->tipo) }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>

/* Progress bar styles */
.progress-bar {
    width: 0%;
    transition: width 0.3s ease;
}

/* Upload animations */
.upload-hover {
    @apply border-purple-400 bg-purple-50;
}
</style>

<script>
let selectedFile = null;

function dragOverHandler(ev) {
    ev.preventDefault();
    ev.currentTarget.classList.add('upload-hover');
}

function dropHandler(ev) {
    ev.preventDefault();
    ev.currentTarget.classList.remove('upload-hover');

    const files = ev.dataTransfer.files;
    if (files.length > 0) {
        handleFile(files[0]);
    }
}

function handleFileSelect(input) {
    if (input.files && input.files[0]) {
        handleFile(input.files[0]);
    }
}

function handleFile(file) {
    // Verificar tipo de arquivo
    const allowedTypes = [
        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        'application/vnd.ms-excel',
        'text/csv'
    ];

    if (!allowedTypes.includes(file.type)) {
        alert('Tipo de arquivo não suportado. Use .xlsx, .xls ou .csv');
        return;
    }

    selectedFile = file;

    // Mostrar arquivo selecionado
    document.getElementById('selectedFile').classList.remove('hidden');
    document.getElementById('fileName').textContent = file.name;
    document.getElementById('fileSize').textContent = formatFileSize(file.size);

    // Habilitar botões
    document.getElementById('previewBtn').disabled = false;
    document.getElementById('validateBtn').disabled = false;
    document.getElementById('importBtn').disabled = false;
}

function removeFile() {
    selectedFile = null;
    document.getElementById('selectedFile').classList.add('hidden');
    document.getElementById('fileInput').value = '';

    // Desabilitar botões
    document.getElementById('previewBtn').disabled = true;
    document.getElementById('validateBtn').disabled = true;
    document.getElementById('importBtn').disabled = true;

    // Esconder seções
    document.getElementById('previewSection').classList.add('hidden');
    document.getElementById('validationSection').classList.add('hidden');
}

function formatFileSize(bytes) {
    if (bytes === 0) return '0 Bytes';
    const k = 1024;
    const sizes = ['Bytes', 'KB', 'MB', 'GB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
}

function previewFile() {
    if (!selectedFile) return;

    const previewSection = document.getElementById('previewSection');
    const previewContent = document.getElementById('previewContent');

    previewContent.innerHTML = `
        <div class="text-center py-8">
            <i class="fas fa-spinner fa-spin text-2xl text-blue-600 mb-4"></i>
            <p class="text-gray-600">Analisando arquivo real...</p>
        </div>
    `;

    previewSection.classList.remove('hidden');
    previewSection.scrollIntoView({ behavior: 'smooth' });

    // Fazer upload para preview
    const formData = new FormData();
    formData.append('arquivo_importacao', selectedFile);
    formData.append('_token', document.querySelector('input[name="_token"]').value);

    fetch("{{ route('api.estacoes.preview-leituras', $estacao) }}", {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            displayPreviewData(data);
        } else {
            previewContent.innerHTML = `
                <div class="text-center py-8">
                    <i class="fas fa-exclamation-triangle text-4xl text-red-500 mb-4"></i>
                    <h3 class="text-lg font-medium text-red-900 mb-2">Erro ao processar arquivo</h3>
                    <p class="text-red-700">${data.message}</p>
                </div>
            `;
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        previewContent.innerHTML = `
            <div class="text-center py-8">
                <i class="fas fa-exclamation-triangle text-4xl text-red-500 mb-4"></i>
                <h3 class="text-lg font-medium text-red-900 mb-2">Erro de conexão</h3>
                <p class="text-red-700">Não foi possível processar o arquivo</p>
            </div>
        `;
    });
}

function displayPreviewData(data) {
    const previewContent = document.getElementById('previewContent');
    const stats = data.estatisticas;
    const dadosRaw = data.dados_raw || [];

    // Criar estatísticas do arquivo
    let statisticsHtml = `
        <div class="bg-gradient-to-r from-blue-50 to-indigo-50 rounded-xl p-6 mb-6">
            <h4 class="font-bold text-blue-900 mb-4 flex items-center">
                <i class="fas fa-file-excel mr-2"></i>
                Preview do Arquivo: ${stats.arquivo_nome}
            </h4>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-sm">
                <div class="bg-white rounded-lg p-3">
                    <div class="text-gray-600">Total de Linhas</div>
                    <div class="font-bold text-lg text-blue-600">${stats.total_linhas}</div>
                </div>
                <div class="bg-white rounded-lg p-3">
                    <div class="text-gray-600">Colunas Detectadas</div>
                    <div class="font-bold text-lg text-green-600">${stats.total_colunas}</div>
                </div>
                <div class="bg-white rounded-lg p-3">
                    <div class="text-gray-600">Período</div>
                    <div class="font-bold text-sm text-purple-600">${stats.periodo}</div>
                </div>
                <div class="bg-white rounded-lg p-3">
                    <div class="text-gray-600">Tamanho</div>
                    <div class="font-bold text-sm text-orange-600">${stats.arquivo_tamanho}</div>
                </div>
            </div>
        </div>
    `;

    // Criar tabela exatamente como no Excel/CSV
    if (dadosRaw.length > 0) {
        let tableHtml = `
            <div class="bg-white rounded-xl shadow-lg p-4">
                <h5 class="font-semibold text-gray-800 mb-4 flex items-center justify-between">
                    <div class="flex items-center">
                        <i class="fas fa-table mr-2"></i>
                        Preview do arquivo (formato Excel)
                    </div>
                    <div class="text-sm text-gray-600 font-normal">
                        Mostrando ${Math.min(50, dadosRaw.length - 1)} de ${stats.total_linhas} linhas
                    </div>
                </h5>
                <div class="overflow-auto border-2 border-gray-300 rounded-lg max-h-96" style="scrollbar-width: thin;">
                    <table class="min-w-full border-collapse excel-table">
        `;

        // Mostrar cada linha exatamente como está no arquivo
        dadosRaw.forEach((linha, rowIndex) => {
            const isHeader = rowIndex === 0;

            tableHtml += `<tr>`;

            linha.forEach((valor, colIndex) => {
                const displayValue = valor === null || valor === undefined ? '' : valor;
                const isFirstColumn = colIndex === 0;

                // Definir classes baseado na posição
                let cellClass = 'excel-cell';
                let textClass = 'text-center';
                let bgClass = '';

                if (isHeader) {
                    cellClass += ' excel-header';
                    textClass = 'text-center font-bold';
                    bgClass = 'bg-gray-200';
                } else if (isFirstColumn) {
                    cellClass += ' excel-row-header';
                    textClass = 'text-center font-semibold';
                    bgClass = 'bg-gray-100';
                } else {
                    bgClass = 'bg-white';
                }

                tableHtml += `
                    <td class="${cellClass} ${bgClass} ${textClass}">
                        ${displayValue}
                    </td>
                `;
            });

            tableHtml += `</tr>`;
        });

        tableHtml += `
                    </table>
                </div>
            </div>

            <style>
                .excel-table {
                    border-collapse: collapse;
                    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                }

                .excel-cell {
                    border: 1px solid #d1d5db;
                    padding: 8px 12px;
                    font-size: 13px;
                    min-width: 80px;
                    white-space: nowrap;
                }

                .excel-header {
                    font-weight: bold;
                    background-color: #f3f4f6 !important;
                    border: 1px solid #9ca3af;
                    color: #374151;
                }

                .excel-row-header {
                    font-weight: 600;
                    background-color: #f9fafb !important;
                    border: 1px solid #d1d5db;
                    color: #4b5563;
                }

                .excel-cell:hover {
                    background-color: #e5f3ff !important;
                }

                /* Estilo para números */
                .excel-cell:not(.excel-header):not(.excel-row-header) {
                    font-family: 'Courier New', monospace;
                }
            </style>
        `;

        statisticsHtml += tableHtml;
    }

    // Footer informativo
    const totalLinhasArquivo = dadosRaw.length > 0 ? dadosRaw.length - 1 : 0; // -1 para excluir cabeçalho
    statisticsHtml += `
        <div class="mt-6 flex flex-col sm:flex-row sm:items-center sm:justify-between bg-green-50 rounded-lg p-4 gap-4">
            <div class="flex items-center text-green-700">
                <i class="fas fa-check-circle mr-2"></i>
                <span class="font-medium">
                    Preview mostra exatamente como no Excel •
                    Exibindo ${dadosRaw.length > 0 ? dadosRaw.length - 1 : 0} de ${stats.total_linhas} linhas de dados + cabeçalho
                </span>
            </div>
            <div class="flex gap-2">
                <button onclick="validateFile()" class="bg-yellow-600 hover:bg-yellow-700 text-white px-4 py-2 rounded-lg font-medium transition-colors flex items-center">
                    <i class="fas fa-shield-alt mr-2"></i>
                    Validar
                </button>
            </div>
        </div>
    `;

    previewContent.innerHTML = statisticsHtml;
}

function validateFile() {
    const validationSection = document.getElementById('validationSection');
    const validationContent = document.getElementById('validationContent');

    validationContent.innerHTML = `
        <div class="text-center py-8">
            <i class="fas fa-spinner fa-spin text-2xl text-yellow-600 mb-4"></i>
            <p class="text-gray-600">Validando dados...</p>
        </div>
    `;

    validationSection.classList.remove('hidden');

    // Simular validação
    setTimeout(() => {
        validationContent.innerHTML = `
            <div class="space-y-4">
                <div class="flex items-center text-green-600">
                    <i class="fas fa-check-circle mr-2"></i>
                    <span>Formato do arquivo válido</span>
                </div>
                <div class="flex items-center text-green-600">
                    <i class="fas fa-check-circle mr-2"></i>
                    <span>Colunas obrigatórias encontradas</span>
                </div>
                <div class="flex items-center text-yellow-600">
                    <i class="fas fa-exclamation-triangle mr-2"></i>
                    <span>3 linhas com dados incompletos (serão ignoradas)</span>
                </div>
                <div class="flex items-center text-blue-600">
                    <i class="fas fa-info-circle mr-2"></i>
                    <span>147 linhas válidas prontas para importação</span>
                </div>
            </div>
        `;
    }, 2000);
}

function showTemplateGuide() {
    alert('Guia de Formatação:\n\n1. Use a primeira linha para cabeçalhos\n2. Data no formato DD/MM/AAAA\n3. Valores numéricos com ponto decimal\n4. Não deixe células vazias em dados obrigatórios');
}

function handleImportSubmit(event) {
    event.preventDefault();

    if (!selectedFile) {
        alert('Por favor, selecione um arquivo primeiro.');
        return false;
    }

    const form = document.getElementById('importForm');
    const formData = new FormData(form);
    const importBtn = document.getElementById('importBtn');

    // Mostrar progresso
    importBtn.disabled = true;
    importBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Importando...';

    // Fazer upload via AJAX
    fetch(form.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') ||
                           document.querySelector('input[name="_token"]').value
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert(`Importação concluída com sucesso!\n\n${data.importadas} leituras importadas.`);
            // Redirecionar para página de leituras
            window.location.href = "{{ route('estacoes.leituras', $estacao) }}";
        } else {
            alert('Erro na importação: ' + (data.message || 'Erro desconhecido'));
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        alert('Erro ao importar arquivo. Verifique o console para mais detalhes.');
    })
    .finally(() => {
        // Restaurar botão
        importBtn.disabled = false;
        importBtn.innerHTML = '<i class="fas fa-file-import mr-2 text-lg"></i>Importar Dados';
    });

    return false;
}

// Prevent default drag behaviors
['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
    document.addEventListener(eventName, preventDefaults, false);
});

function preventDefaults(e) {
    e.preventDefault();
    e.stopPropagation();
}
</script>
@endsection