<!-- Modal Avançado para Nova Leitura -->
<div id="addLeituraModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden z-50">
    <div class="flex items-start justify-center min-h-screen p-4 py-8">
        <div class="bg-white rounded-xl shadow-2xl w-full max-w-6xl max-h-[85vh] overflow-hidden my-auto">
            <form method="POST" action="{{ route('estacoes.storeLeitura', $estacao) }}" id="leituraForm" enctype="multipart/form-data">
                @csrf

                <!-- Header do Modal -->
                <div class="bg-gradient-to-r from-green-600 to-green-700 px-6 py-4 text-white">
                    <div class="flex justify-between items-center">
                        <div>
                            <h3 class="text-xl font-bold flex items-center">
                                <i class="fas fa-chart-line mr-3"></i>
                                Nova Leitura - {{ $estacao->nome }}
                            </h3>
                            <p class="text-green-100 text-sm mt-1">
                                {{ ucfirst($estacao->tipo) }} • {{ $estacao->codigo }} • {{ now()->format('d/m/Y H:i') }}
                            </p>
                        </div>
                        <button type="button" onclick="hideAddLeituraModal()" class="text-white hover:text-gray-200 text-2xl">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>

                <!-- Navegação por Abas -->
                <div class="bg-gray-50 border-b border-gray-200">
                    <nav class="px-6 py-2" aria-label="Tabs">
                        <div class="flex flex-wrap gap-2">
                            <button type="button" class="tab-button active" data-tab="dados-principais">
                                <i class="fas fa-edit mr-2"></i>
                                <span class="hidden sm:inline">Dados Principais</span>
                                <span class="sm:hidden">Dados</span>
                            </button>
                            <button type="button" class="tab-button" data-tab="dados-meteorologicos"
                                    @if(!in_array($estacao->tipo, ['meteorologica', 'climatologica'])) style="display: none;" @endif>
                                <i class="fas fa-cloud-sun mr-2"></i>
                                <span class="hidden sm:inline">Dados Meteorológicos</span>
                                <span class="sm:hidden">Meteo</span>
                            </button>
                            <button type="button" class="tab-button" data-tab="validacao-qualidade">
                                <i class="fas fa-check-circle mr-2"></i>
                                <span class="hidden sm:inline">Validação & Qualidade</span>
                                <span class="sm:hidden">Validação</span>
                            </button>
                            <button type="button" class="tab-button" data-tab="historico-comparacao">
                                <i class="fas fa-history mr-2"></i>
                                <span class="hidden sm:inline">Histórico & Comparação</span>
                                <span class="sm:hidden">Histórico</span>
                            </button>
                            <button type="button" class="tab-button" data-tab="importacao">
                                <i class="fas fa-file-excel mr-2"></i>
                                <span class="hidden sm:inline">Importação</span>
                                <span class="sm:hidden">Import</span>
                            </button>
                        </div>
                    </nav>
                </div>

                <div class="overflow-y-auto" style="max-height: calc(85vh - 160px);">
                    <!-- Aba: Dados Principais -->
                    <div id="dados-principais" class="tab-content active p-6 space-y-6">

                        <!-- Informações Básicas -->
                        <div class="bg-blue-50 rounded-lg p-4">
                            <h4 class="font-semibold text-blue-900 mb-3 flex items-center">
                                <i class="fas fa-info-circle mr-2"></i>
                                Informações da Leitura
                            </h4>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        <i class="fas fa-calendar mr-1"></i>
                                        Data da Leitura *
                                    </label>
                                    <input type="date" name="data_leitura" id="data_leitura" required
                                           value="{{ date('Y-m-d') }}"
                                           max="{{ date('Y-m-d') }}"
                                           class="w-full border-gray-300 rounded-lg shadow-sm focus:border-green-500 focus:ring-green-500">
                                    <small class="text-gray-500">Máximo: hoje</small>
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        <i class="fas fa-user mr-1"></i>
                                        Operador
                                    </label>
                                    <input type="text" value="{{ Auth::user()->name }}" readonly
                                           class="w-full border-gray-300 rounded-lg shadow-sm bg-gray-50">
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        <i class="fas fa-clock mr-1"></i>
                                        Hora de Registro
                                    </label>
                                    <input type="time" name="hora_registro" value="{{ date('H:i') }}"
                                           class="w-full border-gray-300 rounded-lg shadow-sm focus:border-green-500 focus:ring-green-500">
                                </div>
                            </div>
                        </div>

                        <!-- Verificação de Duplicatas -->
                        <div id="verificacao-duplicata" class="hidden bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                            <div class="flex items-center">
                                <i class="fas fa-exclamation-triangle text-yellow-600 mr-3"></i>
                                <div>
                                    <h4 class="font-medium text-yellow-800">Leitura já existe para esta data</h4>
                                    <p class="text-sm text-yellow-700">Deseja sobrescrever os dados existentes?</p>
                                </div>
                            </div>
                        </div>

                        <!-- Dados Hidrométricos -->
                        @if($estacao->tipo == 'hidrometrica')
                        <div class="bg-gradient-to-r from-blue-50 to-indigo-50 rounded-lg p-6">
                            <h4 class="font-semibold text-blue-900 mb-4 flex items-center">
                                <i class="fas fa-water mr-2"></i>
                                Leituras Hidrométricas
                            </h4>

                            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                                <!-- Leitura 6h -->
                                <div class="bg-white rounded-lg p-4 border border-blue-200">
                                    <h5 class="font-medium text-blue-800 mb-3 flex items-center">
                                        <i class="fas fa-sun mr-2"></i>
                                        Leitura 6:00h
                                    </h5>
                                    <div class="space-y-3">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Hora Exata</label>
                                            <input type="time" name="hora_6h" value="06:00"
                                                   class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Nível (m)</label>
                                            <input type="number" step="0.01" name="nivel_6h" id="nivel_6h"
                                                   placeholder="Ex: 2.45"
                                                   class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                                   onchange="calcularEstatisticas()">
                                        </div>
                                    </div>
                                </div>

                                <!-- Leitura 12h -->
                                <div class="bg-white rounded-lg p-4 border border-blue-200">
                                    <h5 class="font-medium text-blue-800 mb-3 flex items-center">
                                        <i class="fas fa-sun mr-2"></i>
                                        Leitura 12:00h
                                    </h5>
                                    <div class="space-y-3">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Hora Exata</label>
                                            <input type="time" name="hora_12h" value="12:00"
                                                   class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Nível (m)</label>
                                            <input type="number" step="0.01" name="nivel_12h" id="nivel_12h"
                                                   placeholder="Ex: 2.47"
                                                   class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                                   onchange="calcularEstatisticas()">
                                        </div>
                                    </div>
                                </div>

                                <!-- Leitura 18h -->
                                <div class="bg-white rounded-lg p-4 border border-blue-200">
                                    <h5 class="font-medium text-blue-800 mb-3 flex items-center">
                                        <i class="fas fa-moon mr-2"></i>
                                        Leitura 18:00h
                                    </h5>
                                    <div class="space-y-3">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Hora Exata</label>
                                            <input type="time" name="hora_18h" value="18:00"
                                                   class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Nível (m)</label>
                                            <input type="number" step="0.01" name="nivel_18h" id="nivel_18h"
                                                   placeholder="Ex: 2.43"
                                                   class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                                   onchange="calcularEstatisticas()">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Cálculos Automáticos -->
                            <div class="mt-6 bg-white rounded-lg p-4 border-2 border-dashed border-blue-300">
                                <h5 class="font-medium text-blue-800 mb-3 flex items-center">
                                    <i class="fas fa-calculator mr-2"></i>
                                    Cálculos Automáticos
                                </h5>
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-1">Nível Médio (m)</label>
                                        <input type="number" step="0.01" id="nivel_medio" readonly
                                               class="w-full border-gray-300 rounded-md shadow-sm bg-gray-50">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-1">Variação (m)</label>
                                        <input type="number" step="0.01" id="variacao_nivel" readonly
                                               class="w-full border-gray-300 rounded-md shadow-sm bg-gray-50">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-1">Caudal Estimado (m³/s)</label>
                                        <input type="number" step="0.001" id="caudal_estimado" readonly
                                               class="w-full border-gray-300 rounded-md shadow-sm bg-gray-50">
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif

                        <!-- Dados Pluviométricos -->
                        @if(in_array($estacao->tipo, ['pluviometrica', 'meteorologica', 'climatologica']))
                        <div class="bg-gradient-to-r from-green-50 to-emerald-50 rounded-lg p-6">
                            <h4 class="font-semibold text-green-900 mb-4 flex items-center">
                                <i class="fas fa-cloud-rain mr-2"></i>
                                Dados Pluviométricos
                            </h4>

                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Precipitação Total (mm) *
                                    </label>
                                    <input type="number" step="0.1" name="precipitacao_mm" id="precipitacao_mm"
                                           placeholder="Ex: 15.2"
                                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-green-500 focus:ring-green-500">
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Intensidade Máxima (mm/h)
                                    </label>
                                    <input type="number" step="0.1" name="intensidade_maxima"
                                           placeholder="Ex: 5.2"
                                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-green-500 focus:ring-green-500">
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Duração (horas)
                                    </label>
                                    <input type="number" step="0.1" name="duracao_precipitacao"
                                           placeholder="Ex: 3.5"
                                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-green-500 focus:ring-green-500">
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Tipo de Precipitação
                                    </label>
                                    <select name="tipo_precipitacao"
                                            class="w-full border-gray-300 rounded-md shadow-sm focus:border-green-500 focus:ring-green-500">
                                        <option value="">Selecionar</option>
                                        <option value="chuva">Chuva</option>
                                        <option value="chuvisco">Chuvisco</option>
                                        <option value="granizo">Granizo</option>
                                        <option value="neve">Neve</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>

                    <!-- Aba: Dados Meteorológicos -->
                    <div id="dados-meteorologicos" class="tab-content p-6 space-y-6" style="display: none;">
                        @if(in_array($estacao->tipo, ['meteorologica', 'climatologica']))
                        <div class="bg-gradient-to-r from-purple-50 to-pink-50 rounded-lg p-6">
                            <h4 class="font-semibold text-purple-900 mb-4 flex items-center">
                                <i class="fas fa-thermometer-half mr-2"></i>
                                Dados de Temperatura
                            </h4>

                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Temperatura Máxima (°C) *
                                    </label>
                                    <input type="number" step="0.1" name="temperatura_max" id="temp_max"
                                           placeholder="Ex: 28.5"
                                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-purple-500 focus:ring-purple-500"
                                           onchange="validarTemperaturas()">
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Temperatura Mínima (°C) *
                                    </label>
                                    <input type="number" step="0.1" name="temperatura_min" id="temp_min"
                                           placeholder="Ex: 18.2"
                                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-purple-500 focus:ring-purple-500"
                                           onchange="validarTemperaturas()">
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Temperatura Atual (°C)
                                    </label>
                                    <input type="number" step="0.1" name="temperatura_atual"
                                           placeholder="Ex: 24.1"
                                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-purple-500 focus:ring-purple-500">
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Amplitude Térmica (°C)
                                    </label>
                                    <input type="number" step="0.1" id="amplitude_termica" readonly
                                           class="w-full border-gray-300 rounded-md shadow-sm bg-gray-50">
                                </div>
                            </div>
                        </div>

                        <div class="bg-gradient-to-r from-cyan-50 to-blue-50 rounded-lg p-6">
                            <h4 class="font-semibold text-cyan-900 mb-4 flex items-center">
                                <i class="fas fa-wind mr-2"></i>
                                Dados Atmosféricos
                            </h4>

                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Humidade Relativa (%)
                                    </label>
                                    <input type="number" step="0.1" min="0" max="100" name="humidade_relativa"
                                           placeholder="Ex: 65.5"
                                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-cyan-500 focus:ring-cyan-500">
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Pressão Atmosférica (hPa)
                                    </label>
                                    <input type="number" step="0.1" name="pressao_atmosferica"
                                           placeholder="Ex: 1013.2"
                                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-cyan-500 focus:ring-cyan-500">
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Velocidade do Vento (km/h)
                                    </label>
                                    <input type="number" step="0.1" name="velocidade_vento"
                                           placeholder="Ex: 12.5"
                                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-cyan-500 focus:ring-cyan-500">
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Direção do Vento
                                    </label>
                                    <select name="direcao_vento"
                                            class="w-full border-gray-300 rounded-md shadow-sm focus:border-cyan-500 focus:ring-cyan-500">
                                        <option value="">Selecionar</option>
                                        <option value="N">Norte (N)</option>
                                        <option value="NE">Nordeste (NE)</option>
                                        <option value="E">Este (E)</option>
                                        <option value="SE">Sudeste (SE)</option>
                                        <option value="S">Sul (S)</option>
                                        <option value="SW">Sudoeste (SW)</option>
                                        <option value="W">Oeste (W)</option>
                                        <option value="NW">Noroeste (NW)</option>
                                    </select>
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Evaporação (mm)
                                    </label>
                                    <input type="number" step="0.1" name="evaporacao"
                                           placeholder="Ex: 4.2"
                                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-cyan-500 focus:ring-cyan-500">
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Insolação (horas)
                                    </label>
                                    <input type="number" step="0.1" min="0" max="24" name="insolacao"
                                           placeholder="Ex: 8.5"
                                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-cyan-500 focus:ring-cyan-500">
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>

                    <!-- Aba: Validação & Qualidade -->
                    <div id="validacao-qualidade" class="tab-content p-6 space-y-6" style="display: none;">
                        <div class="bg-yellow-50 rounded-lg p-6">
                            <h4 class="font-semibold text-yellow-900 mb-4 flex items-center">
                                <i class="fas fa-shield-alt mr-2"></i>
                                Controle de Qualidade dos Dados
                            </h4>

                            <div id="validacao-resultados" class="space-y-4">
                                <!-- Resultados de validação serão inseridos aqui via JavaScript -->
                            </div>

                            <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Status da Leitura
                                    </label>
                                    <select name="status_qualidade"
                                            class="w-full border-gray-300 rounded-md shadow-sm focus:border-yellow-500 focus:ring-yellow-500">
                                        <option value="validado">Validado</option>
                                        <option value="provisorio">Provisório</option>
                                        <option value="duvidoso">Duvidoso</option>
                                        <option value="rejeitado">Rejeitado</option>
                                    </select>
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Confiabilidade (%)
                                    </label>
                                    <input type="number" min="0" max="100" name="confiabilidade" value="100"
                                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-yellow-500 focus:ring-yellow-500">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Aba: Histórico & Comparação -->
                    <div id="historico-comparacao" class="tab-content p-6 space-y-6" style="display: none;">
                        <div class="bg-indigo-50 rounded-lg p-6">
                            <h4 class="font-semibold text-indigo-900 mb-4 flex items-center">
                                <i class="fas fa-chart-area mr-2"></i>
                                Comparação com Dados Históricos
                            </h4>

                            <div id="comparacao-historica" class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                <!-- Será preenchido via JavaScript -->
                            </div>
                        </div>
                    </div>

                    <!-- Aba: Importação -->
                    <div id="importacao" class="tab-content p-6 space-y-6" style="display: none;">
                        <div class="bg-emerald-50 rounded-lg p-6">
                            <h4 class="font-semibold text-emerald-900 mb-4 flex items-center">
                                <i class="fas fa-file-import mr-2"></i>
                                Importação de Dados
                            </h4>

                            <div class="space-y-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Arquivo Excel/CSV
                                    </label>
                                    <input type="file" name="arquivo_importacao" accept=".xlsx,.xls,.csv"
                                           class="w-full border-gray-300 rounded-md shadow-sm focus:border-emerald-500 focus:ring-emerald-500"
                                           onchange="processarArquivoImportacao(this)">
                                    <small class="text-gray-500">Formatos suportados: .xlsx, .xls, .csv</small>
                                </div>

                                <div id="preview-importacao" class="hidden bg-white rounded-lg border p-4">
                                    <h5 class="font-medium text-gray-900 mb-3">Preview dos Dados</h5>
                                    <div id="dados-preview" class="overflow-x-auto">
                                        <!-- Tabela de preview será inserida aqui -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Observações -->
                    <div class="p-6 border-t">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                <i class="fas fa-sticky-note mr-1"></i>
                                Observações
                            </label>
                            <textarea name="observacoes" rows="3"
                                      class="w-full border-gray-300 rounded-md shadow-sm focus:border-green-500 focus:ring-green-500"
                                      placeholder="Observações sobre as condições meteorológicas, equipamentos, anomalias observadas, etc..."></textarea>
                        </div>
                    </div>
                </div>

                <!-- Footer do Modal -->
                <div class="bg-gray-50 px-6 py-4 border-t flex justify-between items-center">
                    <div class="flex items-center space-x-4">
                        <button type="button" onclick="preencherDadosExemplo()"
                                class="text-sm text-blue-600 hover:text-blue-800">
                            <i class="fas fa-magic mr-1"></i>
                            Dados de Exemplo
                        </button>
                        <button type="button" onclick="limparFormulario()"
                                class="text-sm text-red-600 hover:text-red-800">
                            <i class="fas fa-eraser mr-1"></i>
                            Limpar Tudo
                        </button>
                    </div>

                    <div class="flex space-x-3">
                        <button type="button" onclick="hideAddLeituraModal()"
                                class="bg-gray-300 hover:bg-gray-400 text-gray-700 px-6 py-2 rounded-lg">
                            <i class="fas fa-times mr-2"></i>
                            Cancelar
                        </button>
                        <button type="button" onclick="salvarRascunho()"
                                class="bg-yellow-500 hover:bg-yellow-600 text-white px-6 py-2 rounded-lg">
                            <i class="fas fa-save mr-2"></i>
                            Salvar Rascunho
                        </button>
                        <button type="submit"
                                class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded-lg">
                            <i class="fas fa-check mr-2"></i>
                            Salvar Leitura
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
/* Modal específico */
#addLeituraModal {
    overflow-y: auto;
}

#addLeituraModal .bg-white {
    margin: auto;
}

/* Tab buttons */
.tab-button {
    @apply inline-flex items-center px-4 py-2 rounded-lg text-sm font-medium transition-all duration-200 border border-transparent;
    @apply text-gray-600 bg-white hover:bg-gray-50 hover:text-gray-800 hover:border-gray-200;
    @apply shadow-sm hover:shadow-md;
}

.tab-button.active {
    @apply bg-gradient-to-r from-green-500 to-green-600 text-white border-green-500;
    @apply shadow-md hover:from-green-600 hover:to-green-700;
}

.tab-button:not(.active):hover {
    @apply transform scale-105;
}

.tab-content {
    display: none;
}

.tab-content.active {
    display: block;
}

/* Responsive adjustments */
@media (max-width: 640px) {
    .tab-button {
        @apply px-3 py-2 text-xs;
    }

    #addLeituraModal .bg-white {
        max-height: 90vh !important;
        margin: 20px auto;
    }

    #addLeituraModal .overflow-y-auto {
        max-height: calc(90vh - 140px) !important;
    }
}

@media (max-width: 768px) {
    #addLeituraModal .bg-white {
        max-height: 88vh !important;
        margin: 15px auto;
    }

    #addLeituraModal .overflow-y-auto {
        max-height: calc(88vh - 150px) !important;
    }
}
</style>