@extends('layouts.app')

@section('title', 'Configurações do Sistema')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-800">
                    <i class="fas fa-server mr-3 text-gray-600"></i>
                    Configurações do Sistema
                </h1>
                <p class="text-gray-600 mt-2">Configure parâmetros gerais e preferências do sistema hidrológico</p>
            </div>
            <div class="flex items-center space-x-2">
                <div class="w-3 h-3 bg-green-500 rounded-full animate-pulse"></div>
                <span class="text-sm text-green-600">Sistema Operacional</span>
            </div>
        </div>
    </div>

    <!-- Estatísticas do Sistema -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-blue-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Usuários Total</p>
                    <p class="text-3xl font-bold text-blue-600">{{ $stats['usuarios_total'] }}</p>
                    <p class="text-xs text-gray-500">{{ $stats['usuarios_ativos'] }} ativos</p>
                </div>
                <div class="bg-blue-100 p-3 rounded-lg">
                    <i class="fas fa-users text-2xl text-blue-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-green-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Infraestruturas</p>
                    <p class="text-3xl font-bold text-green-600">{{ $stats['barragens_total'] + $stats['estacoes_total'] }}</p>
                    <p class="text-xs text-gray-500">{{ $stats['barragens_total'] }} barragens, {{ $stats['estacoes_total'] }} estações</p>
                </div>
                <div class="bg-green-100 p-3 rounded-lg">
                    <i class="fas fa-water text-2xl text-green-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-purple-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Leituras Hoje</p>
                    <p class="text-3xl font-bold text-purple-600">{{ $stats['leituras_hoje'] }}</p>
                    <p class="text-xs text-gray-500">Dados coletados</p>
                </div>
                <div class="bg-purple-100 p-3 rounded-lg">
                    <i class="fas fa-chart-line text-2xl text-purple-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-orange-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Uptime</p>
                    <p class="text-3xl font-bold text-orange-600">{{ $stats['uptime'] }}</p>
                    <p class="text-xs text-gray-500">Disponibilidade</p>
                </div>
                <div class="bg-orange-100 p-3 rounded-lg">
                    <i class="fas fa-clock text-2xl text-orange-600"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Configurações Gerais -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-medium text-gray-900 mb-6">
                <i class="fas fa-cog mr-2 text-gray-600"></i>
                Configurações Gerais
            </h3>

            @if ($errors->any())
                <div class="mb-4 bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded">
                    <ul class="list-disc list-inside">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @if (session('success'))
                <div class="mb-4 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded">
                    {{ session('success') }}
                </div>
            @endif

            <form method="POST" action="{{ route('configuracoes.sistema.update') }}" class="space-y-4">
                @csrf
                @method('PUT')

                <div>
                    <label for="app_name" class="block text-sm font-medium text-gray-700 mb-1">
                        Nome do Sistema *
                    </label>
                    <input type="text" 
                           id="app_name" 
                           name="app_name" 
                           value="{{ old('app_name', $config['nome_sistema']) }}" 
                           maxlength="100"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-gray-500 focus:border-gray-500"
                           required>
                    <p class="text-xs text-gray-500 mt-1">Nome que aparece no título e cabeçalho do sistema</p>
                </div>

                <div>
                    <label for="app_timezone" class="block text-sm font-medium text-gray-700 mb-1">
                        Fuso Horário *
                    </label>
                    <select id="app_timezone" 
                            name="app_timezone" 
                            class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-gray-500 focus:border-gray-500"
                            required>
                        <option value="Africa/Maputo" {{ old('app_timezone', $config['timezone']) == 'Africa/Maputo' ? 'selected' : '' }}>
                            África/Maputo (CAT +02:00)
                        </option>
                        <option value="UTC" {{ old('app_timezone', $config['timezone']) == 'UTC' ? 'selected' : '' }}>
                            UTC (GMT +00:00)
                        </option>
                        <option value="Europe/Lisbon" {{ old('app_timezone', $config['timezone']) == 'Europe/Lisbon' ? 'selected' : '' }}>
                            Europa/Lisboa (WET +00:00)
                        </option>
                        <option value="America/Sao_Paulo" {{ old('app_timezone', $config['timezone']) == 'America/Sao_Paulo' ? 'selected' : '' }}>
                            América/São Paulo (BRT -03:00)
                        </option>
                    </select>
                    <p class="text-xs text-gray-500 mt-1">Fuso horário usado para timestamps e relatórios</p>
                </div>

                <div>
                    <label for="app_locale" class="block text-sm font-medium text-gray-700 mb-1">
                        Idioma/Localização *
                    </label>
                    <select id="app_locale" 
                            name="app_locale" 
                            class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-gray-500 focus:border-gray-500"
                            required>
                        <option value="pt" {{ old('app_locale', $config['locale']) == 'pt' ? 'selected' : '' }}>
                            Português
                        </option>
                        <option value="en" {{ old('app_locale', $config['locale']) == 'en' ? 'selected' : '' }}>
                            English
                        </option>
                        <option value="pt_BR" {{ old('app_locale', $config['locale']) == 'pt_BR' ? 'selected' : '' }}>
                            Português (Brasil)
                        </option>
                    </select>
                    <p class="text-xs text-gray-500 mt-1">Idioma principal da interface</p>
                </div>

                <div class="flex items-center">
                    <input type="checkbox" 
                           id="app_debug" 
                           name="app_debug" 
                           value="1" 
                           {{ old('app_debug', $config['debug_mode']) ? 'checked' : '' }}
                           class="h-4 w-4 text-gray-600 focus:ring-gray-500 border-gray-300 rounded">
                    <label for="app_debug" class="ml-2 block text-sm text-gray-900">
                        <span class="font-medium">Modo Debug</span>
                        <span class="text-red-600 ml-1">(Apenas para desenvolvimento)</span>
                    </label>
                </div>
                <p class="text-xs text-gray-500 ml-6">Ativa logs detalhados e mensagens de erro. NUNCA ative em produção!</p>

                <div class="pt-4 border-t border-gray-200">
                    <button type="submit" class="w-full bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700 transition-colors flex items-center justify-center">
                        <i class="fas fa-save mr-2"></i>
                        Salvar Configurações
                    </button>
                </div>
            </form>
        </div>

        <!-- Status do Sistema -->
        <div class="space-y-6">
            <!-- Configurações Atuais -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">
                    <i class="fas fa-info-circle mr-2 text-blue-600"></i>
                    Configurações Atuais
                </h3>
                
                <div class="space-y-3">
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Nome:</span>
                        <span class="font-medium">{{ $config['nome_sistema'] }}</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Timezone:</span>
                        <span class="font-medium">{{ $config['timezone'] }}</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Idioma:</span>
                        <span class="font-medium">{{ $config['locale'] }}</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Debug:</span>
                        <span class="font-medium text-{{ $config['debug_mode'] ? 'yellow' : 'green' }}-600">
                            {{ $config['debug_mode'] ? 'Ativo' : 'Inativo' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Cache:</span>
                        <span class="font-medium">{{ $config['cache_driver'] }}</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Queue:</span>
                        <span class="font-medium">{{ $config['queue_driver'] }}</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Logs:</span>
                        <span class="font-medium">{{ $config['log_level'] }}</span>
                    </div>
                </div>
            </div>

            <!-- Manutenção do Sistema -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">
                    <i class="fas fa-tools mr-2 text-orange-600"></i>
                    Manutenção do Sistema
                </h3>

                @if (session('cache'))
                    <div class="mb-4 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded">
                        {{ session('cache') }}
                    </div>
                @endif

                @if ($errors->has('cache'))
                    <div class="mb-4 bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded">
                        {{ $errors->first('cache') }}
                    </div>
                @endif
                
                <div class="space-y-3">
                    <form method="POST" action="{{ route('configuracoes.sistema.clear-caches') }}">
                        @csrf
                        <button type="submit" class="w-full flex items-center justify-center p-3 border border-yellow-300 bg-yellow-50 text-yellow-700 rounded-lg hover:bg-yellow-100 transition-colors">
                            <i class="fas fa-broom mr-2"></i>
                            Limpar Todos os Caches
                        </button>
                    </form>
                    
                    <div class="text-xs text-gray-500">
                        <p><strong>Esta ação irá limpar:</strong></p>
                        <ul class="list-disc list-inside mt-1 space-y-1">
                            <li>Cache de configurações</li>
                            <li>Cache de rotas</li>
                            <li>Cache de views</li>
                            <li>Cache da aplicação</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Informações Técnicas -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-6">
            <i class="fas fa-microchip mr-2 text-purple-600"></i>
            Informações Técnicas do Sistema
        </h3>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div>
                <h4 class="text-sm font-semibold text-gray-900 mb-3">Configurações de Performance:</h4>
                <ul class="text-sm text-gray-600 space-y-2">
                    <li class="flex justify-between">
                        <span>Cache Driver:</span>
                        <span class="font-medium">{{ $config['cache_driver'] }}</span>
                    </li>
                    <li class="flex justify-between">
                        <span>Queue Driver:</span>
                        <span class="font-medium">{{ $config['queue_driver'] }}</span>
                    </li>
                    <li class="flex justify-between">
                        <span>Log Level:</span>
                        <span class="font-medium">{{ $config['log_level'] }}</span>
                    </li>
                </ul>
            </div>
            
            <div>
                <h4 class="text-sm font-semibold text-gray-900 mb-3">Recursos do Sistema:</h4>
                <ul class="text-sm text-gray-600 space-y-2">
                    <li class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        Notificações SMS/Twilio
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        Notificações Email/SMTP
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        Sistema de Alertas
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        Escalação Automática
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        Relatórios Automáticos
                    </li>
                </ul>
            </div>
            
            <div>
                <h4 class="text-sm font-semibold text-gray-900 mb-3">Segurança:</h4>
                <ul class="text-sm text-gray-600 space-y-2">
                    <li class="flex items-center">
                        <i class="fas fa-shield-alt text-green-500 mr-2"></i>
                        Autenticação Segura
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-lock text-green-500 mr-2"></i>
                        Criptografia HTTPS
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-eye text-blue-500 mr-2"></i>
                        Logs de Auditoria
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-user-shield text-purple-500 mr-2"></i>
                        Controle de Acesso
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Recomendações de Configuração -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-6">
            <i class="fas fa-lightbulb mr-2 text-yellow-600"></i>
            Recomendações de Configuração
        </h3>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="p-4 bg-green-50 border border-green-200 rounded-lg">
                <h4 class="font-semibold text-green-800 mb-2">
                    <i class="fas fa-check-circle mr-1"></i>
                    Ambiente de Produção
                </h4>
                <ul class="text-sm text-green-700 space-y-1">
                    <li>• Debug Mode: <strong>Desativado</strong></li>
                    <li>• Cache Driver: <strong>Redis ou Memcached</strong></li>
                    <li>• Queue Driver: <strong>Redis ou Database</strong></li>
                    <li>• Log Level: <strong>Error</strong></li>
                    <li>• Timezone: <strong>Africa/Maputo</strong></li>
                </ul>
            </div>
            
            <div class="p-4 bg-blue-50 border border-blue-200 rounded-lg">
                <h4 class="font-semibold text-blue-800 mb-2">
                    <i class="fas fa-code mr-1"></i>
                    Ambiente de Desenvolvimento
                </h4>
                <ul class="text-sm text-blue-700 space-y-1">
                    <li>• Debug Mode: <strong>Ativado</strong></li>
                    <li>• Cache Driver: <strong>File ou Array</strong></li>
                    <li>• Queue Driver: <strong>Sync</strong></li>
                    <li>• Log Level: <strong>Debug</strong></li>
                    <li>• Backup: <strong>Não necessário</strong></li>
                </ul>
            </div>
        </div>
        
        <div class="mt-4 p-4 bg-yellow-50 border border-yellow-200 rounded-md">
            <p class="text-sm text-yellow-800">
                <i class="fas fa-exclamation-triangle mr-2"></i>
                <strong>Importante:</strong> Sempre teste mudanças de configuração em ambiente de desenvolvimento antes de aplicar em produção. 
                Mantenha backups das configurações importantes.
            </p>
        </div>
    </div>

    <!-- Ações Rápidas -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-4">
            <i class="fas fa-bolt mr-2 text-yellow-600"></i>
            Ações Rápidas
        </h3>
        
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <a href="{{ route('configuracoes.info') }}" class="flex items-center justify-center p-4 border border-blue-300 bg-blue-50 text-blue-700 rounded-lg hover:bg-blue-100 transition-colors">
                <i class="fas fa-info-circle mr-2"></i>
                Informações Sistema
            </a>
            
            <a href="{{ route('notifications.dashboard') }}" class="flex items-center justify-center p-4 border border-purple-300 bg-purple-50 text-purple-700 rounded-lg hover:bg-purple-100 transition-colors">
                <i class="fas fa-chart-bar mr-2"></i>
                Dashboard
            </a>
            
            <a href="{{ route('alertas.index') }}" class="flex items-center justify-center p-4 border border-red-300 bg-red-50 text-red-700 rounded-lg hover:bg-red-100 transition-colors">
                <i class="fas fa-exclamation-triangle mr-2"></i>
                Alertas Ativos
            </a>
            
            <a href="{{ route('configuracoes.index') }}" class="flex items-center justify-center p-4 border border-gray-300 bg-gray-50 text-gray-700 rounded-lg hover:bg-gray-100 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Voltar às Configurações
            </a>
        </div>
    </div>
</div>
@endsection