@extends('layouts.app')

@section('title', 'Dashboard - Sistema Hidrológico')

@section('content')
<div class="space-y-6">
    <!-- Header com Ano Hidrológico -->
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200 bg-gradient-to-r from-blue-50 to-indigo-50">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">
                        <i class="fas fa-chart-line mr-3 text-blue-600"></i>
                        Dashboard - Sistema Hidrológico
                    </h1>
                    <p class="text-gray-600 mt-1">Monitoramento integrado de recursos hídricos</p>
                </div>
                <div class="text-right">
                    <div class="text-sm text-gray-600 mb-1">Última atualização</div>
                    <div class="text-sm font-mono text-gray-800">{{ now()->format('d/m/Y H:i') }}</div>
                </div>
            </div>
        </div>

        <!-- Informações do Ano Hidrológico -->
        <div class="px-6 py-4">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Ano Hidrológico Atual -->
                <div class="bg-gradient-to-r from-blue-100 to-cyan-100 rounded-lg p-4 border border-blue-200">
                    <div class="flex items-center mb-2">
                        <i class="fas fa-calendar-alt text-blue-600 mr-2"></i>
                        <h3 class="font-bold text-blue-900">Ano Hidrológico</h3>
                    </div>
                    <div class="text-2xl font-bold text-blue-800 mb-1">
                        {{ $stats['ano_hidrologico']['label'] }}
                    </div>
                    <div class="text-sm text-blue-700">
                        {{ $stats['ano_hidrologico']['start']->format('d M Y') }} - {{ $stats['ano_hidrologico']['end']->format('d M Y') }}
                    </div>
                    <div class="mt-3">
                        <div class="w-full bg-blue-200 rounded-full h-2">
                            <div class="bg-blue-600 h-2 rounded-full transition-all duration-500"
                                 style="width: {{ $stats['progresso_ano'] }}%"></div>
                        </div>
                        <div class="text-xs text-blue-700 mt-1">{{ $stats['progresso_ano'] }}% completo</div>
                    </div>
                </div>

                <!-- Estação Atual -->
                <div class="bg-gradient-to-r from-{{ $stats['estacao_atual']['color'] }}-100 to-{{ $stats['estacao_atual']['color'] }}-200 rounded-lg p-4 border border-{{ $stats['estacao_atual']['color'] }}-200">
                    <div class="flex items-center mb-2">
                        @if($stats['estacao_atual']['season'] == 'chuvosa')
                            <i class="fas fa-cloud-rain text-{{ $stats['estacao_atual']['color'] }}-600 mr-2"></i>
                        @else
                            <i class="fas fa-sun text-{{ $stats['estacao_atual']['color'] }}-600 mr-2"></i>
                        @endif
                        <h3 class="font-bold text-{{ $stats['estacao_atual']['color'] }}-900">{{ $stats['estacao_atual']['label'] }}</h3>
                    </div>
                    <div class="text-lg font-bold text-{{ $stats['estacao_atual']['color'] }}-800 mb-1">
                        {{ $stats['estacao_atual']['months'] }}
                    </div>
                    <div class="text-sm text-{{ $stats['estacao_atual']['color'] }}-700">
                        Período atual do ano hidrológico
                    </div>
                </div>

                <!-- Leituras do Ano Hidrológico -->
                <div class="bg-gradient-to-r from-green-100 to-emerald-100 rounded-lg p-4 border border-green-200">
                    <div class="flex items-center mb-2">
                        <i class="fas fa-chart-bar text-green-600 mr-2"></i>
                        <h3 class="font-bold text-green-900">Leituras do Ano</h3>
                    </div>
                    <div class="text-2xl font-bold text-green-800 mb-1">
                        {{ number_format($stats['leituras_ano_hidrologico']) }}
                    </div>
                    <div class="text-sm text-green-700">
                        Total de registros coletados
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <div class="bg-white rounded-lg shadow p-6 hover:shadow-lg transition-shadow border-l-4 border-blue-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Barragens Ativas</p>
                    <p class="text-3xl font-bold text-blue-600">{{ $stats['total_barragens'] ?? 0 }}</p>
                </div>
                <div class="bg-blue-100 p-3 rounded-lg">
                    <i class="fas fa-water text-2xl text-blue-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 hover:shadow-lg transition-shadow border-l-4 border-green-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Estações Ativas</p>
                    <p class="text-3xl font-bold text-green-600">{{ $stats['total_estacoes'] ?? 0 }}</p>
                </div>
                <div class="bg-green-100 p-3 rounded-lg">
                    <i class="fas fa-broadcast-tower text-2xl text-green-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 hover:shadow-lg transition-shadow border-l-4 border-red-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Alertas Ativos</p>
                    <p class="text-3xl font-bold text-red-600">{{ $stats['alertas_ativos'] ?? 0 }}</p>
                    @if($stats['alertas_ativos'] > 0)
                        <p class="text-xs text-red-500 mt-1 animate-pulse">
                            <i class="fas fa-circle mr-1"></i>
                            Requer atenção
                        </p>
                    @else
                        <p class="text-xs text-green-600 mt-1">
                            <i class="fas fa-check-circle mr-1"></i>
                            Sistema normal
                        </p>
                    @endif
                </div>
                <div class="bg-red-100 p-3 rounded-lg {{ $stats['alertas_ativos'] > 0 ? 'animate-pulse' : '' }}">
                    <i class="fas fa-triangle-exclamation text-2xl text-red-600"></i>
                </div>
            </div>
            <div class="mt-4">
                <a href="{{ route('alertas.index') }}" class="text-sm text-red-600 hover:text-red-800 font-medium">
                    <i class="fas fa-arrow-right mr-1"></i>
                    Ver todos os alertas
                </a>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 hover:shadow-lg transition-shadow border-l-4 border-purple-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Leituras Hoje</p>
                    <p class="text-3xl font-bold text-purple-600">{{ $stats['leituras_hoje'] ?? 0 }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Dashboard de Alertas em Tempo Real -->
    @if(isset($stats['alertas_ativos']) && $stats['alertas_ativos'] > 0)
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200 bg-red-50">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-lg font-medium text-gray-900">
                        <i class="fas fa-exclamation-triangle mr-2 text-red-600"></i>
                        Alertas Ativos - Requer Atenção Imediata
                    </h3>
                    <p class="text-sm text-red-600 mt-1">{{ $stats['alertas_ativos'] }} alerta(s) ativo(s) no sistema</p>
                </div>
                <div class="flex items-center space-x-2">
                    <div class="w-3 h-3 bg-red-500 rounded-full animate-pulse"></div>
                    <span class="text-sm text-red-600 font-medium">Sistema em alerta</span>
                </div>
            </div>
        </div>

        <div class="p-6">
            @if(isset($alertas_ativos) && $alertas_ativos->count() > 0)
                <div class="space-y-4">
                    @foreach($alertas_ativos as $alerta)
                        <div class="border-l-4 border-{{ $alerta->getCorNivel() }}-500 bg-{{ $alerta->getCorNivel() }}-50 p-4 rounded-r-lg hover:shadow-md transition-shadow">
                            <div class="flex items-start justify-between">
                                <div class="flex-1">
                                    <div class="flex items-center space-x-2 mb-2">
                                        <!-- Badge de Nível -->
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-{{ $alerta->getCorNivel() }}-100 text-{{ $alerta->getCorNivel() }}-800 border border-{{ $alerta->getCorNivel() }}-200">
                                            @if($alerta->nivel == 'emergencia')
                                                <i class="fas fa-skull-crossbones mr-1"></i>
                                            @elseif($alerta->nivel == 'alerta')
                                                <i class="fas fa-exclamation-triangle mr-1"></i>
                                            @elseif($alerta->nivel == 'atencao')
                                                <i class="fas fa-exclamation-circle mr-1"></i>
                                            @else
                                                <i class="fas fa-info-circle mr-1"></i>
                                            @endif
                                            {{ $alerta->getNivelFormatado() }}
                                        </span>

                                        <!-- Badge de Tipo -->
                                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-gray-100 text-gray-700">
                                            {{ $alerta->getTipoFormatado() }}
                                        </span>

                                        <!-- Timestamp -->
                                        <span class="text-xs text-gray-500">
                                            <i class="fas fa-clock mr-1"></i>
                                            {{ $alerta->created_at->diffForHumans() }}
                                        </span>
                                    </div>

                                    <h4 class="font-semibold text-gray-900 mb-1">{{ $alerta->titulo }}</h4>
                                    <p class="text-sm text-gray-700 mb-2">{{ $alerta->descricao }}</p>

                                    <div class="flex items-center text-sm text-gray-600">
                                        <i class="fas fa-{{ $alerta->barragem ? 'dam' : 'satellite-dish' }} mr-1 text-blue-500"></i>
                                        <span>{{ $alerta->getNomeInfrastrutura() }}</span>
                                        @if($alerta->valor_registado)
                                            <span class="mx-2">•</span>
                                            <span class="font-medium">Valor: {{ $alerta->valor_registado }}</span>
                                        @endif
                                        @if($alerta->valor_limite)
                                            <span class="mx-2">•</span>
                                            <span class="text-red-600">Limite: {{ $alerta->valor_limite }}</span>
                                        @endif
                                    </div>
                                </div>

                                <div class="ml-4 flex space-x-2">
                                    <a href="{{ route('alertas.show', $alerta) }}"
                                       class="inline-flex items-center px-3 py-1 border border-gray-300 text-xs leading-4 font-medium rounded text-gray-700 bg-white hover:bg-gray-50 transition-colors">
                                        <i class="fas fa-eye mr-1"></i>
                                        Ver
                                    </a>
                                    <button onclick="quickResolve({{ $alerta->id }})"
                                            class="inline-flex items-center px-3 py-1 border border-transparent text-xs leading-4 font-medium rounded text-white bg-green-600 hover:bg-green-700 transition-colors">
                                        <i class="fas fa-check mr-1"></i>
                                        Resolver
                                    </button>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <div class="mt-6 text-center">
                    <a href="{{ route('alertas.index') }}"
                       class="inline-flex items-center px-4 py-2 border border-red-300 rounded-md shadow-sm text-sm font-medium text-red-700 bg-white hover:bg-red-50 transition-colors">
                        <i class="fas fa-list mr-2"></i>
                        Ver Todos os Alertas ({{ $stats['alertas_ativos'] }})
                    </a>
                </div>
            @else
                <div class="text-center py-8">
                    <i class="fas fa-shield-alt text-4xl text-green-300 mb-4"></i>
                    <h3 class="text-lg font-medium text-gray-900 mb-2">Sistema Funcionando Normalmente</h3>
                    <p class="text-gray-500">Não há alertas ativos no momento.</p>
                </div>
            @endif
        </div>
    </div>
    @endif

    <!-- Barragens Principais -->
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">
                <i class="fas fa-dam mr-2 text-blue-600"></i>
                Barragens Principais
            </h3>
        </div>
        <div class="p-6">
            @if(isset($barragens_principais) && $barragens_principais->count() > 0)
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    @foreach($barragens_principais as $barragem)
                        <div class="border rounded-lg p-4 hover:shadow-md transition-shadow">
                            <div class="flex items-center justify-between mb-2">
                                <h4 class="font-medium text-gray-900">{{ $barragem['nome'] }}</h4>
                                <span class="text-xs text-gray-500">{{ $barragem['codigo'] }}</span>
                            </div>
                            @if($barragem['cota_atual'])
                                <div class="space-y-2">
                                    <div class="flex justify-between text-sm">
                                        <span class="text-gray-600">Cota Atual:</span>
                                        <span class="font-medium">{{ $barragem['cota_atual'] }}m</span>
                                    </div>
                                    <div class="flex justify-between text-sm">
                                        <span class="text-gray-600">Enchimento:</span>
                                        <span class="font-medium">{{ $barragem['percentagem_enchimento'] }}%</span>
                                    </div>
                                    <div class="w-full bg-gray-200 rounded-full h-2">
                                        <div class="bg-blue-600 h-2 rounded-full" style="width: {{ $barragem['percentagem_enchimento'] }}%"></div>
                                    </div>
                                </div>
                            @else
                                <p class="text-sm text-gray-500">Sem dados recentes</p>
                            @endif
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-8">
                    <i class="fas fa-dam text-4xl text-gray-300 mb-4"></i>
                    <p class="text-gray-500">Nenhuma barragem encontrada</p>
                    <a href="{{ route('barragens.create') }}" class="text-blue-600 hover:text-blue-800 mt-2 inline-block">
                        Adicionar primeira barragem
                    </a>
                </div>
            @endif
        </div>
    </div>


    <!-- Quick Actions -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-4">
            <i class="fas fa-bolt mr-2 text-yellow-600"></i>
            Ações Rápidas
        </h3>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4">
            <a href="{{ route('alertas.index') }}" class="flex items-center p-4 border rounded-lg hover:bg-gray-50 transition-colors {{ $stats['alertas_ativos'] > 0 ? 'border-red-300 bg-red-50' : '' }}">
                <i class="fas fa-exclamation-triangle text-red-600 mr-3 {{ $stats['alertas_ativos'] > 0 ? 'animate-pulse' : '' }}"></i>
                <div>
                    <span class="text-sm font-medium">Alertas</span>
                    @if($stats['alertas_ativos'] > 0)
                        <div class="text-xs text-red-600">{{ $stats['alertas_ativos'] }} ativos</div>
                    @else
                        <div class="text-xs text-green-600">Sistema normal</div>
                    @endif
                </div>
            </a>
            <a href="{{ route('barragens.create') }}" class="flex items-center p-4 border rounded-lg hover:bg-gray-50 transition-colors">
                <i class="fas fa-plus text-blue-600 mr-3"></i>
                <span class="text-sm font-medium">Nova Barragem</span>
            </a>
            <a href="{{ route('estacoes.create') }}" class="flex items-center p-4 border rounded-lg hover:bg-gray-50 transition-colors">
                <i class="fas fa-satellite-dish text-green-600 mr-3"></i>
                <span class="text-sm font-medium">Nova Estação</span>
            </a>
            <a href="{{ route('importacao.index') }}" class="flex items-center p-4 border rounded-lg hover:bg-gray-50 transition-colors">
                <i class="fas fa-upload text-purple-600 mr-3"></i>
                <span class="text-sm font-medium">Importar Dados</span>
            </a>
            <a href="{{ route('boletins.create') }}" class="flex items-center p-4 border rounded-lg hover:bg-gray-50 transition-colors">
                <i class="fas fa-file-alt text-orange-600 mr-3"></i>
                <span class="text-sm font-medium">Novo Boletim</span>
            </a>
            <a href="{{ route('dashboard') }}" class="flex items-center p-4 border rounded-lg hover:bg-blue-50 transition-colors border-blue-300">
                <i class="fas fa-map text-blue-600 mr-3"></i>
                <span class="text-sm font-medium">Dashboard Mapa GIS</span>
            </a>
        </div>
    </div>
</div>

<script>
// Quick resolve functionality
function quickResolve(alertaId) {
    const action = prompt('Descreva brevemente as ações tomadas para resolver este alerta:');
    if (action && action.trim() !== '') {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/alertas/${alertaId}/resolve`;
        form.style.display = 'none';

        // CSRF token
        const csrfInput = document.createElement('input');
        csrfInput.type = 'hidden';
        csrfInput.name = '_token';
        csrfInput.value = document.querySelector('meta[name="csrf-token"]').content;
        form.appendChild(csrfInput);

        // Action input
        const actionInput = document.createElement('input');
        actionInput.type = 'hidden';
        actionInput.name = 'acoes_tomadas';
        actionInput.value = action;
        form.appendChild(actionInput);

        document.body.appendChild(form);
        form.submit();
    }
}

// Auto-refresh dashboard every 60 seconds to show real-time data
setInterval(function() {
    // Only refresh if there are active alerts or if user isn't actively interacting
    const hasActiveAlerts = {{ $stats['alertas_ativos'] ?? 0 }} > 0;
    const lastActivity = Date.now() - (window.lastUserActivity || 0);

    if (hasActiveAlerts && lastActivity > 30000) {
        location.reload();
    }
}, 60000);

// Track user activity to avoid unwanted refreshes
window.lastUserActivity = Date.now();
document.addEventListener('mousemove', function() {
    window.lastUserActivity = Date.now();
});
document.addEventListener('keypress', function() {
    window.lastUserActivity = Date.now();
});

// Live update of alert counts via AJAX (lighter than full page refresh)
function updateAlertCounts() {
    fetch('/alertas/ativos/json')
        .then(response => response.json())
        .then(data => {
            // Update alert counts in statistics cards
            const alertsCard = document.querySelector('[data-alert-count]');
            if (alertsCard) {
                alertsCard.textContent = data.length;

                // Update visual state based on active alerts
                const parentCard = alertsCard.closest('.bg-white');
                if (data.length > 0) {
                    parentCard.classList.add('animate-pulse');
                } else {
                    parentCard.classList.remove('animate-pulse');
                }
            }

            // Update quick actions alerts indicator
            const quickActionAlerts = document.querySelector('[data-quick-alerts]');
            if (quickActionAlerts) {
                if (data.length > 0) {
                    quickActionAlerts.innerHTML = `${data.length} ativos`;
                    quickActionAlerts.classList.add('text-red-600');
                    quickActionAlerts.classList.remove('text-green-600');
                } else {
                    quickActionAlerts.innerHTML = 'Sistema normal';
                    quickActionAlerts.classList.add('text-green-600');
                    quickActionAlerts.classList.remove('text-red-600');
                }
            }
        })
        .catch(error => {
            console.log('Erro ao atualizar contagem de alertas:', error);
        });
}

// Update alert counts every 30 seconds
setInterval(updateAlertCounts, 30000);

// Show notification for critical alerts
@if(isset($alertas_ativos) && $alertas_ativos->where('nivel', 'emergencia')->count() > 0)
if (Notification.permission === 'granted') {
    new Notification('🚨 Alerta de Emergência', {
        body: 'Há {{ $alertas_ativos->where("nivel", "emergencia")->count() }} alerta(s) de emergência ativo(s) no sistema.',
        icon: '/favicon.ico',
        tag: 'emergency-alert'
    });
} else if (Notification.permission !== 'denied') {
    Notification.requestPermission().then(function (permission) {
        if (permission === 'granted') {
            new Notification('🚨 Alerta de Emergência', {
                body: 'Há {{ $alertas_ativos->where("nivel", "emergencia")->count() }} alerta(s) de emergência ativo(s) no sistema.',
                icon: '/favicon.ico',
                tag: 'emergency-alert'
            });
        }
    });
}
@endif
</script>
@endsection