@extends('layouts.app')

@section('title', 'Leituras Grid - ' . $estacao->nome)

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-3 border-b border-gray-200 bg-gray-50">
            <nav class="flex" aria-label="Breadcrumb">
                <ol class="inline-flex items-center space-x-2 md:space-x-4">
                    <li class="inline-flex items-center">
                        <a href="{{ route('dashboard') }}" class="text-gray-500 hover:text-gray-700">
                            <i class="fas fa-home mr-2"></i>Dashboard
                        </a>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <a href="{{ route('estacoes.index') }}" class="text-gray-500 hover:text-gray-700">Estacoes</a>
                        </div>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <a href="{{ route('estacoes.show', $estacao) }}" class="text-gray-500 hover:text-gray-700">{{ $estacao->nome }}</a>
                        </div>
                    </li>
                    <li aria-current="page">
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <span class="text-gray-800 font-medium">Leituras Grid</span>
                        </div>
                    </li>
                </ol>
            </nav>
        </div>

        <div class="px-6 py-6">
            <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                <div class="flex-1">
                    <div class="flex items-center mb-2">
                        <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center mr-4">
                            <i class="fas fa-th text-white text-xl"></i>
                        </div>
                        <div>
                            <h1 class="text-2xl font-bold text-gray-900">Modo Grid - Leituras</h1>
                            <p class="text-gray-600">{{ $estacao->nome }} ({{ $estacao->codigo }})</p>
                        </div>
                    </div>

                    <div class="flex flex-wrap items-center gap-4 mt-3">
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                            <i class="fas fa-calendar mr-2"></i>
                            {{ \Carbon\Carbon::parse($mesParam . '-01')->locale('pt')->isoFormat('MMMM YYYY') }}
                        </span>
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800">
                            <i class="fas fa-satellite-dish mr-2"></i>
                            {{ ucfirst($estacao->tipo) }}
                        </span>
                    </div>
                </div>

                <div class="mt-6 lg:mt-0 lg:ml-6">
                    <div class="flex flex-col sm:flex-row gap-3">
                        <a href="{{ route('estacoes.leituras', $estacao) }}"
                           class="inline-flex items-center justify-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg transition-colors">
                            <i class="fas fa-list mr-2"></i>
                            Modo Lista
                        </a>
                        <a href="{{ route('estacoes.show', $estacao) }}"
                           class="inline-flex items-center justify-center px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white rounded-lg transition-colors">
                            <i class="fas fa-arrow-left mr-2"></i>
                            Voltar
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Navegacao de Mes -->
    <div class="bg-white rounded-lg shadow p-4">
        <div class="flex items-center justify-between">
            @php
                $mesAnterior = \Carbon\Carbon::parse($mesParam . '-01')->subMonth()->format('Y-m');
                $mesProximo = \Carbon\Carbon::parse($mesParam . '-01')->addMonth()->format('Y-m');
            @endphp
            <a href="{{ route('estacoes.leituras.grid', [$estacao, 'mes' => $mesAnterior]) }}"
               class="px-4 py-2 bg-gray-200 hover:bg-gray-300 rounded-lg transition-colors">
                <i class="fas fa-chevron-left mr-2"></i>Mes Anterior
            </a>

            <form method="GET" class="flex items-center gap-2">
                <input type="month" name="mes" value="{{ $mesParam }}"
                       class="border-gray-300 rounded-md shadow-sm focus:ring-purple-500 focus:border-purple-500">
                <button type="submit" class="px-4 py-2 bg-purple-600 hover:bg-purple-700 text-white rounded-lg">
                    <i class="fas fa-search"></i>
                </button>
            </form>

            <a href="{{ route('estacoes.leituras.grid', [$estacao, 'mes' => $mesProximo]) }}"
               class="px-4 py-2 bg-gray-200 hover:bg-gray-300 rounded-lg transition-colors">
                Proximo Mes<i class="fas fa-chevron-right ml-2"></i>
            </a>
        </div>
    </div>

    <!-- Tabela Grid -->
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 bg-gray-50 flex justify-between items-center">
            <h3 class="text-lg font-medium text-gray-900">
                <i class="fas fa-table mr-2 text-purple-600"></i>
                Leituras do Mes
            </h3>
            <button onclick="salvarTodasLeituras()" id="btnSalvar"
                    class="px-6 py-2 bg-green-600 hover:bg-green-700 text-white rounded-lg font-semibold transition-colors">
                <i class="fas fa-save mr-2"></i>Salvar Alteracoes
            </button>
        </div>

        <div class="overflow-x-auto">
            <table class="w-full text-sm" id="gridTable">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="px-3 py-3 text-left font-semibold text-gray-700 border-b-2 border-gray-300 sticky left-0 bg-gray-100 z-10" style="min-width: 100px;">
                            Dia
                        </th>
                        @if($estacao->tipo == 'hidrometrica')
                            <th class="px-2 py-3 text-center font-semibold text-orange-700 border-b-2 border-gray-300 bg-orange-50" style="min-width: 80px;">
                                6h
                            </th>
                            <th class="px-2 py-3 text-center font-semibold text-yellow-700 border-b-2 border-gray-300 bg-yellow-50" style="min-width: 80px;">
                                9h
                            </th>
                            <th class="px-2 py-3 text-center font-semibold text-amber-700 border-b-2 border-gray-300 bg-amber-50" style="min-width: 80px;">
                                12h
                            </th>
                            <th class="px-2 py-3 text-center font-semibold text-red-700 border-b-2 border-gray-300 bg-red-50" style="min-width: 80px;">
                                15h
                            </th>
                            <th class="px-2 py-3 text-center font-semibold text-purple-700 border-b-2 border-gray-300 bg-purple-50" style="min-width: 80px;">
                                18h
                            </th>
                            <th class="px-2 py-3 text-center font-semibold text-blue-700 border-b-2 border-gray-300 bg-blue-50" style="min-width: 80px;">
                                Media
                            </th>
                            <th class="px-2 py-3 text-center font-semibold text-green-700 border-b-2 border-gray-300 bg-green-50" style="min-width: 80px;">
                                Max
                            </th>
                            <th class="px-2 py-3 text-center font-semibold text-cyan-700 border-b-2 border-gray-300 bg-cyan-50" style="min-width: 80px;">
                                Min
                            </th>
                        @endif
                        @if(in_array($estacao->tipo, ['pluviometrica', 'meteorologica', 'climatologica']))
                            <th class="px-2 py-3 text-center font-semibold text-blue-700 border-b-2 border-gray-300 bg-blue-50" style="min-width: 100px;">
                                Precip. (mm)
                            </th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @foreach($diasDoMes as $dia)
                        @php
                            $dataStr = $dia->format('Y-m-d');
                            $leitura = $leituras->get($dataStr);
                            $diaSemana = $dia->locale('pt')->isoFormat('ddd');
                            $isFimDeSemana = $dia->isWeekend();
                            $isHoje = $dia->isToday();
                        @endphp
                        <tr class="border-b hover:bg-gray-50 {{ $isFimDeSemana ? 'bg-gray-50' : '' }} {{ $isHoje ? 'bg-yellow-100 ring-2 ring-yellow-400 ring-inset' : '' }}"
                            data-date="{{ $dataStr }}" {{ $isHoje ? 'id=linha-hoje' : '' }}>
                            <!-- Data -->
                            <td class="px-3 py-2 font-medium sticky left-0 {{ $isFimDeSemana ? 'bg-gray-50' : 'bg-white' }} {{ $isHoje ? 'bg-yellow-100' : '' }} z-10 border-r">
                                <div class="flex items-center">
                                    <span class="text-gray-900 {{ $isHoje ? 'font-bold' : '' }}">{{ $dia->format('d') }}</span>
                                    <span class="ml-2 text-xs text-gray-500">{{ $diaSemana }}</span>
                                    @if($isHoje)
                                        <span class="ml-2 px-2 py-0.5 text-xs bg-yellow-400 text-yellow-900 rounded-full font-bold animate-pulse">HOJE</span>
                                    @endif
                                </div>
                                <input type="hidden" name="leituras[{{ $loop->index }}][data_leitura]" value="{{ $dataStr }}">
                            </td>

                            @if($estacao->tipo == 'hidrometrica')
                                <!-- Nivel 6h -->
                                <td class="px-1 py-1 bg-orange-50">
                                    <input type="number" step="0.001"
                                           name="leituras[{{ $loop->index }}][nivel_6h]"
                                           value="{{ $leitura?->nivel_6h }}"
                                           placeholder="--"
                                           class="w-full px-2 py-1 text-center text-sm border border-gray-300 rounded focus:ring-1 focus:ring-orange-500 focus:border-orange-500"
                                           onchange="calcularEstatisticas(this)">
                                </td>
                                <!-- Nivel 9h -->
                                <td class="px-1 py-1 bg-yellow-50">
                                    <input type="number" step="0.001"
                                           name="leituras[{{ $loop->index }}][nivel_9h]"
                                           value="{{ $leitura?->nivel_9h }}"
                                           placeholder="--"
                                           class="w-full px-2 py-1 text-center text-sm border border-gray-300 rounded focus:ring-1 focus:ring-yellow-500 focus:border-yellow-500"
                                           onchange="calcularEstatisticas(this)">
                                </td>
                                <!-- Nivel 12h -->
                                <td class="px-1 py-1 bg-amber-50">
                                    <input type="number" step="0.001"
                                           name="leituras[{{ $loop->index }}][nivel_12h]"
                                           value="{{ $leitura?->nivel_12h }}"
                                           placeholder="--"
                                           class="w-full px-2 py-1 text-center text-sm border border-gray-300 rounded focus:ring-1 focus:ring-amber-500 focus:border-amber-500"
                                           onchange="calcularEstatisticas(this)">
                                </td>
                                <!-- Nivel 15h -->
                                <td class="px-1 py-1 bg-red-50">
                                    <input type="number" step="0.001"
                                           name="leituras[{{ $loop->index }}][nivel_15h]"
                                           value="{{ $leitura?->nivel_15h }}"
                                           placeholder="--"
                                           class="w-full px-2 py-1 text-center text-sm border border-gray-300 rounded focus:ring-1 focus:ring-red-500 focus:border-red-500"
                                           onchange="calcularEstatisticas(this)">
                                </td>
                                <!-- Nivel 18h -->
                                <td class="px-1 py-1 bg-purple-50">
                                    <input type="number" step="0.001"
                                           name="leituras[{{ $loop->index }}][nivel_18h]"
                                           value="{{ $leitura?->nivel_18h }}"
                                           placeholder="--"
                                           class="w-full px-2 py-1 text-center text-sm border border-gray-300 rounded focus:ring-1 focus:ring-purple-500 focus:border-purple-500"
                                           onchange="calcularEstatisticas(this)">
                                </td>
                                <!-- Media (calculado) -->
                                <td class="px-1 py-1 bg-blue-50">
                                    <input type="text" readonly
                                           class="w-full px-2 py-1 text-center text-sm bg-blue-100 border-0 rounded font-semibold text-blue-700 nivel-media"
                                           value="{{ $leitura ? number_format(($leitura->nivel_6h + $leitura->nivel_9h + $leitura->nivel_12h + $leitura->nivel_15h + $leitura->nivel_18h) / 5, 3) : '--' }}">
                                </td>
                                <!-- Max (calculado) -->
                                <td class="px-1 py-1 bg-green-50">
                                    <input type="text" readonly
                                           class="w-full px-2 py-1 text-center text-sm bg-green-100 border-0 rounded font-semibold text-green-700 nivel-max"
                                           value="{{ $leitura ? number_format(max($leitura->nivel_6h ?? 0, $leitura->nivel_9h ?? 0, $leitura->nivel_12h ?? 0, $leitura->nivel_15h ?? 0, $leitura->nivel_18h ?? 0), 3) : '--' }}">
                                </td>
                                <!-- Min (calculado) -->
                                <td class="px-1 py-1 bg-cyan-50">
                                    @php
                                        $niveis = array_filter([$leitura?->nivel_6h, $leitura?->nivel_9h, $leitura?->nivel_12h, $leitura?->nivel_15h, $leitura?->nivel_18h]);
                                        $minNivel = count($niveis) > 0 ? min($niveis) : null;
                                    @endphp
                                    <input type="text" readonly
                                           class="w-full px-2 py-1 text-center text-sm bg-cyan-100 border-0 rounded font-semibold text-cyan-700 nivel-min"
                                           value="{{ $minNivel !== null ? number_format($minNivel, 3) : '--' }}">
                                </td>
                            @endif

                            @if(in_array($estacao->tipo, ['pluviometrica', 'meteorologica', 'climatologica']))
                                <!-- Precipitacao -->
                                <td class="px-1 py-1 bg-blue-50">
                                    <input type="number" step="0.1"
                                           name="leituras[{{ $loop->index }}][precipitacao_mm]"
                                           value="{{ $leitura?->precipitacao_mm }}"
                                           placeholder="0.0"
                                           class="w-full px-2 py-1 text-center text-sm border border-gray-300 rounded focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                </td>
                            @endif
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
function calcularEstatisticas(input) {
    const row = input.closest('tr');
    const nivel6h = parseFloat(row.querySelector('input[name*="nivel_6h"]')?.value) || 0;
    const nivel9h = parseFloat(row.querySelector('input[name*="nivel_9h"]')?.value) || 0;
    const nivel12h = parseFloat(row.querySelector('input[name*="nivel_12h"]')?.value) || 0;
    const nivel15h = parseFloat(row.querySelector('input[name*="nivel_15h"]')?.value) || 0;
    const nivel18h = parseFloat(row.querySelector('input[name*="nivel_18h"]')?.value) || 0;

    const niveis = [nivel6h, nivel9h, nivel12h, nivel15h, nivel18h].filter(n => n > 0);

    if (niveis.length > 0) {
        const media = niveis.reduce((a, b) => a + b, 0) / niveis.length;
        const max = Math.max(...niveis);
        const min = Math.min(...niveis);

        row.querySelector('.nivel-media').value = media.toFixed(3);
        row.querySelector('.nivel-max').value = max.toFixed(3);
        row.querySelector('.nivel-min').value = min.toFixed(3);
    } else {
        row.querySelector('.nivel-media').value = '--';
        row.querySelector('.nivel-max').value = '--';
        row.querySelector('.nivel-min').value = '--';
    }
}

function salvarTodasLeituras() {
    const btn = document.getElementById('btnSalvar');
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Salvando...';

    const rows = document.querySelectorAll('#gridTable tbody tr');
    const leituras = [];

    rows.forEach((row, index) => {
        const data = row.querySelector('input[name*="data_leitura"]')?.value;
        if (!data) return;

        const leitura = {
            data_leitura: data,
            nivel_6h: row.querySelector('input[name*="nivel_6h"]')?.value || null,
            nivel_9h: row.querySelector('input[name*="nivel_9h"]')?.value || null,
            nivel_12h: row.querySelector('input[name*="nivel_12h"]')?.value || null,
            nivel_15h: row.querySelector('input[name*="nivel_15h"]')?.value || null,
            nivel_18h: row.querySelector('input[name*="nivel_18h"]')?.value || null,
            precipitacao_mm: row.querySelector('input[name*="precipitacao_mm"]')?.value || null,
        };

        // Verificar se tem dados
        if (leitura.nivel_6h || leitura.nivel_9h || leitura.nivel_12h || leitura.nivel_15h || leitura.nivel_18h || leitura.precipitacao_mm) {
            leituras.push(leitura);
        }
    });

    fetch('{{ route("estacoes.storeLeiturasBulk", $estacao) }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({ leituras: leituras })
    })
    .then(response => response.json())
    .then(data => {
        btn.disabled = false;
        btn.innerHTML = '<i class="fas fa-save mr-2"></i>Salvar Alteracoes';

        if (data.success) {
            alert(data.message);
        } else {
            alert('Erro ao salvar: ' + (data.message || 'Erro desconhecido'));
        }
    })
    .catch(error => {
        btn.disabled = false;
        btn.innerHTML = '<i class="fas fa-save mr-2"></i>Salvar Alteracoes';
        alert('Erro de conexao: ' + error.message);
    });
}

// Auto-scroll e auto-focus na linha de hoje
document.addEventListener('DOMContentLoaded', function() {
    const linhaHoje = document.getElementById('linha-hoje');
    if (linhaHoje) {
        // Scroll para a linha de hoje com margem superior
        setTimeout(() => {
            linhaHoje.scrollIntoView({ behavior: 'smooth', block: 'center' });
        }, 100);

        // Auto-focus no primeiro input vazio da linha de hoje
        setTimeout(() => {
            const inputs = linhaHoje.querySelectorAll('input[type="number"]:not([readonly])');
            for (let input of inputs) {
                if (!input.value || input.value === '') {
                    input.focus();
                    input.select();
                    break;
                }
            }
            // Se todos têm valor, focar no primeiro
            if (inputs.length > 0 && !document.activeElement.closest('#linha-hoje')) {
                inputs[0].focus();
                inputs[0].select();
            }
        }, 200);
    }
});

// Navegacao com teclado
document.querySelectorAll('#gridTable input[type="number"]').forEach(input => {
    input.addEventListener('keydown', function(e) {
        const cell = this.closest('td');
        const row = this.closest('tr');
        const cellIndex = Array.from(row.cells).indexOf(cell);
        const rows = Array.from(document.querySelectorAll('#gridTable tbody tr'));
        const rowIndex = rows.indexOf(row);

        let targetCell = null;

        switch(e.key) {
            case 'ArrowDown':
            case 'Enter':
                e.preventDefault();
                if (rowIndex < rows.length - 1) {
                    targetCell = rows[rowIndex + 1].cells[cellIndex];
                }
                break;
            case 'ArrowUp':
                e.preventDefault();
                if (rowIndex > 0) {
                    targetCell = rows[rowIndex - 1].cells[cellIndex];
                }
                break;
            case 'ArrowRight':
                if (this.selectionStart === this.value.length) {
                    e.preventDefault();
                    if (cellIndex < row.cells.length - 1) {
                        targetCell = row.cells[cellIndex + 1];
                    }
                }
                break;
            case 'ArrowLeft':
                if (this.selectionStart === 0) {
                    e.preventDefault();
                    if (cellIndex > 1) {
                        targetCell = row.cells[cellIndex - 1];
                    }
                }
                break;
        }

        if (targetCell) {
            const targetInput = targetCell.querySelector('input[type="number"]');
            if (targetInput) {
                targetInput.focus();
                targetInput.select();
            }
        }
    });
});
</script>
@endsection
