@extends('layouts.app')

@section('title', 'Detalhes da Estação')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-satellite-dish mr-3 text-green-600"></i>
                    {{ $estacao->nome }}
                </h1>
                <p class="text-gray-600 mt-2">Código: {{ $estacao->codigo }} • Tipo: 
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                        @if($estacao->tipo == 'hidrometrica') bg-blue-100 text-blue-800
                        @elseif($estacao->tipo == 'pluviometrica') bg-green-100 text-green-800
                        @elseif($estacao->tipo == 'meteorologica') bg-purple-100 text-purple-800
                        @else bg-gray-100 text-gray-800 @endif">
                        {{ ucfirst($estacao->tipo) }}
                    </span>
                    • Estado: 
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                        @if($estacao->estado == 'activa') bg-green-100 text-green-800
                        @elseif($estacao->estado == 'inactiva') bg-red-100 text-red-800
                        @else bg-yellow-100 text-yellow-800 @endif">
                        {{ ucfirst($estacao->estado) }}
                    </span>
                </p>
            </div>
            <div class="flex space-x-3">
                <a href="{{ route('estacoes.edit', $estacao) }}" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg flex items-center">
                    <i class="fas fa-edit mr-2"></i>
                    Editar
                </a>
                <form action="{{ route('estacoes.destroy', $estacao) }}" method="POST" class="inline-block" 
                      onsubmit="return confirm('Tem certeza que deseja remover esta estação?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg flex items-center">
                        <i class="fas fa-trash mr-2"></i>
                        Remover
                    </button>
                </form>
                <a href="{{ route('estacoes.index') }}" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-lg flex items-center">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Voltar
                </a>
            </div>
        </div>
    </div>

    <!-- Status Cards -->
    @if($estacao->ultima_leitura)
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-blue-100 text-blue-600">
                    <i class="fas fa-ruler text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Nível Hidromérico</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ $estacao->ultima_leitura->nivel_hidrometrico ?? 'N/A' }}m</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-green-100 text-green-600">
                    <i class="fas fa-cloud-rain text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Precipitação</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ $estacao->ultima_leitura->precipitacao_mm ?? 'N/A' }}mm</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-purple-100 text-purple-600">
                    <i class="fas fa-thermometer-half text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Temperatura</p>
                    <p class="text-lg font-semibold text-gray-900">
                        @if($estacao->ultima_leitura->temperatura_max || $estacao->ultima_leitura->temperatura_min)
                            {{ $estacao->ultima_leitura->temperatura_max ?? 'N/A' }}° / {{ $estacao->ultima_leitura->temperatura_min ?? 'N/A' }}°
                        @else
                            N/A
                        @endif
                    </p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-orange-100 text-orange-600">
                    <i class="fas fa-clock text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Última Leitura</p>
                    <p class="text-lg font-semibold text-gray-900">{{ $estacao->ultima_leitura->data_leitura->format('d/m/Y') }}</p>
                </div>
            </div>
        </div>
    </div>
    @endif

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Informações Gerais -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Dados Técnicos -->
            <div class="bg-white rounded-lg shadow">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900">
                        <i class="fas fa-cogs mr-2 text-green-600"></i>
                        Informações da Estação
                    </h3>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <h4 class="font-medium text-gray-900 mb-3">Configuração</h4>
                            <div class="space-y-2">
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Tipo:</span>
                                    <span class="font-medium">{{ ucfirst($estacao->tipo) }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Frequência:</span>
                                    <span class="font-medium">{{ ucfirst(str_replace('_', ' ', $estacao->frequencia_leitura)) }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Equipamento:</span>
                                    <span class="font-medium">{{ $estacao->equipamento ?? 'N/A' }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Data Instalação:</span>
                                    <span class="font-medium">{{ $estacao->data_instalacao ? $estacao->data_instalacao->format('d/m/Y') : 'N/A' }}</span>
                                </div>
                            </div>
                        </div>

                        <div>
                            <h4 class="font-medium text-gray-900 mb-3">Localização</h4>
                            <div class="space-y-2">
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Província:</span>
                                    <span class="font-medium">{{ $estacao->provincia ?? 'N/A' }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Distrito:</span>
                                    <span class="font-medium">{{ $estacao->distrito ?? 'N/A' }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Rio:</span>
                                    <span class="font-medium">{{ $estacao->rio ?? 'N/A' }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Altitude:</span>
                                    <span class="font-medium">{{ $estacao->altitude ? $estacao->altitude . 'm' : 'N/A' }}</span>
                                </div>
                            </div>
                        </div>

                        <div>
                            <h4 class="font-medium text-gray-900 mb-3">Coordenadas</h4>
                            <div class="space-y-2">
                                @if($estacao->latitude && $estacao->longitude)
                                    <x-coordenadas-clicaveis
                                        :latitude="$estacao->latitude"
                                        :longitude="$estacao->longitude"
                                        :nome="$estacao->nome"
                                        tipo="estacao"
                                        :id="$estacao->id"
                                        size="md" />
                                @else
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Coordenadas:</span>
                                        <span class="font-medium text-gray-400">Não definidas</span>
                                    </div>
                                @endif
                            </div>
                        </div>

                        <div>
                            <h4 class="font-medium text-gray-900 mb-3">Alertas</h4>
                            <div class="space-y-2">
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Nível de Alerta:</span>
                                    <span class="font-medium">{{ $estacao->nivel_alerta ? $estacao->nivel_alerta . 'm' : 'N/A' }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Leituras Recentes -->
            @if($leituras_recentes->count() > 0)
            <div class="bg-white rounded-lg shadow">
                <div class="px-6 py-4 border-b border-gray-200">
                    <div class="flex items-center justify-between">
                        <h3 class="text-lg font-medium text-gray-900">
                            <i class="fas fa-chart-line mr-2 text-green-600"></i>
                            Leituras Recentes
                        </h3>
                        <a href="{{ route('estacoes.leituras', $estacao) }}" class="text-green-600 hover:text-green-800 text-sm">
                            Ver todas
                        </a>
                    </div>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full table-fixed divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="w-1/4 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Data</th>
                                @if($estacao->tipo == 'hidrometrica')
                                    <th class="w-1/4 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Nível</th>
                                    <th class="w-1/4 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Caudal</th>
                                @endif
                                @if(in_array($estacao->tipo, ['pluviometrica', 'meteorologica', 'climatologica']))
                                    <th class="w-1/3 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Precipitação</th>
                                @endif
                                @if(in_array($estacao->tipo, ['meteorologica', 'climatologica']))
                                    <th class="w-1/5 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Temp. Max</th>
                                    <th class="w-1/5 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Temp. Min</th>
                                @endif
                                <th class="w-1/3 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Operador</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($leituras_recentes as $leitura)
                            <tr>
                                <td class="w-1/4 px-6 py-4 break-words text-sm text-gray-900">
                                    {{ $leitura->data_leitura->format('d/m/Y') }}
                                </td>
                                @if($estacao->tipo == 'hidrometrica')
                                    <td class="w-1/4 px-6 py-4 break-words text-sm text-gray-900">{{ $leitura->nivel_hidrometrico ?? 'N/A' }}m</td>
                                    <td class="w-1/4 px-6 py-4 break-words text-sm text-gray-900">{{ $leitura->caudal ?? 'N/A' }}</td>
                                @endif
                                @if(in_array($estacao->tipo, ['pluviometrica', 'meteorologica', 'climatologica']))
                                    <td class="w-1/3 px-6 py-4 break-words text-sm text-gray-900">{{ $leitura->precipitacao_mm ?? 'N/A' }}mm</td>
                                @endif
                                @if(in_array($estacao->tipo, ['meteorologica', 'climatologica']))
                                    <td class="w-1/5 px-6 py-4 break-words text-sm text-gray-900">{{ $leitura->temperatura_max ?? 'N/A' }}°C</td>
                                    <td class="w-1/5 px-6 py-4 break-words text-sm text-gray-900">{{ $leitura->temperatura_min ?? 'N/A' }}°C</td>
                                @endif
                                <td class="w-1/3 px-6 py-4 break-words text-sm text-gray-900">{{ $leitura->operador->name ?? 'N/A' }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Info Box -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">
                    <i class="fas fa-info-circle mr-2 text-green-600"></i>
                    Informações
                </h3>
                <div class="space-y-3">
                    <div>
                        <span class="text-sm text-gray-600">Bacia Hidrográfica:</span>
                        <div class="font-medium">{{ $estacao->bacia_hidrografica->nome ?? 'N/A' }}</div>
                    </div>
                    @if($estacao->observacoes)
                    <div>
                        <span class="text-sm text-gray-600">Observações:</span>
                        <div class="text-sm mt-1">{{ $estacao->observacoes }}</div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">
                    <i class="fas fa-bolt mr-2 text-yellow-600"></i>
                    Ações Rápidas
                </h3>
                <div class="space-y-3">
                    <a href="{{ route('estacoes.leituras', $estacao) }}" class="block w-full text-center px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700">
                        <i class="fas fa-chart-line mr-2"></i>
                        Ver Leituras
                    </a>
                    <a href="{{ route('estacoes.leituras.create', $estacao) }}" class="block w-full text-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-all duration-200">
                        <i class="fas fa-plus mr-2"></i>
                        Nova Leitura
                    </a>
                    @if($estacao->isHidrometrica())
                    <a href="{{ route('estacoes.formulas-caudal.index', $estacao) }}" class="block w-full text-center px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition-all duration-200">
                        <i class="fas fa-calculator mr-2"></i>
                        Fórmulas de Caudal
                    </a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>


@endsection