<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Estatísticas - {{ ucfirst($tipo) }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #1F2937;
            padding-bottom: 15px;
        }
        .header h1 {
            margin: 0;
            color: #1F2937;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #6B7280;
            font-size: 14px;
        }
        .info-box {
            background-color: #F3F4F6;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .info-box strong {
            color: #1F2937;
        }
        .chart-container {
            text-align: center;
            margin: 30px 0;
        }
        .chart-container img {
            max-width: 100%;
            border: 1px solid #E5E7EB;
            border-radius: 8px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th {
            background-color: #1F2937;
            color: white;
            padding: 12px 8px;
            text-align: center;
            font-weight: bold;
            font-size: 11px;
            text-transform: uppercase;
        }
        td {
            padding: 10px 8px;
            text-align: center;
            border-bottom: 1px solid #E5E7EB;
        }
        tr:nth-child(even) {
            background-color: #F9FAFB;
        }
        tr:hover {
            background-color: #EFF6FF;
        }
        .media-col {
            font-weight: bold;
            color: #2563EB;
            background-color: #EFF6FF;
        }
        .minimo-col {
            color: #D97706;
        }
        .maximo-col {
            color: #059669;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #9CA3AF;
            border-top: 1px solid #E5E7EB;
            padding-top: 10px;
        }
        .stats-summary {
            display: flex;
            justify-content: space-around;
            margin: 20px 0;
        }
        .stat-card {
            background: #EFF6FF;
            border-left: 4px solid #2563EB;
            padding: 15px;
            text-align: center;
            flex: 1;
            margin: 0 10px;
        }
        .stat-value {
            font-size: 20px;
            font-weight: bold;
            color: #1F2937;
        }
        .stat-label {
            font-size: 11px;
            color: #6B7280;
            margin-top: 5px;
        }
    </style>
</head>
<body>
    <!-- Cabeçalho -->
    <div class="header">
        <h1>📊 Estatísticas - {{ ucfirst($tipo) }}</h1>
        <p><strong>{{ $entidadeNome }}</strong></p>
        <p>Período: {{ ucfirst($periodo) }} | {{ is_string($dataInicio) ? $dataInicio : $dataInicio->format('d/m/Y') }} - {{ is_string($dataFim) ? $dataFim : $dataFim->format('d/m/Y') }}</p>
        <p style="font-size: 10px;">Gerado em: {{ \Carbon\Carbon::now()->format('d/m/Y H:i:s') }}</p>
    </div>

    <!-- Resumo Estatístico -->
    @if(count($medias) > 0)
    <div class="info-box">
        <strong>📈 Resumo Estatístico</strong>
        <table style="border: none; margin-top: 10px;">
            <tr style="background: none;">
                <td style="border: none; text-align: left;"><strong>Média Geral:</strong> {{ number_format($medias->avg('media'), 2) }} {{ $tipo === 'precipitacao' ? 'mm' : 'm' }}</td>
                <td style="border: none; text-align: left;"><strong>Valor Máximo:</strong> {{ number_format($medias->max('maximo'), 2) }} {{ $tipo === 'precipitacao' ? 'mm' : 'm' }}</td>
            </tr>
            <tr style="background: none;">
                <td style="border: none; text-align: left;"><strong>Valor Mínimo:</strong> {{ number_format($medias->min('minimo'), 2) }} {{ $tipo === 'precipitacao' ? 'mm' : 'm' }}</td>
                <td style="border: none; text-align: left;"><strong>Total de Leituras:</strong> {{ $medias->sum('leituras') }}</td>
            </tr>
            @if($tipo === 'precipitacao')
            <tr style="background: none;">
                <td style="border: none; text-align: left;" colspan="2"><strong>Precipitação Acumulada:</strong> {{ number_format($medias->sum('total'), 2) }} mm</td>
            </tr>
            @endif
        </table>
    </div>

    <!-- Gráfico -->
    <div class="chart-container">
        <h3 style="color: #1F2937;">Gráfico de Médias</h3>
        <img src="{{ $chartImageBase64 }}" alt="Gráfico de Estatísticas" style="width: 100%; max-width: 800px; height: auto;">
    </div>

    <!-- Tabela de Dados -->
    <h3 style="color: #1F2937; margin-top: 30px;">📋 Dados Detalhados</h3>
    <table>
        <thead>
            <tr>
                <th>Período</th>
                <th>Média {{ $tipo === 'precipitacao' ? '(mm)' : '(m)' }}</th>
                @if($tipo === 'precipitacao')
                <th>Total (mm)</th>
                @endif
                <th>Mínimo {{ $tipo === 'precipitacao' ? '(mm)' : '(m)' }}</th>
                <th>Máximo {{ $tipo === 'precipitacao' ? '(mm)' : '(m)' }}</th>
                <th>Nº Leituras</th>
            </tr>
        </thead>
        <tbody>
            @foreach($medias as $media)
            <tr>
                <td>
                    @if(isset($media->data))
                        {{ \Carbon\Carbon::parse($media->data)->format('d/m/Y') }}
                    @elseif(isset($media->semana))
                        Semana {{ $media->semana }}/{{ $media->ano }}
                    @elseif(isset($media->mes))
                        {{ \Carbon\Carbon::create($media->ano, $media->mes)->format('F/Y') }}
                    @else
                        {{ $media->ano }}
                    @endif
                </td>
                <td class="media-col">{{ number_format($media->media, 2) }}</td>
                @if($tipo === 'precipitacao')
                <td>{{ number_format($media->total, 2) }}</td>
                @endif
                <td class="minimo-col">{{ number_format($media->minimo, 2) }}</td>
                <td class="maximo-col">{{ number_format($media->maximo, 2) }}</td>
                <td>{{ $media->leituras }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @else
    <div class="info-box" style="text-align: center; color: #DC2626;">
        <strong>⚠️ Nenhum dado disponível para o período selecionado.</strong>
    </div>
    @endif

    <!-- Rodapé -->
    <div class="footer">
        <p>Sistema Hidrológico - Gestão de Barragens e Estações | Moçambique</p>
        <p>Documento gerado automaticamente pelo sistema</p>
    </div>
</body>
</html>
