<table>
    <!-- Header -->
    <tr>
        <td colspan="7" style="text-align: center; font-weight: bold; font-size: 16px; background-color: #2563EB; color: white; padding: 10px;">
            {{ strtoupper(str_replace('_', ' ', $boletim->tipo)) }} - {{ $boletim->numero_edicao ?? 'N/A' }}
        </td>
    </tr>
    <tr></tr>
    <tr>
        <td colspan="7" style="font-weight: bold; font-size: 14px; color: #1E40AF; background-color: #EBF4FF; padding: 5px;">
            Data de Emissão: {{ \Carbon\Carbon::parse($boletim->data_emissao)->format('d/m/Y') }}
        </td>
    </tr>
    <tr></tr>

    @if($boletim->tipo === 'hidrologico_regional')
        <!-- Estações Hidrográficas -->
        <tr>
            <td colspan="7" style="font-weight: bold; font-size: 12px; background-color: #F3F4F6; padding: 5px;">
                ESTAÇÕES HIDROGRÁFICAS
            </td>
        </tr>
        <tr style="background-color: #3B82F6; color: white; font-weight: bold;">
            <td>Nome da Estação</td>
            <td>Nível (m)</td>
            <td>Volume (%)</td>
            <td>Status</td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        @foreach($data['estacoes_hidrograficas'] as $estacao)
        <tr>
            <td>{{ $estacao['nome'] }}</td>
            <td>{{ $estacao['nivel'] }}</td>
            <td>{{ $estacao['volume'] }}</td>
            <td>{{ $estacao['status'] }}</td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        @endforeach
        <tr></tr>

        <!-- Barragens -->
        <tr>
            <td colspan="7" style="font-weight: bold; font-size: 12px; background-color: #F3F4F6; padding: 5px;">
                BARRAGENS PRINCIPAIS
            </td>
        </tr>
        <tr style="background-color: #3B82F6; color: white; font-weight: bold;">
            <td>Nome da Barragem</td>
            <td>Capacidade</td>
            <td>Nível Atual</td>
            <td>Entrada (m³/s)</td>
            <td>Saída (m³/s)</td>
            <td></td>
            <td></td>
        </tr>
        @foreach($data['barragens'] as $barragem)
        <tr>
            <td>{{ $barragem['nome'] }}</td>
            <td>{{ $barragem['capacidade'] }}</td>
            <td>{{ $barragem['nivel_atual'] }}</td>
            <td>{{ $barragem['entrada'] }}</td>
            <td>{{ $barragem['saida'] }}</td>
            <td></td>
            <td></td>
        </tr>
        @endforeach
        <tr></tr>

        <!-- Precipitação -->
        <tr>
            <td colspan="7" style="font-weight: bold; font-size: 12px; background-color: #F3F4F6; padding: 5px;">
                DADOS DE PRECIPITAÇÃO
            </td>
        </tr>
        <tr style="background-color: #3B82F6; color: white; font-weight: bold;">
            <td>Estação</td>
            <td>Precip. 24h</td>
            <td>Precip. Mensal</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        @foreach($data['precipitacao'] as $precip)
        <tr>
            <td>{{ $precip['estacao'] }}</td>
            <td>{{ $precip['precipitacao_24h'] }}</td>
            <td>{{ $precip['precipitacao_mensal'] }}</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        @endforeach

    @elseif($boletim->tipo === 'hidrologico_provincial')
        <!-- Barragens de Nampula -->
        <tr>
            <td colspan="7" style="font-weight: bold; font-size: 12px; background-color: #F3F4F6; padding: 5px;">
                BARRAGENS DA PROVÍNCIA DE NAMPULA
            </td>
        </tr>
        <tr style="background-color: #3B82F6; color: white; font-weight: bold;">
            <td>Nome da Barragem</td>
            <td>Nível Atual</td>
            <td>Volume</td>
            <td>Status</td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        @foreach($data['barragens_nampula'] as $barragem)
        <tr>
            <td>{{ $barragem['nome'] }}</td>
            <td>{{ $barragem['nivel_atual'] }}</td>
            <td>{{ $barragem['volume'] }}</td>
            <td>{{ $barragem['status'] }}</td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        @endforeach
        <tr></tr>

        <!-- Postos Udográficos -->
        <tr>
            <td colspan="7" style="font-weight: bold; font-size: 12px; background-color: #F3F4F6; padding: 5px;">
                POSTOS UDOGRÁFICOS
            </td>
        </tr>
        <tr style="background-color: #3B82F6; color: white; font-weight: bold;">
            <td>Posto</td>
            <td>Nível (m)</td>
            <td>Caudal (m³/s)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        @foreach($data['postos_udograficos'] as $posto)
        <tr>
            <td>{{ $posto['posto'] }}</td>
            <td>{{ $posto['nivel'] }}</td>
            <td>{{ $posto['caudal'] }}</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        @endforeach

    @else
        <!-- Informativo de Barragens -->
        <tr>
            <td colspan="7" style="font-weight: bold; font-size: 12px; background-color: #F3F4F6; padding: 5px;">
                BARRAGENS PRINCIPAIS DO PAÍS
            </td>
        </tr>
        <tr style="background-color: #3B82F6; color: white; font-weight: bold;">
            <td>Nome da Barragem</td>
            <td>Capacidade</td>
            <td>Nível Atual</td>
            <td>Produção Energia</td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        @foreach($data['barragens_principais'] as $barragem)
        <tr>
            <td>{{ $barragem['nome'] }}</td>
            <td>{{ $barragem['capacidade'] }}</td>
            <td>{{ $barragem['nivel_atual'] }}</td>
            <td>{{ $barragem['producao_energia'] }}</td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        @endforeach
        <tr></tr>

        <!-- Alertas -->
        <tr>
            <td colspan="7" style="font-weight: bold; font-size: 12px; background-color: #F3F4F6; padding: 5px;">
                ALERTAS E OBSERVAÇÕES
            </td>
        </tr>
        @foreach($data['alertas'] as $alerta)
        <tr>
            <td colspan="7">{{ $alerta }}</td>
        </tr>
        @endforeach
    @endif

    <tr></tr>
    <tr></tr>

    <!-- Informações do Boletim -->
    <tr>
        <td colspan="7" style="font-weight: bold; font-size: 12px; background-color: #F3F4F6; padding: 5px;">
            INFORMAÇÕES DO BOLETIM
        </td>
    </tr>
    <tr>
        <td colspan="2" style="font-weight: bold;">Situação Prevalecente:</td>
        <td colspan="5">{{ $boletim->situacao_prevalecente ?? 'Não informado' }}</td>
    </tr>
    <tr>
        <td colspan="2" style="font-weight: bold;">Previsão Hidrológica:</td>
        <td colspan="5">{{ $boletim->previsao_hidrologica ?? 'Não informado' }}</td>
    </tr>
    <tr>
        <td colspan="2" style="font-weight: bold;">Alertas e Precauções:</td>
        <td colspan="5">{{ $boletim->alertas_precaucoes ?? 'Não informado' }}</td>
    </tr>
    <tr>
        <td colspan="2" style="font-weight: bold;">Estado:</td>
        <td colspan="5">{{ strtoupper($boletim->estado) }}</td>
    </tr>
    <tr>
        <td colspan="2" style="font-weight: bold;">Elaborado por:</td>
        <td colspan="5">{{ $boletim->elaborador->name ?? 'Sistema' }}</td>
    </tr>
    @if($boletim->aprovador)
    <tr>
        <td colspan="2" style="font-weight: bold;">Aprovado por:</td>
        <td colspan="5">{{ $boletim->aprovador->name }}</td>
    </tr>
    @endif
</table>