@extends('layouts.app')

@section('title', 'Áreas de Jurisdição')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-border-all mr-3 text-blue-600"></i>
                    Áreas de Jurisdição
                </h1>
                <p class="text-gray-600 mt-2">Gerir áreas de jurisdição com limites geográficos definidos</p>
            </div>
            <a href="{{ route('jurisdicao.areas.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors">
                <i class="fas fa-plus mr-2"></i>
                Nova Área
            </a>
        </div>
    </div>

    <!-- Lista de Áreas -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        @forelse($areas as $area)
        <div class="bg-white rounded-lg shadow hover:shadow-lg transition-shadow">
            <div class="p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-bold text-gray-900">{{ $area->nome }}</h3>
                    <span class="px-3 py-1 rounded-full text-xs {{ $area->ativo ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                        {{ $area->ativo ? 'Ativa' : 'Inativa' }}
                    </span>
                </div>

                <div class="space-y-2 text-sm text-gray-600 mb-4">
                    <p><strong>Código:</strong> {{ $area->codigo }}</p>
                    <p><strong>Área Total:</strong> {{ number_format($area->area_total_km2, 2) }} km²</p>
                    <p><strong>Bacias:</strong> {{ $area->bacias_count }}</p>
                    @if($area->responsavel)
                        <p><strong>Responsável:</strong> {{ $area->responsavel }}</p>
                    @endif
                </div>

                @if($area->descricao)
                <p class="text-sm text-gray-700 mb-4 line-clamp-3">{{ $area->descricao }}</p>
                @endif

                <div class="flex space-x-2">
                    <button class="flex-1 bg-blue-600 text-white px-3 py-2 rounded-md text-sm hover:bg-blue-700 transition-colors">
                        <i class="fas fa-eye mr-1"></i>
                        Ver Detalhes
                    </button>
                    <button class="flex-1 bg-green-600 text-white px-3 py-2 rounded-md text-sm hover:bg-green-700 transition-colors">
                        <i class="fas fa-edit mr-1"></i>
                        Editar
                    </button>
                </div>
            </div>
        </div>
        @empty
        <div class="col-span-3 bg-blue-50 border-l-4 border-blue-400 p-6 rounded">
            <div class="flex items-center">
                <i class="fas fa-info-circle text-blue-400 text-2xl mr-3"></i>
                <div>
                    <p class="text-blue-900 font-medium">Nenhuma área de jurisdição cadastrada</p>
                    <p class="text-blue-700 text-sm mt-1">Clique em "Nova Área" para começar a definir áreas de jurisdição com limites geográficos.</p>
                </div>
            </div>
        </div>
        @endforelse
    </div>

    <!-- Informações -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">
            <i class="fas fa-info-circle mr-2 text-blue-600"></i>
            Sobre Áreas de Jurisdição
        </h3>
        <div class="text-sm text-gray-700 space-y-2">
            <p>Áreas de jurisdição são delimitações geográficas que definem a área de atuação do sistema hidrológico.</p>
            <p>Cada área pode conter:</p>
            <ul class="list-disc list-inside ml-4 space-y-1">
                <li>Limites geográficos definidos em formato GeoJSON</li>
                <li>Múltiplas bacias hidrográficas</li>
                <li>Informações de responsável e contato</li>
                <li>Cálculo automático de área total</li>
            </ul>
        </div>
    </div>
</div>
@endsection
