@extends('layouts.app')

@section('title', 'Médias Aritméticas')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-calculator mr-3 text-purple-600"></i>
                    Médias Aritméticas
                </h1>
                <p class="text-gray-600 mt-2">Cálculo de médias de precipitação, cotas e níveis</p>
            </div>
        </div>
    </div>

    <!-- Cards de Navegação -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Card 1: Precipitação -->
        <a href="{{ route('medias.precipitacao') }}" class="block">
            <div class="bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg shadow-lg p-6 text-white hover:shadow-xl transform hover:-translate-y-1 transition-all duration-200">
                <div class="flex items-center justify-between mb-4">
                    <i class="fas fa-cloud-rain text-5xl opacity-75"></i>
                    <span class="bg-white bg-opacity-20 px-3 py-1 rounded-full text-sm font-semibold">1</span>
                </div>
                <h3 class="text-xl font-bold mb-2">Média de Precipitação</h3>
                <p class="text-blue-100 text-sm mb-4">Calcular médias de chuva por período</p>
                <div class="flex items-center text-sm">
                    <span>Ver médias</span>
                    <i class="fas fa-arrow-right ml-2"></i>
                </div>
            </div>
        </a>

        <!-- Card 2: Cotas nas Barragens -->
        <a href="{{ route('medias.cotas-barragens') }}" class="block">
            <div class="bg-gradient-to-br from-green-500 to-green-600 rounded-lg shadow-lg p-6 text-white hover:shadow-xl transform hover:-translate-y-1 transition-all duration-200">
                <div class="flex items-center justify-between mb-4">
                    <i class="fas fa-water text-5xl opacity-75"></i>
                    <span class="bg-white bg-opacity-20 px-3 py-1 rounded-full text-sm font-semibold">2</span>
                </div>
                <h3 class="text-xl font-bold mb-2">Média de Cotas nas Barragens</h3>
                <p class="text-green-100 text-sm mb-4">Calcular médias de cotas por período</p>
                <div class="flex items-center text-sm">
                    <span>Ver médias</span>
                    <i class="fas fa-arrow-right ml-2"></i>
                </div>
            </div>
        </a>

        <!-- Card 3: Níveis -->
        <a href="{{ route('medias.niveis') }}" class="block">
            <div class="bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg shadow-lg p-6 text-white hover:shadow-xl transform hover:-translate-y-1 transition-all duration-200">
                <div class="flex items-center justify-between mb-4">
                    <i class="fas fa-chart-line text-5xl opacity-75"></i>
                    <span class="bg-white bg-opacity-20 px-3 py-1 rounded-full text-sm font-semibold">3</span>
                </div>
                <h3 class="text-xl font-bold mb-2">Média de Níveis</h3>
                <p class="text-purple-100 text-sm mb-4">Calcular médias de níveis hidrométricos</p>
                <div class="flex items-center text-sm">
                    <span>Ver médias</span>
                    <i class="fas fa-arrow-right ml-2"></i>
                </div>
            </div>
        </a>
    </div>

    <!-- Informações -->
    <div class="bg-blue-50 border-l-4 border-blue-400 p-4 rounded">
        <div class="flex">
            <i class="fas fa-info-circle text-blue-400 mt-0.5"></i>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-blue-800">Sobre as Médias Aritméticas</h3>
                <div class="mt-2 text-sm text-blue-700">
                    <p class="mb-2">As médias podem ser calculadas por diferentes períodos:</p>
                    <ul class="list-disc list-inside space-y-1">
                        <li><strong>Diário:</strong> Média de cada dia</li>
                        <li><strong>Semanal:</strong> Média por semana</li>
                        <li><strong>Mensal:</strong> Média por mês</li>
                        <li><strong>Anual:</strong> Média por ano</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Estatísticas Rápidas -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-blue-100 rounded-full p-3">
                    <i class="fas fa-database text-2xl text-blue-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Estações Pluviométricas</p>
                    <p class="text-3xl font-bold text-gray-900">{{ \App\Models\Estacao::whereIn('tipo', ['pluviometrica', 'meteorologica', 'climatologica'])->count() }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-green-100 rounded-full p-3">
                    <i class="fas fa-water text-2xl text-green-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Barragens</p>
                    <p class="text-3xl font-bold text-gray-900">{{ \App\Models\Barragem::count() }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-purple-100 rounded-full p-3">
                    <i class="fas fa-chart-line text-2xl text-purple-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Estações Hidrométricas</p>
                    <p class="text-3xl font-bold text-gray-900">{{ \App\Models\Estacao::where('tipo', 'hidrometrica')->count() }}</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
