@extends('layouts.app')

@section('title', 'Média de Precipitação')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-cloud-rain mr-3 text-blue-600"></i>
                    Média Aritmética de Precipitação
                </h1>
                <p class="text-gray-600 mt-2">Cálculo de médias de chuva por período</p>
            </div>
            <a href="{{ route('medias.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Voltar
            </a>
        </div>
    </div>

    <!-- Filtros -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">
            <i class="fas fa-filter mr-2 text-blue-600"></i>
            Filtros
        </h3>

        <form method="GET" action="{{ route('medias.precipitacao') }}" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Estação</label>
                <select name="estacao_id" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200" required>
                    <option value="">Selecione uma estação</option>
                    @foreach($estacoes as $est)
                        <option value="{{ $est->id }}" {{ $estacaoId == $est->id ? 'selected' : '' }}>
                            {{ $est->codigo }} - {{ $est->nome }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Período</label>
                <select name="periodo" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
                    <option value="diario" {{ $periodo == 'diario' ? 'selected' : '' }}>Diário</option>
                    <option value="semanal" {{ $periodo == 'semanal' ? 'selected' : '' }}>Semanal</option>
                    <option value="mensal" {{ $periodo == 'mensal' ? 'selected' : '' }}>Mensal</option>
                    <option value="anual" {{ $periodo == 'anual' ? 'selected' : '' }}>Anual</option>
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Início</label>
                <input type="date" name="data_inicio" value="{{ $dataInicio }}"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Fim</label>
                <input type="date" name="data_fim" value="{{ $dataFim }}"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
            </div>

            <div class="md:col-span-4 flex justify-end">
                <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-md hover:bg-blue-700 transition-colors">
                    <i class="fas fa-search mr-2"></i>
                    Calcular Médias
                </button>
            </div>
        </form>
    </div>

    @if($estacaoId && count($medias) > 0)
        <!-- Estatísticas Resumidas -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-blue-100 rounded-full p-3">
                        <i class="fas fa-chart-line text-2xl text-blue-600"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Média Geral</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($medias->avg('media'), 2) }} mm</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-green-100 rounded-full p-3">
                        <i class="fas fa-arrow-up text-2xl text-green-600"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Máximo</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($medias->max('maximo'), 2) }} mm</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-yellow-100 rounded-full p-3">
                        <i class="fas fa-arrow-down text-2xl text-yellow-600"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Mínimo</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($medias->min('minimo'), 2) }} mm</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-purple-100 rounded-full p-3">
                        <i class="fas fa-cloud text-2xl text-purple-600"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Total Acumulado</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($medias->sum('total'), 2) }} mm</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Gráfico -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900">
                    <i class="fas fa-chart-bar mr-2 text-blue-600"></i>
                    Gráfico de Médias
                </h3>
            </div>
            <div class="p-6">
                <canvas id="chartPrecipitacao" style="max-height: 400px;"></canvas>
            </div>
        </div>

        <!-- Tabela de Resultados -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900">
                    <i class="fas fa-table mr-2 text-blue-600"></i>
                    Dados Detalhados
                </h3>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-800 text-white">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Período</th>
                            <th class="px-6 py-3 text-center text-xs font-medium uppercase tracking-wider">Média (mm)</th>
                            <th class="px-6 py-3 text-center text-xs font-medium uppercase tracking-wider">Total (mm)</th>
                            <th class="px-6 py-3 text-center text-xs font-medium uppercase tracking-wider">Mínimo (mm)</th>
                            <th class="px-6 py-3 text-center text-xs font-medium uppercase tracking-wider">Máximo (mm)</th>
                            <th class="px-6 py-3 text-center text-xs font-medium uppercase tracking-wider">Nº Leituras</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($medias as $media)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                    @if(isset($media->data))
                                        {{ \Carbon\Carbon::parse($media->data)->format('d/m/Y') }}
                                    @elseif(isset($media->semana))
                                        Semana {{ $media->semana }}/{{ $media->ano }}
                                    @elseif(isset($media->mes))
                                        {{ \Carbon\Carbon::create($media->ano, $media->mes)->format('F/Y') }}
                                    @else
                                        {{ $media->ano }}
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-700">
                                    <span class="font-bold text-blue-600">{{ number_format($media->media, 2) }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-700">
                                    {{ number_format($media->total, 2) }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-700">
                                    {{ number_format($media->minimo, 2) }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-700">
                                    {{ number_format($media->maximo, 2) }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-700">
                                    {{ $media->leituras }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script>
        const ctx = document.getElementById('chartPrecipitacao').getContext('2d');
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: {!! json_encode($graficoLabels) !!},
                datasets: [{
                    label: 'Média de Precipitação (mm)',
                    data: {!! json_encode($graficoDados) !!},
                    backgroundColor: 'rgba(59, 130, 246, 0.7)',
                    borderColor: 'rgb(59, 130, 246)',
                    borderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        display: true,
                        position: 'top'
                    },
                    title: {
                        display: true,
                        text: 'Média de Precipitação por {{ ucfirst($periodo) }}'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return value + ' mm';
                            }
                        }
                    }
                }
            }
        });
        </script>
    @elseif($estacaoId)
        <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 rounded">
            <div class="flex">
                <i class="fas fa-exclamation-triangle text-yellow-400 mt-0.5"></i>
                <p class="ml-3 text-sm text-yellow-700">
                    Nenhuma leitura de precipitação encontrada para o período selecionado.
                </p>
            </div>
        </div>
    @else
        <div class="bg-blue-50 border-l-4 border-blue-400 p-4 rounded">
            <div class="flex">
                <i class="fas fa-info-circle text-blue-400 mt-0.5"></i>
                <p class="ml-3 text-sm text-blue-700">
                    Selecione uma estação e configure os filtros para calcular as médias de precipitação.
                </p>
            </div>
        </div>
    @endif
</div>
@endsection
