@extends('layouts.app')

@section('title', 'Dashboard - QA Global')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-chart-line mr-3 text-blue-600"></i>
                    Dashboard - Qualidade de Água Global
                </h1>
                <p class="text-gray-600 mt-2">Estatísticas e análises do IQA</p>
            </div>
            <a href="{{ route('qa-global.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Voltar
            </a>
        </div>
    </div>

    <!-- Filtros de Data -->
    <div class="bg-white rounded-lg shadow p-6">
        <form method="GET" action="{{ route('qa-global.dashboard') }}" class="flex items-end space-x-4">
            <div class="flex-1">
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Início</label>
                <input type="date" name="data_inicio" value="{{ $dataInicio }}"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
            </div>
            <div class="flex-1">
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Fim</label>
                <input type="date" name="data_fim" value="{{ $dataFim }}"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
            </div>
            <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-md hover:bg-blue-700 transition-colors">
                <i class="fas fa-filter mr-2"></i>Filtrar
            </button>
        </form>
    </div>

    <!-- Estatísticas Gerais -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Total de Coletas -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-blue-100 rounded-full p-3">
                    <i class="fas fa-flask text-2xl text-blue-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total de Coletas</p>
                    <p class="text-3xl font-bold text-gray-900">{{ $estatisticas['total_coletas'] }}</p>
                </div>
            </div>
        </div>

        <!-- IQA Médio -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-green-100 rounded-full p-3">
                    <i class="fas fa-chart-bar text-2xl text-green-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">IQA Médio</p>
                    <p class="text-3xl font-bold text-gray-900">{{ number_format($estatisticas['iqa_medio'], 2) }}</p>
                </div>
            </div>
        </div>

        <!-- Coletas Validadas -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-purple-100 rounded-full p-3">
                    <i class="fas fa-check-circle text-2xl text-purple-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Coletas Validadas</p>
                    <p class="text-3xl font-bold text-gray-900">{{ $estatisticas['validadas'] }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Distribuição por Classificação -->
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">
                <i class="fas fa-pie-chart mr-2 text-blue-600"></i>
                Distribuição por Classificação IQA
            </h3>
        </div>
        <div class="p-6">
            @if($distribuicao->count() > 0)
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4">
                    @foreach($distribuicao as $classificacao => $quantidade)
                        @php
                            $cores = [
                                'Excelente' => ['bg' => 'bg-blue-100', 'text' => 'text-blue-800', 'border' => 'border-blue-500'],
                                'Bom' => ['bg' => 'bg-green-100', 'text' => 'text-green-800', 'border' => 'border-green-500'],
                                'Médio' => ['bg' => 'bg-yellow-100', 'text' => 'text-yellow-800', 'border' => 'border-yellow-500'],
                                'Ruim' => ['bg' => 'bg-orange-100', 'text' => 'text-orange-800', 'border' => 'border-orange-500'],
                                'Muito Ruim' => ['bg' => 'bg-red-100', 'text' => 'text-red-800', 'border' => 'border-red-500'],
                            ];
                            $cor = $cores[$classificacao] ?? ['bg' => 'bg-gray-100', 'text' => 'text-gray-800', 'border' => 'border-gray-500'];
                        @endphp
                        <div class="border-l-4 {{ $cor['border'] }} {{ $cor['bg'] }} rounded-lg p-4">
                            <p class="text-xs font-medium {{ $cor['text'] }} uppercase">{{ $classificacao }}</p>
                            <p class="text-2xl font-bold {{ $cor['text'] }} mt-2">{{ $quantidade }}</p>
                            <p class="text-xs {{ $cor['text'] }} mt-1">
                                {{ $estatisticas['total_coletas'] > 0 ? number_format(($quantidade / $estatisticas['total_coletas']) * 100, 1) : 0 }}%
                            </p>
                        </div>
                    @endforeach
                </div>

                <!-- Gráfico de Barras -->
                <div class="mt-6">
                    <canvas id="chartDistribuicao" class="w-full" style="max-height: 300px;"></canvas>
                </div>
            @else
                <div class="text-center py-8 text-gray-500">
                    <i class="fas fa-info-circle text-4xl mb-4"></i>
                    <p>Nenhum dado disponível para o período selecionado</p>
                </div>
            @endif
        </div>
    </div>

    <!-- IQA por Estação -->
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">
                <i class="fas fa-map-marker-alt mr-2 text-blue-600"></i>
                IQA Médio por Estação
            </h3>
        </div>
        <div class="p-6">
            @if($iqaPorEstacao->count() > 0)
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-800 text-white">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Estação</th>
                                <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Bacia Hidrográfica</th>
                                <th class="px-6 py-3 text-center text-xs font-medium uppercase tracking-wider">IQA Médio</th>
                                <th class="px-6 py-3 text-center text-xs font-medium uppercase tracking-wider">Classificação</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($iqaPorEstacao as $dados)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-900">
                                        {{ $dados['estacao'] }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                                        {{ $dados['bacia'] }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-center">
                                        <span class="text-xl font-bold text-gray-900">{{ $dados['iqa'] }}</span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-center">
                                        @php
                                            $cores = [
                                                'Excelente' => 'bg-blue-100 text-blue-800',
                                                'Bom' => 'bg-green-100 text-green-800',
                                                'Médio' => 'bg-yellow-100 text-yellow-800',
                                                'Ruim' => 'bg-orange-100 text-orange-800',
                                                'Muito Ruim' => 'bg-red-100 text-red-800',
                                            ];
                                            $corClasse = $cores[$dados['classificacao']] ?? 'bg-gray-100 text-gray-800';
                                        @endphp
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold {{ $corClasse }}">
                                            {{ $dados['classificacao'] }}
                                        </span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Gráfico de Barras por Estação -->
                <div class="mt-6">
                    <canvas id="chartEstacoes" class="w-full" style="max-height: 400px;"></canvas>
                </div>
            @else
                <div class="text-center py-8 text-gray-500">
                    <i class="fas fa-info-circle text-4xl mb-4"></i>
                    <p>Nenhuma estação com dados no período selecionado</p>
                </div>
            @endif
        </div>
    </div>
</div>

@if($distribuicao->count() > 0 || $iqaPorEstacao->count() > 0)
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    @if($distribuicao->count() > 0)
    // Gráfico de Distribuição por Classificação
    const ctxDist = document.getElementById('chartDistribuicao');
    new Chart(ctxDist, {
        type: 'bar',
        data: {
            labels: {!! json_encode($distribuicao->keys()) !!},
            datasets: [{
                label: 'Quantidade de Coletas',
                data: {!! json_encode($distribuicao->values()) !!},
                backgroundColor: [
                    'rgba(59, 130, 246, 0.7)',  // Excelente - blue
                    'rgba(34, 197, 94, 0.7)',   // Bom - green
                    'rgba(234, 179, 8, 0.7)',   // Médio - yellow
                    'rgba(249, 115, 22, 0.7)',  // Ruim - orange
                    'rgba(239, 68, 68, 0.7)',   // Muito Ruim - red
                ],
                borderColor: [
                    'rgb(59, 130, 246)',
                    'rgb(34, 197, 94)',
                    'rgb(234, 179, 8)',
                    'rgb(249, 115, 22)',
                    'rgb(239, 68, 68)',
                ],
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    display: false
                },
                title: {
                    display: true,
                    text: 'Distribuição de Classificações IQA'
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            }
        }
    });
    @endif

    @if($iqaPorEstacao->count() > 0)
    // Gráfico de IQA por Estação
    const ctxEst = document.getElementById('chartEstacoes');
    new Chart(ctxEst, {
        type: 'bar',
        data: {
            labels: {!! json_encode($iqaPorEstacao->pluck('estacao')) !!},
            datasets: [{
                label: 'IQA Médio',
                data: {!! json_encode($iqaPorEstacao->pluck('iqa')) !!},
                backgroundColor: 'rgba(59, 130, 246, 0.7)',
                borderColor: 'rgb(59, 130, 246)',
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    display: false
                },
                title: {
                    display: true,
                    text: 'IQA Médio por Estação de Monitoramento'
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    max: 100,
                    ticks: {
                        stepSize: 10
                    }
                }
            }
        }
    });
    @endif
});
</script>
@endif
@endsection
