@extends('layouts.app')

@section('title', 'Gráficos - QA Global')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-chart-area mr-3 text-blue-600"></i>
                    Gráficos de Parâmetros de Qualidade de Água
                </h1>
                <p class="text-gray-600 mt-2">Visualização temporal dos parâmetros monitorados</p>
            </div>
            <a href="{{ route('qa-global.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Voltar
            </a>
        </div>
    </div>

    <!-- Filtros -->
    <div class="bg-white rounded-lg shadow p-6">
        <form method="GET" action="{{ route('qa-global.graficos') }}" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Parâmetro</label>
                <select name="parametro" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
                    <optgroup label="Parâmetros Físico-Químicos">
                        <option value="temperatura" {{ $parametro == 'temperatura' ? 'selected' : '' }}>Temperatura</option>
                        <option value="ph" {{ $parametro == 'ph' ? 'selected' : '' }}>pH</option>
                        <option value="oxigenio_dissolvido" {{ $parametro == 'oxigenio_dissolvido' ? 'selected' : '' }}>Oxigênio Dissolvido</option>
                        <option value="turbidez" {{ $parametro == 'turbidez' ? 'selected' : '' }}>Turbidez</option>
                        <option value="condutividade_eletrica" {{ $parametro == 'condutividade_eletrica' ? 'selected' : '' }}>Condutividade Elétrica</option>
                        <option value="tds" {{ $parametro == 'tds' ? 'selected' : '' }}>TDS</option>
                        <option value="dbo" {{ $parametro == 'dbo' ? 'selected' : '' }}>DBO</option>
                        <option value="coliformes_fecais" {{ $parametro == 'coliformes_fecais' ? 'selected' : '' }}>Coliformes Fecais</option>
                        <option value="nitrogenio_total" {{ $parametro == 'nitrogenio_total' ? 'selected' : '' }}>Nitrogênio Total</option>
                        <option value="nitrato" {{ $parametro == 'nitrato' ? 'selected' : '' }}>Nitrato</option>
                        <option value="fosfato_total" {{ $parametro == 'fosfato_total' ? 'selected' : '' }}>Fosfato Total</option>
                        <option value="fosfato" {{ $parametro == 'fosfato' ? 'selected' : '' }}>Fosfato</option>
                        <option value="cloretos" {{ $parametro == 'cloretos' ? 'selected' : '' }}>Cloretos</option>
                        <option value="solidos_totais" {{ $parametro == 'solidos_totais' ? 'selected' : '' }}>Sólidos Totais</option>
                    </optgroup>
                    <optgroup label="Metais Pesados">
                        <option value="ferro" {{ $parametro == 'ferro' ? 'selected' : '' }}>Ferro (Fe)</option>
                        <option value="chumbo" {{ $parametro == 'chumbo' ? 'selected' : '' }}>Chumbo (Pb)</option>
                        <option value="cadmio" {{ $parametro == 'cadmio' ? 'selected' : '' }}>Cádmio (Cd)</option>
                        <option value="zinco" {{ $parametro == 'zinco' ? 'selected' : '' }}>Zinco (Zn)</option>
                        <option value="cobre" {{ $parametro == 'cobre' ? 'selected' : '' }}>Cobre (Cu)</option>
                        <option value="arsenio" {{ $parametro == 'arsenio' ? 'selected' : '' }}>Arsênio (As)</option>
                        <option value="mercurio" {{ $parametro == 'mercurio' ? 'selected' : '' }}>Mercúrio (Hg)</option>
                    </optgroup>
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Início</label>
                <input type="date" name="data_inicio" value="{{ request('data_inicio') }}"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Fim</label>
                <input type="date" name="data_fim" value="{{ request('data_fim') }}"
                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200">
            </div>

            <div class="flex items-end">
                <button type="submit" class="w-full bg-blue-600 text-white px-6 py-2 rounded-md hover:bg-blue-700 transition-colors">
                    <i class="fas fa-sync-alt mr-2"></i>Atualizar
                </button>
            </div>
        </form>
    </div>

    @if($coletas->count() > 0)
        @php
            $parametrosMetais = ['ferro', 'chumbo', 'cadmio', 'zinco', 'cobre', 'arsenio', 'mercurio'];
            $ehMetal = in_array($parametro, $parametrosMetais);

            // Extrair dados para o gráfico
            $labels = [];
            $dados = [];
            $cores = [];

            foreach($coletas as $coleta) {
                $valor = null;

                if ($ehMetal && $coleta->metaisPesados) {
                    $valor = $coleta->metaisPesados->{$parametro};
                } elseif (!$ehMetal && $coleta->parametrosFisicoQuimicos) {
                    $valor = $coleta->parametrosFisicoQuimicos->{$parametro};
                }

                if ($valor !== null) {
                    $labels[] = $coleta->data_coleta->format('d/m/Y') . ' - ' . $coleta->estacao->codigo;
                    $dados[] = $valor;

                    // Definir cor baseada nos limites
                    $cor = 'rgba(34, 197, 94, 0.7)'; // Verde padrão
                    if ($limites) {
                        if ($limites->limite_maximo && $valor > $limites->limite_maximo) {
                            $cor = 'rgba(239, 68, 68, 0.7)'; // Vermelho
                        } elseif ($limites->limite_minimo && $valor < $limites->limite_minimo) {
                            $cor = 'rgba(234, 179, 8, 0.7)'; // Amarelo
                        }
                    }
                    $cores[] = $cor;
                }
            }

            // Nome formatado do parâmetro
            $nomeParametro = ucfirst(str_replace('_', ' ', $parametro));
        @endphp

        <!-- Estatísticas do Parâmetro -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-500">Mínimo</p>
                        <p class="text-2xl font-bold text-blue-600">{{ count($dados) > 0 ? number_format(min($dados), 4) : '-' }}</p>
                    </div>
                    <i class="fas fa-arrow-down text-3xl text-blue-200"></i>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-500">Máximo</p>
                        <p class="text-2xl font-bold text-red-600">{{ count($dados) > 0 ? number_format(max($dados), 4) : '-' }}</p>
                    </div>
                    <i class="fas fa-arrow-up text-3xl text-red-200"></i>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-500">Média</p>
                        <p class="text-2xl font-bold text-green-600">{{ count($dados) > 0 ? number_format(array_sum($dados) / count($dados), 4) : '-' }}</p>
                    </div>
                    <i class="fas fa-chart-line text-3xl text-green-200"></i>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-500">Amostras</p>
                        <p class="text-2xl font-bold text-purple-600">{{ count($dados) }}</p>
                    </div>
                    <i class="fas fa-vial text-3xl text-purple-200"></i>
                </div>
            </div>
        </div>

        <!-- Informação sobre Limites -->
        @if($limites)
            <div class="bg-blue-50 border-l-4 border-blue-400 p-4 rounded">
                <div class="flex">
                    <i class="fas fa-info-circle text-blue-400 mt-0.5"></i>
                    <div class="ml-3 text-sm text-blue-700">
                        <strong>Limites de Referência:</strong>
                        @if($limites->limite_minimo && $limites->limite_maximo)
                            {{ number_format($limites->limite_minimo, 4) }} - {{ number_format($limites->limite_maximo, 4) }} {{ $limites->unidade }}
                        @elseif($limites->limite_maximo)
                            Máximo: {{ number_format($limites->limite_maximo, 4) }} {{ $limites->unidade }}
                        @elseif($limites->limite_minimo)
                            Mínimo: {{ number_format($limites->limite_minimo, 4) }} {{ $limites->unidade }}
                        @endif
                    </div>
                </div>
            </div>
        @endif

        <!-- Gráfico de Linha -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900">
                    <i class="fas fa-chart-line mr-2 text-blue-600"></i>
                    Evolução Temporal - {{ $nomeParametro }}
                </h3>
            </div>
            <div class="p-6">
                <div class="relative" style="height: 400px;">
                    <canvas id="chartLinha"></canvas>
                </div>
            </div>
        </div>

        <!-- Gráfico de Barras -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900">
                    <i class="fas fa-chart-bar mr-2 text-blue-600"></i>
                    Comparação por Coleta - {{ $nomeParametro }}
                </h3>
            </div>
            <div class="p-6">
                <div class="relative" style="height: 400px;">
                    <canvas id="chartBarra"></canvas>
                </div>
                <div class="mt-4 flex justify-center space-x-4">
                    <button onclick="downloadChart('chartBarra', 'png')" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors">
                        <i class="fas fa-download mr-2"></i>Baixar PNG
                    </button>
                    <button onclick="downloadChart('chartBarra', 'svg')" class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 transition-colors">
                        <i class="fas fa-download mr-2"></i>Baixar SVG
                    </button>
                </div>
            </div>
        </div>

        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script>
        const labels = {!! json_encode($labels) !!};
        const dados = {!! json_encode($dados) !!};
        const cores = {!! json_encode($cores) !!};

        // Configurações dos limites
        const limiteMin = {{ $limites && $limites->limite_minimo ? $limites->limite_minimo : 'null' }};
        const limiteMax = {{ $limites && $limites->limite_maximo ? $limites->limite_maximo : 'null' }};

        // Gráfico de Linha
        const ctxLinha = document.getElementById('chartLinha').getContext('2d');
        const chartLinha = new Chart(ctxLinha, {
            type: 'line',
            data: {
                labels: labels,
                datasets: [{
                    label: '{{ $nomeParametro }}',
                    data: dados,
                    borderColor: 'rgb(59, 130, 246)',
                    backgroundColor: 'rgba(59, 130, 246, 0.1)',
                    borderWidth: 2,
                    tension: 0.4,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: true,
                        position: 'top'
                    },
                    title: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: {{ $limites && $limites->limite_minimo ? 'false' : 'true' }}
                    }
                }
            }
        });

        // Adicionar linhas de limite se existirem
        if (limiteMin !== null) {
            chartLinha.data.datasets.push({
                label: 'Limite Mínimo',
                data: Array(dados.length).fill(limiteMin),
                borderColor: 'rgb(234, 179, 8)',
                borderWidth: 2,
                borderDash: [5, 5],
                fill: false,
                pointRadius: 0
            });
        }
        if (limiteMax !== null) {
            chartLinha.data.datasets.push({
                label: 'Limite Máximo',
                data: Array(dados.length).fill(limiteMax),
                borderColor: 'rgb(239, 68, 68)',
                borderWidth: 2,
                borderDash: [5, 5],
                fill: false,
                pointRadius: 0
            });
        }
        chartLinha.update();

        // Gráfico de Barras
        const ctxBarra = document.getElementById('chartBarra').getContext('2d');
        const chartBarra = new Chart(ctxBarra, {
            type: 'bar',
            data: {
                labels: labels,
                datasets: [{
                    label: '{{ $nomeParametro }}',
                    data: dados,
                    backgroundColor: cores,
                    borderColor: cores.map(c => c.replace('0.7', '1')),
                    borderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: {{ $limites && $limites->limite_minimo ? 'false' : 'true' }}
                    }
                }
            }
        });

        // Função para download
        function downloadChart(chartId, format) {
            const chart = chartId === 'chartBarra' ? chartBarra : chartLinha;
            const canvas = chart.canvas;

            if (format === 'png') {
                const url = canvas.toDataURL('image/png');
                const link = document.createElement('a');
                link.download = 'grafico-{{ $parametro }}-' + new Date().getTime() + '.png';
                link.href = url;
                link.click();
            } else if (format === 'svg') {
                // SVG export requer biblioteca adicional
                alert('Export SVG requer configuração adicional. Use PNG por enquanto.');
            }
        }
        </script>

    @else
        <div class="bg-white rounded-lg shadow p-12">
            <div class="text-center text-gray-500">
                <i class="fas fa-chart-line text-6xl mb-4 text-gray-300"></i>
                <h3 class="text-xl font-semibold mb-2">Nenhum dado disponível</h3>
                <p>Não há coletas registradas para o período selecionado ou o parâmetro escolhido não possui dados.</p>
            </div>
        </div>
    @endif
</div>
@endsection
