<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ChartController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Chart data endpoints
Route::get('/barragens/{barragem}/chart-data', [ChartController::class, 'barragemData'])->name('api.barragens.chart-data');

// Gráficos Dashboard endpoints
Route::get('/graficos-barragem/dados', [App\Http\Controllers\Api\GraficosBarragemController::class, 'getDados'])->name('api.graficos-barragem.dados');

// Correspondências de Curvas endpoints
Route::prefix('correspondencias-curvas')->group(function () {
    Route::get('/barragem/{barragem}', [App\Http\Controllers\CorrespondenciaCurvasController::class, 'getDadosBarragem']);
    Route::post('/calcular', [App\Http\Controllers\CorrespondenciaCurvasController::class, 'calcularCorrespondencias']);
    Route::get('/tabela/{barragem}', [App\Http\Controllers\CorrespondenciaCurvasController::class, 'gerarTabelaCorrespondencias']);
    Route::get('/validar/{barragem}', [App\Http\Controllers\CorrespondenciaCurvasController::class, 'validarCurvas']);
});

// Estatísticas - Médias Aritméticas (Fase I)
Route::prefix('estatisticas')->group(function () {
    Route::get('/precipitacao', [App\Http\Controllers\Api\EstatisticasController::class, 'mediasPrecipitacao'])->name('api.estatisticas.precipitacao');
    Route::get('/cotas-barragens', [App\Http\Controllers\Api\EstatisticasController::class, 'mediasCotasBarragens'])->name('api.estatisticas.cotas-barragens');
    Route::get('/niveis-estacoes', [App\Http\Controllers\Api\EstatisticasController::class, 'mediasNiveisEstacoes'])->name('api.estatisticas.niveis-estacoes');
    Route::get('/resumo', [App\Http\Controllers\Api\EstatisticasController::class, 'resumo'])->name('api.estatisticas.resumo');
});
